/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.ScanResult;
import android.os.Build;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=ScanResult.class)
public class ShadowScanResult {
    @RealObject
    ScanResult realObject;

    public static ScanResult newInstance(String SSID, String BSSID, String caps, int level, int frequency) {
        return ShadowScanResult.newInstance(SSID, BSSID, caps, level, frequency, false);
    }

    public static ScanResult newInstance(String SSID, String BSSID, String caps, int level, int frequency, boolean is80211McRTTResponder) {
        ScanResult scanResult = (ScanResult)Shadow.newInstanceOf(ScanResult.class);
        scanResult.SSID = SSID;
        scanResult.BSSID = BSSID;
        scanResult.capabilities = caps;
        scanResult.level = level;
        scanResult.frequency = frequency;
        if (Build.VERSION.SDK_INT >= 28) {
            if (is80211McRTTResponder) {
                scanResult.setFlag(2L);
            } else {
                scanResult.setFlag(0L);
            }
        }
        return scanResult;
    }

    @Implementation
    public String toString() {
        StringBuilder sb = new StringBuilder().append("SSID: ").append(this.valueOrNone(this.realObject.SSID)).append(", BSSID: ").append(this.valueOrNone(this.realObject.BSSID)).append(", capabilities: ").append(this.valueOrNone(this.realObject.capabilities)).append(", level: ").append(this.realObject.level).append(", frequency: ").append(this.realObject.frequency);
        if (Build.VERSION.SDK_INT >= 28) {
            sb.append(", flags: ").append(this.realObject.flags);
        }
        return sb.toString();
    }

    private String valueOrNone(String value) {
        return value == null ? "<none>" : value;
    }
}

