/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;

@Implements(value=SharedMemory.class, minSdk=27, isInAndroidSdk=false)
public class ShadowSharedMemory {
    private static final Map<Integer, File> filesByFd = new ConcurrentHashMap<Integer, File>();
    private static final AtomicReference<ErrnoException> fakeCreateException = new AtomicReference();
    @RealObject
    private SharedMemory realObject;

    @Resetter
    public static void reset() {
        filesByFd.clear();
    }

    @Implementation
    protected ByteBuffer map(int prot, int offset, int length) throws ErrnoException {
        MappedByteBuffer mappedByteBuffer;
        ReflectionHelpers.callInstanceMethod((Object)this.realObject, (String)"checkOpen", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        FileDescriptor fileDescriptor = this.getRealFileDescriptor();
        int fd = (Integer)ReflectionHelpers.getField((Object)fileDescriptor, (String)"fd");
        File file = filesByFd.get(fd);
        if (file == null) {
            throw new IllegalStateException("Cannot find the backing file from fd");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, length);
        }
        catch (Throwable throwable) {
            try {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ErrnoException(e.getMessage(), OsConstants.EIO, (Throwable)e);
            }
        }
        randomAccessFile.close();
        return mappedByteBuffer;
    }

    @Implementation
    protected static void unmap(ByteBuffer mappedBuf) throws ErrnoException {
        if (!(mappedBuf instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("ByteBuffer wasn't created by #map(int, int, int); can't unmap");
        }
    }

    @Implementation
    protected static FileDescriptor nCreate(String name, int size) throws ErrnoException {
        ShadowSharedMemory.maybeThrow(fakeCreateException);
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        try {
            String string = String.valueOf(name);
            File sharedMemoryFile = Files.createTempFile(tempDirectory.createIfNotExists("SharedMemory"), string.length() != 0 ? "shmem-".concat(string) : new String("shmem-"), ".tmp", new FileAttribute[0]).toFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(sharedMemoryFile, "rw");
            randomAccessFile.setLength(0L);
            randomAccessFile.setLength(size);
            FileDescriptor fileDescriptor = randomAccessFile.getFD();
            int fd = (Integer)ReflectionHelpers.getField((Object)fileDescriptor, (String)"fd");
            filesByFd.put(fd, sharedMemoryFile);
            return fileDescriptor;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file descriptior", e);
        }
    }

    @Implementation
    protected static int nGetSize(FileDescriptor fd) {
        int internalFd = (Integer)ReflectionHelpers.getField((Object)fd, (String)"fd");
        return (int)filesByFd.get(internalFd).length();
    }

    private FileDescriptor getRealFileDescriptor() {
        return (FileDescriptor)ReflectionHelpers.getField((Object)this.realObject, (String)"mFileDescriptor");
    }

    public static void setCreateShouldThrow(ErrnoException e) {
        fakeCreateException.set(e);
    }

    private static void maybeThrow(AtomicReference<ErrnoException> exceptionRef) throws ErrnoException {
        ErrnoException exception = exceptionRef.get();
        if (exception != null) {
            throw exception;
        }
    }
}

