/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbComTreeConnectAndXResponse;
import jcifs.smb.SmbComTreeDisconnect;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.util.LogStream;

class SmbTree {
    private static final String DEFAULT_SERVICE = Config.getProperty("jcifs.smb.client.serviceType", "?????");
    private int tid;
    private String share;
    String service = DEFAULT_SERVICE;
    SmbSession session;
    boolean treeConnected;
    boolean inDfs;

    SmbTree(SmbSession session, String share, String service) {
        this.session = session;
        this.share = share.toUpperCase();
        if (service != null && !service.startsWith("??")) {
            this.service = service;
        }
    }

    boolean matches(String share, String service) {
        return this.share.equalsIgnoreCase(share) && (service == null || service.startsWith("??") || this.service.equalsIgnoreCase(service));
    }

    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        this.treeConnect(null, null);
        if (!this.service.equals("A:")) {
            switch (request.subCommand & 0xFF) {
                case 0: 
                case 16: 
                case 35: 
                case 38: 
                case 83: 
                case 84: 
                case 104: 
                case 215: {
                    break;
                }
                default: {
                    throw new SmbException("Invalid operation for " + this.service + " service");
                }
            }
        }
        request.tid = this.tid;
        if (this.inDfs && request.path != null && request.path.length() > 0) {
            request.path = '\\' + this.session.transport().tconHostName + '\\' + this.share + request.path;
        }
        this.session.sendTransaction(request, response);
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        this.treeConnect(request, response);
        if (request == null || response != null && response.received) {
            return;
        }
        if (!this.service.equals("A:")) {
            switch (request.command) {
                case -94: 
                case 4: 
                case 45: 
                case 46: 
                case 47: 
                case 113: {
                    break;
                }
                default: {
                    throw new SmbException("Invalid operation for " + this.service + " service");
                }
            }
        }
        request.tid = this.tid;
        if (this.inDfs && request.path != null && request.path.length() > 0) {
            request.flags2 = 4096;
            request.path = '\\' + this.session.transport().tconHostName + '\\' + this.share + request.path;
        }
        this.session.send(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeConnect(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            if (this.treeConnected) {
                return;
            }
            this.session.transport.negotiate();
            String unc = "\\\\" + this.session.transport.tconHostName + '\\' + this.share;
            SmbTransport cfr_ignored_0 = this.session.transport;
            if (LogStream.level > 2) {
                SmbTransport cfr_ignored_1 = this.session.transport;
                SmbTransport.log.println("treeConnect: unc=" + unc + ",service=" + this.service);
            }
            SmbComTreeConnectAndXResponse response = new SmbComTreeConnectAndXResponse(andxResponse);
            SmbComTreeConnectAndX request = new SmbComTreeConnectAndX(this.session, unc, this.service, andx);
            this.session.send(request, response);
            this.tid = response.tid;
            this.service = response.service;
            this.inDfs = response.shareIsInDfs;
            this.treeConnected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeDisconnect(boolean inError) {
        SmbTransport smbTransport = this.session.transport;
        synchronized (smbTransport) {
            if (!this.treeConnected) {
                return;
            }
            if (!inError) {
                try {
                    this.send(new SmbComTreeDisconnect(), null);
                }
                catch (SmbException smbException) {
                    // empty catch block
                }
            }
            this.treeConnected = false;
        }
    }

    public String toString() {
        return "SmbTree[share=" + this.share + ",service=" + this.service + ",tid=" + this.tid + ",inDfs=" + this.inDfs + ",treeConnected=" + this.treeConnected + "]";
    }
}

