/*
 * Decompiled with CFR 0.152.
 */
package org.savara.activity;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.savara.activity.ActivityAnalyser;
import org.savara.activity.ActivityFilter;
import org.savara.activity.ActivityNotifier;
import org.savara.activity.ActivityProcessor;
import org.savara.activity.ActivityStore;
import org.savara.activity.ActivityValidator;
import org.savara.activity.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActivityProcessor
implements ActivityProcessor {
    private List<ActivityAnalyser> m_analysers = null;
    private List<ActivityFilter> m_filters = null;
    private List<ActivityValidator> m_validators = null;
    private List<ActivityStore> m_stores = null;
    private List<ActivityNotifier> m_notifiers = null;

    @Override
    public List<ActivityAnalyser> getAnalysers() {
        if (this.m_analysers == null) {
            this.m_analysers = new Vector<ActivityAnalyser>();
        }
        return this.m_analysers;
    }

    @Override
    public void setAnalysers(List<ActivityAnalyser> analysers) {
        this.m_analysers = analysers;
    }

    @Override
    public List<ActivityFilter> getFilters() {
        if (this.m_filters == null) {
            this.m_filters = new Vector<ActivityFilter>();
        }
        return this.m_filters;
    }

    @Override
    public void setFilters(List<ActivityFilter> filters) {
        this.m_filters = filters;
    }

    @Override
    public List<ActivityValidator> getValidators() {
        if (this.m_validators == null) {
            this.m_validators = new Vector<ActivityValidator>();
        }
        return this.m_validators;
    }

    @Override
    public void setValidators(List<ActivityValidator> validators) {
        this.m_validators = validators;
    }

    @Override
    public List<ActivityStore> getStores() {
        if (this.m_stores == null) {
            this.m_stores = new Vector<ActivityStore>();
        }
        return this.m_stores;
    }

    @Override
    public void setStores(List<ActivityStore> stores) {
        this.m_stores = stores;
    }

    @Override
    public List<ActivityNotifier> getNotifiers() {
        if (this.m_notifiers == null) {
            this.m_notifiers = new Vector<ActivityNotifier>();
        }
        return this.m_notifiers;
    }

    @Override
    public void setNotifiers(List<ActivityNotifier> notifiers) {
        this.m_notifiers = notifiers;
    }

    @Override
    public void process(Activity activity) {
        ActivityFilter af;
        for (ActivityAnalyser aa : this.getAnalysers()) {
            aa.analyse(activity);
        }
        boolean process = this.getFilters().size() == 0;
        Iterator<Object> i$ = this.getFilters().iterator();
        while (i$.hasNext() && !(process = (af = i$.next()).isRelevant(activity))) {
        }
        if (process) {
            for (ActivityValidator av : this.getValidators()) {
                av.validate(activity);
            }
            for (ActivityStore as : this.getStores()) {
                as.save(activity);
            }
            for (ActivityNotifier an : this.getNotifiers()) {
                an.publish(activity);
            }
        }
    }
}

