/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.monitor.Message;
import org.scribble.protocol.monitor.DefaultMonitorContext;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Annotation;
import org.scribble.protocol.monitor.model.MessageNode;

public class DefautMonitorContext
extends DefaultMonitorContext {
    private static final Logger LOG = Logger.getLogger(DefautMonitorContext.class.getName());
    private static Map<MessageNode, String> _faultNames = new HashMap<MessageNode, String>();

    public Result validate(Session session, MessageNode mesgNode, org.scribble.protocol.monitor.Message mesg) {
        Result ret = super.validate(session, mesgNode, mesg);
        if (ret != null && ret.isValid() && mesg instanceof Message) {
            String mesgFaultName = ((Message)mesg).getFault();
            String nodeFaultName = _faultNames.get(mesgNode);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Node fault name '" + nodeFaultName + "'");
            }
            if (nodeFaultName == null) {
                List annotations = mesgNode.getAnnotation();
                for (Annotation ann : annotations) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Checking annotation ID=" + ann.getId() + " VALUE=" + ann.getValue());
                    }
                    if (!ann.getValue().startsWith(" Fault(")) continue;
                    int startpos = ann.getValue().indexOf("name=");
                    int endpos = ann.getValue().indexOf(")");
                    if (startpos == -1 || endpos == -1) break;
                    nodeFaultName = ann.getValue().substring(startpos + 5, endpos);
                    if (!LOG.isLoggable(Level.FINEST)) break;
                    LOG.finest("Extracted fault name '" + nodeFaultName + "' from node annotation");
                    break;
                }
                if (nodeFaultName == null) {
                    nodeFaultName = "";
                }
                _faultNames.put(mesgNode, nodeFaultName);
            }
            if (nodeFaultName.length() > 0) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Compare message fault name '" + mesgFaultName + "' against node '" + nodeFaultName + "'");
                }
                if (mesgFaultName == null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Message node had fault '" + nodeFaultName + "', but message had no fault");
                    }
                    ret = Result.INVALID;
                } else if (!mesgFaultName.equals(nodeFaultName)) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Message node had fault '" + nodeFaultName + "' not compatible with message fault '" + mesgFaultName + "'");
                    }
                    ret = Result.INVALID;
                }
            } else if (mesgFaultName != null && mesgFaultName.trim().length() > 0) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Message had fault '" + mesgFaultName + "', but node had no fault");
                }
                ret = Result.INVALID;
            }
        }
        return ret;
    }
}

