/*
 * Decompiled with CFR 0.152.
 */
package org.savara.protocol.model.util;

import java.util.List;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

public class InteractionUtil {
    public static String getName(Interaction interaction) {
        String ret = null;
        ret = InteractionUtil.isSend(interaction) ? "Send" : "Receive";
        for (TypeReference ref : interaction.getMessageSignature().getTypeReferences()) {
            ret = ret + "_" + ref.getName();
        }
        return ret;
    }

    public static boolean isSend(Interaction interaction) {
        Role role = null;
        if (interaction.getEnclosingProtocol() != null) {
            role = interaction.getEnclosingProtocol().getLocatedRole();
        }
        return InteractionUtil.isSend(interaction, role);
    }

    public static boolean isSend(Interaction interaction, Role role) {
        boolean ret = false;
        if (role != null && (interaction.getFromRole() != null && interaction.getFromRole().equals((Object)role) || interaction.getToRoles().size() > 0 && !interaction.getToRoles().contains(role))) {
            ret = true;
        }
        return ret;
    }

    public static String getRequestLabel(Interaction interaction) {
        String ret = null;
        Annotation annotation = AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Correlation");
        if (annotation != null) {
            ret = (String)annotation.getProperties().get("request");
        }
        return ret;
    }

    public static String getReplyToLabel(Interaction interaction) {
        String ret = null;
        Annotation annotation = AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Correlation");
        if (annotation != null) {
            ret = (String)annotation.getProperties().get("replyTo");
        }
        return ret;
    }

    public static boolean isRequest(Interaction interaction) {
        boolean ret = false;
        if (InteractionUtil.getRequestLabel(interaction) != null || InteractionUtil.getReplyToLabel(interaction) == null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isResponse(Interaction interaction) {
        boolean ret = false;
        if (InteractionUtil.getReplyToLabel(interaction) != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isFaultResponse(Interaction interaction) {
        boolean ret = false;
        if (InteractionUtil.isResponse(interaction) && AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Fault") != null) {
            ret = true;
        }
        return ret;
    }

    public static String getFaultName(Interaction interaction) {
        String ret = null;
        Annotation annotation = AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Fault");
        if (annotation != null) {
            ret = (String)annotation.getProperties().get("name");
        }
        return ret;
    }
}

