/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.cdm;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Channel;
import org.pi4soa.service.DefaultMessage;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.projection.BehaviorProjection;
import org.pi4soa.service.monitor.MonitorConfiguration;
import org.pi4soa.service.monitor.ServiceMonitor;
import org.pi4soa.service.monitor.ServiceMonitorFactory;
import org.pi4soa.service.monitor.XMLMonitorConfiguration;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.tracker.ServiceTracker;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.simulation.SimulationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMRoleSimulator
implements RoleSimulator {
    private static final String WS_CDL_SIMULATOR = "WS-CDL simulator";
    private static final String CDM_FILE_EXTENSION = ".cdm";
    private static final Logger logger = Logger.getLogger(CDMRoleSimulator.class.getName());

    public String getName() {
        return WS_CDL_SIMULATOR;
    }

    public boolean isSupported(SimulationModel model) {
        return model.getName().endsWith(CDM_FILE_EXTENSION);
    }

    public Object getModel(SimulationModel model) {
        Package ret = null;
        if (model.getName().endsWith(CDM_FILE_EXTENSION)) {
            try {
                ret = CDLManager.load((InputStream)model.getContents());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load CDM model", e);
            }
        }
        return ret;
    }

    protected Role getRole(ParticipantType pt) {
        String ns = CDLTypeUtil.getNamespace((String)pt.getName(), (CDLType)pt, (boolean)true);
        String lp = XMLUtils.getLocalname((String)pt.getName());
        Role r = new Role();
        r.setName(new QName(ns, lp).toString());
        return r;
    }

    protected Role getRole(Participant p) {
        String ns = CDLTypeUtil.getNamespace((String)p.getName(), (CDLType)p, (boolean)true);
        String lp = XMLUtils.getLocalname((String)p.getName());
        Role r = new Role();
        r.setName(new QName(ns, lp).toString());
        return r;
    }

    public List<Role> getModelRoles(Object model) {
        Vector<Role> ret = new Vector<Role>();
        if (model instanceof Package) {
            EList partTypes = ((Package)model).getTypeDefinitions().getParticipantTypes();
            for (ParticipantType pt : partTypes) {
                ret.add(this.getRole(pt));
            }
            List parts = ((Package)model).getParticipants();
            for (Participant p : parts) {
                ret.add(this.getRole(p));
            }
        }
        return ret;
    }

    public void initialize(SimulationContext context) throws Exception {
        if (!(context.getModel() instanceof ServiceDescription)) {
            throw new Exception("Model is not CDL");
        }
        XMLMonitorConfiguration config = new XMLMonitorConfiguration();
        SimulationHandlerProxy tracker = new SimulationHandlerProxy();
        context.getProperties().put(SimulationHandlerProxy.class.getName(), tracker);
        config.setServiceTracker((ServiceTracker)tracker);
        config.setEvaluateState(true);
        ServiceMonitor mon = ServiceMonitorFactory.getServiceMonitor((MonitorConfiguration)config);
        mon.getConfiguration().getServiceRepository().addServiceDescription((ServiceDescription)context.getModel());
        context.getProperties().put(ServiceMonitor.class.getName(), mon);
    }

    public Object getModelForRole(Object model, Role role) {
        ServiceDescription ret = null;
        if (model instanceof Package) {
            Package cdlpack = (Package)model;
            EList participants = cdlpack.getTypeDefinitions().getParticipantTypes();
            Iterator iter = participants.iterator();
            while (ret == null && iter.hasNext()) {
                ParticipantType partType = (ParticipantType)iter.next();
                Role r = this.getRole(partType);
                if (!r.getName().equals(role.getName())) continue;
                try {
                    ret = BehaviorProjection.projectServiceDescription((Package)cdlpack, (ParticipantType)partType, null);
                }
                catch (ServiceException se) {
                    logger.severe("Failed to project service description '" + partType.getName() + "'");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SimulationContext context, Event event, SimulationHandler handler) {
        ServiceMonitor mon = (ServiceMonitor)context.getProperties().get(ServiceMonitor.class.getName());
        SimulationHandlerProxy proxy = (SimulationHandlerProxy)context.getProperties().get(SimulationHandlerProxy.class.getName());
        if (mon != null && proxy != null) {
            ServiceMonitor serviceMonitor = mon;
            synchronized (serviceMonitor) {
                block15: {
                    proxy.setEvent(event);
                    proxy.setSimulationHandler(handler);
                    if (event instanceof MessageEvent) {
                        MessageEvent me = (MessageEvent)event;
                        if (me.getParameter().size() == 1) {
                            Message mesg;
                            String type = ((Parameter)me.getParameter().get(0)).getType();
                            String path = ((Parameter)me.getParameter().get(0)).getValue();
                            String value = null;
                            if (path != null) {
                                try {
                                    InputStream is = context.getResource(path);
                                    byte[] b = new byte[is.available()];
                                    is.read(b);
                                    is.close();
                                    value = new String(b);
                                }
                                catch (Exception e) {
                                    handler.error("Failed to obtain message value", event, (Throwable)e);
                                }
                            }
                            if ((mesg = mon.createMessage(type, null, null, value, null, null)) instanceof DefaultMessage) {
                                ((DefaultMessage)mesg).setOperationName(me.getOperationName());
                                ((DefaultMessage)mesg).setFaultName(me.getFaultName());
                            }
                            try {
                                if (event instanceof SendEvent) {
                                    mon.messageSent(mesg);
                                    break block15;
                                }
                                mon.messageReceived(mesg);
                            }
                            catch (OutOfSequenceMessageException oosme) {
                            }
                            catch (Exception e) {
                                handler.error("Failed to simulate message", event, (Throwable)e);
                            }
                        } else {
                            handler.error("Cannot simulate event as does not have single parameter", event, null);
                        }
                    }
                }
            }
        }
        handler.error("Service monitor not configured", event, null);
    }

    public void close(SimulationContext context) throws Exception {
    }

    public static class SimulationHandlerProxy
    implements ServiceTracker {
        private SimulationHandler m_handler = null;
        private Event m_event = null;

        public void setSimulationHandler(SimulationHandler handler) {
            this.m_handler = handler;
        }

        public void setEvent(Event event) {
            this.m_event = event;
        }

        public void close() throws ServiceException {
        }

        public void error(Session arg0, String mesg, Throwable e) {
            this.m_handler.error(mesg, this.m_event, e);
        }

        public void information(Session arg0, String arg1) {
        }

        public void initialize() throws ServiceException {
        }

        public void receivedMessage(MessageDefinition arg0, Message arg1) {
            if (!this.m_event.isErrorExpected()) {
                this.m_handler.processed(this.m_event);
            } else {
                this.m_handler.error("Error was expected but did not occur", this.m_event, null);
            }
        }

        public void receivedMessage(Receive arg0, Session arg1, Channel arg2, Message arg3) {
            if (!this.m_event.isErrorExpected()) {
                this.m_handler.processed(this.m_event);
            } else {
                this.m_handler.error("Error was expected but did not occur", this.m_event, null);
            }
        }

        public void sentMessage(MessageDefinition arg0, Message arg1) {
            if (!this.m_event.isErrorExpected()) {
                this.m_handler.processed(this.m_event);
            } else {
                this.m_handler.error("Error was expected but did not occur", this.m_event, null);
            }
        }

        public void sentMessage(Send arg0, Session arg1, Channel arg2, Message arg3) {
            if (!this.m_event.isErrorExpected()) {
                this.m_handler.processed(this.m_event);
            } else {
                this.m_handler.error("Error was expected but did not occur", this.m_event, null);
            }
        }

        public void serviceFinished(ServiceDescription arg0, Session arg1) {
        }

        public void serviceStarted(ServiceDescription arg0, Session arg1) {
        }

        public void subSessionFinished(Session arg0, Session arg1) {
        }

        public void subSessionStarted(Session arg0, Session arg1) {
        }

        public void unexpectedMessage(ServiceDescription arg0, Session arg1, Message arg2, String arg3) {
            if (!this.m_event.isErrorExpected()) {
                this.m_handler.unexpected(this.m_event);
            } else {
                this.m_handler.processed(this.m_event);
            }
        }

        public void unhandledException(Session arg0, String arg1) {
            this.m_handler.unexpected(this.m_event);
        }

        public void warning(Session arg0, String arg1, Throwable arg2) {
        }
    }
}

