/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.scenario.simulation.SimulationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSimulationContext
implements SimulationContext {
    private File m_scenarioFile = null;
    private Object m_model = null;
    private Map<String, Object> m_properties = new HashMap<String, Object>();
    private static final Logger logger = Logger.getLogger(DefaultSimulationContext.class.getName());

    public DefaultSimulationContext(File scenarioFile) {
        this.m_scenarioFile = scenarioFile;
    }

    public void setModel(Object model) {
        this.m_model = model;
    }

    @Override
    public Object getModel() {
        return this.m_model;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public InputStream getResource(String path) throws IOException {
        InputStream ret = null;
        if (path.startsWith("http:") || path.startsWith("https:")) {
            URL url = new URL(path);
            ret = url.openStream();
        } else {
            String baseFolder = this.m_scenarioFile.getParent();
            path = baseFolder + File.separatorChar + path;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading value from '" + path + "'");
            }
            ret = new FileInputStream(path);
        }
        return ret;
    }
}

