/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.savara.scenario.simulation.RoleSimulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleSimulatorFactory {
    private static Map<String, RoleSimulator> m_roleSimulators = new HashMap<String, RoleSimulator>();
    private static final Logger logger = Logger.getLogger(RoleSimulatorFactory.class.getName());

    public static void register(RoleSimulator rsim) {
        logger.info("Registering role simulator: " + rsim.getName());
        m_roleSimulators.put(rsim.getName(), rsim);
    }

    public static void unregister(RoleSimulator rsim) {
        logger.info("Unregistering role simulator: " + rsim.getName());
        m_roleSimulators.remove(rsim.getName());
    }

    public static List<RoleSimulator> getRoleSimulators() {
        Vector<RoleSimulator> ret = new Vector<RoleSimulator>(m_roleSimulators.values());
        Collections.sort(ret, new Comparator<RoleSimulator>(){

            @Override
            public int compare(RoleSimulator o1, RoleSimulator o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        return ret;
    }

    public static RoleSimulator getRoleSimulator(String name) {
        return m_roleSimulators.get(name);
    }
}

