/*
 * Decompiled with CFR 0.152.
 */
package org.savara.wsdl.generator.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.logging.MessageFormatter;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.contract.model.Contract;
import org.savara.contract.model.FaultDetails;
import org.savara.contract.model.Interface;
import org.savara.contract.model.MessageExchangePattern;
import org.savara.contract.model.Namespace;
import org.savara.contract.model.RequestResponseMEP;
import org.savara.contract.model.Type;
import org.savara.contract.model.TypeDefinition;
import org.savara.wsdl.generator.WSDLBinding;
import org.savara.wsdl.generator.WSDLGenerator;
import org.savara.wsdl.util.WSDLGeneratorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGeneratorImpl
implements WSDLGenerator {
    public static final String BINDING_SUFFIX = "Binding";
    private static Logger logger = Logger.getLogger(WSDLGeneratorImpl.class.getName());

    @Override
    public List<Definition> generate(Contract contract, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Vector<Definition> ret = new Vector<Definition>();
        try {
            Definition main = this.getDefinition(ret, contract, contract.getNamespace(), wsdlBinding);
            if (main == null) {
                return ret;
            }
            Service service = main.createService();
            service.setQName(new QName(contract.getNamespace(), contract.getName() + "Service"));
            main.addService(service);
            for (Interface intf : contract.getInterfaces()) {
                PortType portType = this.createPortType(ret, contract, intf, wsdlBinding, handler);
                Binding binding = this.createBinding(ret, contract, intf, portType, wsdlBinding, handler);
                Port port = main.createPort();
                port.setName(intf.getName() + "Port");
                port.setBinding(binding);
                service.addPort(port);
                if (wsdlBinding == null) continue;
                wsdlBinding.updatePort(main, port);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate WSDL", e);
        }
        return ret;
    }

    protected Definition getDefinition(List<Definition> wsdls, Contract contract, String targetNamespace, WSDLBinding wsdlBinding) {
        Definition ret = null;
        if (targetNamespace != null) {
            for (int i = 0; ret == null && i < wsdls.size(); ++i) {
                ret = wsdls.get(i);
                if (ret.getTargetNamespace() != null && ret.getTargetNamespace().equals(targetNamespace)) continue;
                ret = null;
            }
            if (ret == null && (ret = this.createDefinition(contract, targetNamespace)) != null) {
                if (wsdlBinding != null) {
                    wsdlBinding.initDefinition(ret);
                }
                wsdls.add(ret);
            }
        }
        return ret;
    }

    protected Definition createDefinition(Contract contract, String targetNamespace) {
        Definition ret = null;
        try {
            WSDLFactory fact = WSDLFactory.newInstance();
            ret = fact.newDefinition();
            if (contract.getName() != null) {
                ret.setQName(new QName(contract.getName()));
            }
            ret.setTargetNamespace(targetNamespace);
            Vector nss = new Vector(contract.getNamespaces());
            Collections.sort(nss, new Comparator<Namespace>(){

                @Override
                public int compare(Namespace o1, Namespace o2) {
                    return o2.getPrefix().compareTo(o1.getPrefix());
                }
            });
            for (Namespace ns : nss) {
                ret.addNamespace(ns.getPrefix(), ns.getURI());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to create WSDL definition for target namespace '" + targetNamespace + "'", e);
        }
        return ret;
    }

    public PortType createPortType(List<Definition> wsdls, Contract contract, Interface intf, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Definition defn;
        PortType ret = null;
        if (intf != null && (defn = this.getDefinition(wsdls, contract, intf.getNamespace(), wsdlBinding)) != null) {
            ret = defn.createPortType();
            ret.setUndefined(false);
            if (intf.getName() != null) {
                ret.setQName(new QName(intf.getNamespace(), intf.getName()));
            }
            for (int i = 0; i < intf.getMessageExchangePatterns().size(); ++i) {
                MessageExchangePattern mep = (MessageExchangePattern)intf.getMessageExchangePatterns().get(i);
                if (mep.getTypes().size() <= 0) continue;
                this.createOperation(wsdls, contract, ret, mep, wsdlBinding, handler);
            }
            if (ret != null && ret.getOperations().size() > 0) {
                defn.addPortType(ret);
            }
        }
        return ret;
    }

    public Binding createBinding(List<Definition> wsdls, Contract contract, Interface intf, PortType portType, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Definition defn;
        Binding ret = null;
        if (intf != null && (defn = this.getDefinition(wsdls, contract, intf.getNamespace(), wsdlBinding)) != null) {
            ret = defn.createBinding();
            ret.setUndefined(false);
            if (wsdlBinding != null) {
                wsdlBinding.updateBinding(defn, ret);
            }
            if (intf.getName() != null) {
                ret.setQName(new QName(intf.getNamespace(), intf.getName() + BINDING_SUFFIX));
            }
            ret.setPortType(portType);
            for (int i = 0; i < intf.getMessageExchangePatterns().size(); ++i) {
                MessageExchangePattern mep = (MessageExchangePattern)intf.getMessageExchangePatterns().get(i);
                if (mep.getTypes().size() <= 0) continue;
                this.createBindingOperation(wsdls, contract, ret, mep, wsdlBinding, handler);
            }
            if (ret != null && ret.getBindingOperations().size() > 0) {
                defn.addBinding(ret);
            }
        }
        return ret;
    }

    public Operation createOperation(List<Definition> wsdls, Contract contract, PortType portType, MessageExchangePattern mep, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Operation ret = null;
        Definition defn = null;
        if (portType != null) {
            defn = this.getDefinition(wsdls, contract, portType.getQName().getNamespaceURI(), wsdlBinding);
        }
        if (defn != null && mep != null) {
            ret = defn.createOperation();
            ret.setUndefined(false);
            ret.setName(mep.getOperation());
            QName msgname = WSDLGeneratorUtil.getRequestMessageType(portType.getQName().getNamespaceURI(), mep.getOperation(), null);
            Message mesg = this.getMessage(wsdls, contract, msgname, mep.getTypes(), wsdlBinding, handler);
            if (mesg != null) {
                Input input = defn.createInput();
                input.setMessage(mesg);
                ret.setInput(input);
            }
            if (mep instanceof RequestResponseMEP) {
                RequestResponseMEP rr = (RequestResponseMEP)mep;
                msgname = WSDLGeneratorUtil.getResponseMessageType(portType.getQName().getNamespaceURI(), mep.getOperation(), null);
                Message om = this.getMessage(wsdls, contract, msgname, rr.getResponseTypes(), wsdlBinding, handler);
                if (om != null) {
                    Output output = defn.createOutput();
                    output.setMessage(om);
                    ret.setOutput(output);
                }
                if (rr.getFaultDetails() != null) {
                    for (int i = 0; i < rr.getFaultDetails().size(); ++i) {
                        FaultDetails fd = (FaultDetails)rr.getFaultDetails().get(i);
                        msgname = WSDLGeneratorUtil.getFaultMessageType(portType.getQName().getNamespaceURI(), fd.getName(), null);
                        Message fm = this.getMessage(wsdls, contract, msgname, fd.getTypes(), wsdlBinding, handler);
                        if (fm == null) continue;
                        Fault fault = defn.createFault();
                        fault.setName(fd.getName());
                        fault.setMessage(fm);
                        ret.addFault(fault);
                    }
                }
            }
            portType.addOperation(ret);
        }
        return ret;
    }

    public BindingOperation createBindingOperation(List<Definition> wsdls, Contract contract, Binding binding, MessageExchangePattern mep, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        BindingOperation ret = null;
        Definition defn = null;
        if (binding != null) {
            defn = this.getDefinition(wsdls, contract, binding.getQName().getNamespaceURI(), wsdlBinding);
        }
        if (defn != null && mep != null) {
            ret = defn.createBindingOperation();
            if (wsdlBinding != null) {
                wsdlBinding.updateOperation(defn, mep, ret);
            }
            ret.setName(mep.getOperation());
            QName msgname = WSDLGeneratorUtil.getRequestMessageType(binding.getQName().getNamespaceURI(), mep.getOperation(), null);
            Message mesg = this.getMessage(wsdls, contract, msgname, mep.getTypes(), wsdlBinding, handler);
            if (mesg != null) {
                BindingInput input = defn.createBindingInput();
                if (wsdlBinding != null) {
                    wsdlBinding.updateInput(defn, input);
                }
                ret.setBindingInput(input);
            }
            if (mep instanceof RequestResponseMEP) {
                RequestResponseMEP rr = (RequestResponseMEP)mep;
                msgname = WSDLGeneratorUtil.getResponseMessageType(binding.getQName().getNamespaceURI(), mep.getOperation(), null);
                Message om = this.getMessage(wsdls, contract, msgname, rr.getResponseTypes(), wsdlBinding, handler);
                if (om != null) {
                    BindingOutput output = defn.createBindingOutput();
                    if (wsdlBinding != null) {
                        wsdlBinding.updateOutput(defn, output);
                    }
                    ret.setBindingOutput(output);
                }
                if (rr.getFaultDetails() != null) {
                    for (int i = 0; i < rr.getFaultDetails().size(); ++i) {
                        FaultDetails fd = (FaultDetails)rr.getFaultDetails().get(i);
                        msgname = WSDLGeneratorUtil.getFaultMessageType(binding.getQName().getNamespaceURI(), fd.getName(), null);
                        Message fm = this.getMessage(wsdls, contract, msgname, fd.getTypes(), wsdlBinding, handler);
                        if (fm == null) continue;
                        BindingFault fault = defn.createBindingFault();
                        fault.setName(fd.getName());
                        if (wsdlBinding != null) {
                            wsdlBinding.updateFault(defn, fault);
                        }
                        ret.addBindingFault(fault);
                    }
                }
            }
            binding.addBindingOperation(ret);
        }
        return ret;
    }

    public Message getMessage(List<Definition> wsdls, Contract contract, QName msgname, List<Type> types, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Message ret = null;
        if (types == null || types.size() == 0) {
            throw new UnsupportedOperationException("Expecting single type reference");
        }
        if (types.size() > 1) {
            throw new UnsupportedOperationException("Currently only supports single type reference");
        }
        Type ref = types.get(0);
        TypeDefinition td = contract.getTypeDefinition(ref.getName());
        if (td != null && "xsd".equals(td.getTypeSystem())) {
            QName qname = QName.valueOf(td.getDataType());
            Definition defn = this.getDefinition(wsdls, contract, msgname.getNamespaceURI(), wsdlBinding);
            if (defn != null && qname != null && (ret = defn.getMessage(msgname)) == null) {
                ret = defn.createMessage();
                ret.setUndefined(false);
                ret.setQName(msgname);
                Part part = this.createPart(defn, td, qname, wsdlBinding, handler);
                ret.addPart(part);
                defn.addMessage(ret);
            }
        }
        return ret;
    }

    protected Part createPart(Definition defn, TypeDefinition td, QName qname, WSDLBinding wsdlBinding, FeedbackHandler handler) {
        Part part = defn.createPart();
        part.setName("content");
        if (AnnotationDefinitions.getAnnotation((List)td.getAnnotations(), (String)"XSDElement") != null) {
            part.setElementName(qname);
        } else {
            part.setTypeName(qname);
            if (!wsdlBinding.isXSDTypeMessagePartSupported()) {
                handler.error(MessageFormatter.format((ResourceBundle)PropertyResourceBundle.getBundle("org.savara.wsdl.Messages"), (String)"SAVARA-WSDL-00001", (Object[])new Object[]{wsdlBinding.getName(), qname.toString()}), null);
            }
        }
        return part;
    }
}

