/*
 * Decompiled with CFR 0.152.
 */
package org.savara.wsdl.generator.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.savara.contract.model.MessageExchangePattern;
import org.savara.wsdl.generator.WSDLBinding;

public class SOAPRPCWSDLBinding
implements WSDLBinding {
    private static Logger logger = Logger.getLogger(SOAPRPCWSDLBinding.class.getName());

    public String getName() {
        return "SOAP RPC";
    }

    public void initDefinition(Definition defn) {
        defn.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    }

    public void updateBinding(Definition defn, Binding binding) {
        try {
            SOAPBinding sb = (SOAPBinding)defn.getExtensionRegistry().createExtension(Binding.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding"));
            sb.setStyle("rpc");
            sb.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            binding.addExtensibilityElement((ExtensibilityElement)sb);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP binding", e);
        }
    }

    public void updateOperation(Definition defn, MessageExchangePattern mep, BindingOperation operation) {
        try {
            SOAPOperation soap = (SOAPOperation)defn.getExtensionRegistry().createExtension(BindingOperation.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation"));
            soap.setStyle("rpc");
            soap.setSoapActionURI("");
            operation.addExtensibilityElement((ExtensibilityElement)soap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP operation", e);
        }
    }

    public void updateInput(Definition defn, BindingInput input) {
        try {
            SOAPBody soap = (SOAPBody)defn.getExtensionRegistry().createExtension(BindingInput.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body"));
            soap.setUse("literal");
            soap.setNamespaceURI(defn.getTargetNamespace());
            input.addExtensibilityElement((ExtensibilityElement)soap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP body to input", e);
        }
    }

    public void updateOutput(Definition defn, BindingOutput output) {
        try {
            SOAPBody soap = (SOAPBody)defn.getExtensionRegistry().createExtension(BindingOutput.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body"));
            soap.setUse("literal");
            soap.setNamespaceURI(defn.getTargetNamespace());
            output.addExtensibilityElement((ExtensibilityElement)soap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP body to output", e);
        }
    }

    public void updateFault(Definition defn, BindingFault fault) {
        try {
            SOAPFault soap = (SOAPFault)defn.getExtensionRegistry().createExtension(BindingFault.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "fault"));
            soap.setUse("literal");
            soap.setNamespaceURI(defn.getTargetNamespace());
            soap.setName(fault.getName());
            fault.addExtensibilityElement((ExtensibilityElement)soap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP body to fault", e);
        }
    }

    public void updatePort(Definition defn, Port port) {
        try {
            SOAPAddress soap = (SOAPAddress)defn.getExtensionRegistry().createExtension(Port.class, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
            soap.setLocationURI("http://localhost:8080/" + defn.getQName().getLocalPart() + "Service/" + port.getName());
            port.addExtensibilityElement((ExtensibilityElement)soap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to add SOAP address to port", e);
        }
    }

    public boolean isXSDTypeMessagePartSupported() {
        return true;
    }
}

