/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import sbt.internal.inc.CreateZip;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b!B\u0013'\u0003\u0003i\u0003\"\u0002\u001d\u0001\t\u0003Id\u0001B\u001e\u0001\u0005qB\u0001\"\u0010\u0002\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006q\t!\t\u0001\u0013\u0005\b\u0019\n\u0011\r\u0011\"\u0003N\u0011\u0019y&\u0001)A\u0005\u001d\")\u0001M\u0001C\u0001C\")AM\u0001C\u0005K\")\u0001\u000e\u0001C\u0001S\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011Q\n\u0001\u0005\u0002\u0005=CaBA\u0019\u0001\t\u0005\u00111\u0007\u0003\b\u0003+\u0002!\u0011AA\u001a\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003/Ba\u0001\u001b\u0001\u0005\n\u0005\u0005\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\u0007\u007f\u0002!\t!a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!a3\u0001\t\u0013\ti\rC\u0004\u0002,\u00011\t\"a6\t\u000f\u0005m\u0007A\"\u0005\u0002^\"9\u0011\u0011\u001d\u0001\u0007\u0012\u0005\r\bbBAu\u0001\u0019E\u00111\u001e\u0005\b\u0003_\u0004a\u0011CAy\u0011\u001d\tI\u0010\u0001D\t\u0003wDqA!\u0001\u0001\r#\u0011\u0019\u0001C\u0004\u0003\b\u00011\tB!\u0003\t\u000f\tE\u0001A\"\u0005\u0003\u0014!9\u00111\t\u0001\u0007\u0012\t]!\u0001E%oI\u0016D()Y:fIjK\u0007o\u00149t\u0015\t9\u0003&A\u0002j]\u000eT!!\u000b\u0016\u0002\u0011%tG/\u001a:oC2T\u0011aK\u0001\u0004g\n$8\u0001A\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\ta%\u0003\u00028M\tI1I]3bi\u0016T\u0016\u000e]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"!\u000e\u0001\u0003\u0019\r\u000b7\r[3e'R\fW\u000e]:\u0014\u0005\tq\u0013a\u0001>jaB\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005M&dWM\u0003\u0002D\t\u0006\u0019a.[8\u000b\u0003\u0015\u000bAA[1wC&\u0011q\t\u0011\u0002\u0005!\u0006$\b\u000e\u0006\u0002J\u0017B\u0011!JA\u0007\u0002\u0001!)Q\b\u0002a\u0001}\u0005)2-Y2iK\u0012t\u0015-\\3U_RKW.Z:uC6\u0004X#\u0001(\u0011\t=3\u0016\f\u0018\b\u0003!R\u0003\"!\u0015\u0019\u000e\u0003IS!a\u0015\u0017\u0002\rq\u0012xn\u001c;?\u0013\t)\u0006'\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u00131!T1q\u0015\t)\u0006\u0007\u0005\u0002P5&\u00111\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005=j\u0016B\u000101\u0005\u0011auN\\4\u0002-\r\f7\r[3e\u001d\u0006lW\rV8US6,7\u000f^1na\u0002\n\u0001bZ3u'R\fW\u000e\u001d\u000b\u00039\nDQaY\u0004A\u0002e\u000bQ!\u001a8uef\fq\"\u001b8ji&\fG.\u001b>f\u0007\u0006\u001c\u0007.\u001a\u000b\u0003\u001d\u001aDQa\u001a\u0005A\u0002y\nqA_5q\r&dW-A\u0007sK6|g/Z#oiJLWm\u001d\u000b\u0004U6$\bCA\u0018l\u0013\ta\u0007G\u0001\u0003V]&$\b\"B4\n\u0001\u0004q\u0007CA8s\u001b\u0005\u0001(BA9E\u0003\tIw.\u0003\u0002ta\n!a)\u001b7f\u0011\u0015)\u0018\u00021\u0001w\u0003\u001d)g\u000e\u001e:jKN\u00042a\u001e?Z\u001d\tA(P\u0004\u0002Rs&\t\u0011'\u0003\u0002|a\u00059\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005!IE/\u001a:bE2,'BA>1\u00035iWM]4f\u0003J\u001c\u0007.\u001b<fgR)!.a\u0001\u0002\b!1\u0011Q\u0001\u0006A\u00029\fA!\u001b8u_\"1\u0011\u0011\u0002\u0006A\u00029\fAA\u001a:p[\u0006\u0001\u0012N\\2mk\u0012,\u0017J\\!sG\"Lg/\u001a\u000b\u0006U\u0006=\u0011\u0011\u0003\u0005\u0006O.\u0001\rA\u001c\u0005\b\u0003'Y\u0001\u0019AA\u000b\u0003\u00151\u0017\u000e\\3t!\u0019\t9\"!\t\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005j[6,H/\u00192mK*\u0019\u0011q\u0004\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0005e!aA*fcB)q&a\no3&\u0019\u0011\u0011\u0006\u0019\u0003\rQ+\b\u000f\\33\u00039\u0011X-\u00193DK:$(/\u00197ESJ$B!a\f\u0002BA\u0011!j\u0004\u0002\u000b\u0007\u0016tGO]1m\t&\u0014\u0018\u0003BA\u001b\u0003w\u00012aLA\u001c\u0013\r\tI\u0004\r\u0002\b\u001d>$\b.\u001b8h!\ry\u0013QH\u0005\u0004\u0003\u007f\u0001$aA!os\")q\r\u0004a\u0001]\u0006yqO]5uK\u000e+g\u000e\u001e:bY\u0012K'\u000fF\u0003k\u0003\u000f\nI\u0005C\u0003h\u001b\u0001\u0007a\u000eC\u0004\u0002L5\u0001\r!a\f\u0002\u0015\r,g\u000e\u001e:bY\u0012K'/A\u0006mSN$XI\u001c;sS\u0016\u001cH\u0003BA)\u0003'\u0002R!a\u0006\u0002\"eCQa\u001a\bA\u00029\u0014a\u0001S3bI\u0016\u0014H#\u00026\u0002Z\u0005u\u0003BBA.#\u0001\u0007a(\u0001\u0003qCRD\u0007bBA0#\u0001\u0007\u0011qF\u0001\u000e]\u0016<8)\u001a8ue\u0006dG)\u001b:\u0015\u000b)\f\u0019'!\u001a\t\r\u0005m#\u00031\u0001?\u0011\u001d\t9G\u0005a\u0001\u0003S\n\u0001\u0002^8SK6|g/\u001a\t\u0005\u001f\u0006-\u0014,C\u0002\u0002na\u00131aU3u\u0003m\u0011X-\\8wK\u0016sGO]5fg\u001a\u0013x.\\\"f]R\u0014\u0018\r\u001c#jeR)!.a\u001d\u0002v!9\u00111J\nA\u0002\u0005=\u0002bBA4'\u0001\u0007\u0011\u0011\u000e\u000b\u0006U\u0006e\u0014Q\u0010\u0005\u0007\u0003w\"\u0002\u0019\u0001 \u0002\rQ\f'oZ3u\u0011\u0019\ty\b\u0006a\u0001}\u000511o\\;sG\u0016\fA\"\\3sO\u0016DU-\u00193feN$\u0002\"!\"\u0002\n\u00065\u0015\u0011\u0013\t\u0007\u0003/\t\t#a\"\u0011\u0005)\u0003\u0002bBAF+\u0001\u0007\u0011qF\u0001\u0011i\u0006\u0014x-\u001a;DK:$(/\u00197ESJDq!a$\u0016\u0001\u0004\ty#\u0001\tt_V\u00148-Z\"f]R\u0014\u0018\r\u001c#je\"1\u00111S\u000bA\u0002q\u000b1b]8ve\u000e,7\u000b^1si\u0006\u0011BO];oG\u0006$XmQ3oiJ\fG\u000eR5s)\u0015a\u0016\u0011TAN\u0011\u001d\tYE\u0006a\u0001\u0003_Aa!a\u0017\u0017\u0001\u0004q\u0014a\u00034j]\u0006d\u0017N_3[SB$rA[AQ\u0003G\u000b)\u000bC\u0004\u0002L]\u0001\r!a\f\t\r\u0005ms\u00031\u0001?\u0011\u0019\t9k\u0006a\u00019\u0006y1-\u001a8ue\u0006dG)\u001b:Ti\u0006\u0014H/A\u0006ue\u0006t7OZ3s\u00032dG#\u00036\u0002.\u0006=\u0016\u0011WA[\u0011\u0019\ty\b\u0007a\u0001}!1\u00111\u0010\rA\u0002yBa!a-\u0019\u0001\u0004a\u0016\u0001C:uCJ$\bk\\:\t\r\u0005]\u0006\u00041\u0001]\u0003=\u0011\u0017\u0010^3t)>$&/\u00198tM\u0016\u0014\u0018AE8qK:4\u0015\u000e\\3G_J\u0014V-\u00193j]\u001e$B!!0\u0002JB!\u0011qXAc\u001b\t\t\tMC\u0002\u0002D\n\u000b\u0001b\u00195b]:,Gn]\u0005\u0005\u0003\u000f\f\tMA\nSK\u0006$\u0017M\u00197f\u0005f$Xm\u00115b]:,G\u000e\u0003\u0004\u0002\\e\u0001\rAP\u0001\u0013_B,gNR5mK\u001a{'o\u0016:ji&tw\r\u0006\u0003\u0002P\u0006U\u0007\u0003BA`\u0003#LA!a5\u0002B\nYa)\u001b7f\u0007\"\fgN\\3m\u0011\u0019\tYF\u0007a\u0001}Q!\u0011qFAm\u0011\u0019\tYf\u0007a\u0001}\u0005\u0011r-\u001a;DK:$(/\u00197ESJ\u001cF/\u0019:u)\ra\u0016q\u001c\u0005\b\u0003\u0017b\u0002\u0019AA\u0018\u0003I\u0019X\r^\"f]R\u0014\u0018\r\u001c#jeN#\u0018M\u001d;\u0015\u000b)\f)/a:\t\u000f\u0005-S\u00041\u0001\u00020!1\u0011qU\u000fA\u0002q\u000b!bZ3u\u0011\u0016\fG-\u001a:t)\u0011\t))!<\t\u000f\u0005-c\u00041\u0001\u00020\u0005Q1/\u001a;IK\u0006$WM]:\u0015\u000b)\f\u00190!>\t\u000f\u0005-s\u00041\u0001\u00020!9\u0011q_\u0010A\u0002\u0005\u0015\u0015a\u00025fC\u0012,'o]\u0001\fO\u0016$h)\u001b7f\u001d\u0006lW\rF\u0002Z\u0003{Dq!a@!\u0001\u0004\t9)\u0001\u0004iK\u0006$WM]\u0001\u000eO\u0016$h)\u001b7f\u001f\u001a47/\u001a;\u0015\u0007q\u0013)\u0001C\u0004\u0002\u0000\u0006\u0002\r!a\"\u0002\u001bM,GOR5mK>3gm]3u)\u0015Q'1\u0002B\u0007\u0011\u001d\tyP\ta\u0001\u0003\u000fCaAa\u0004#\u0001\u0004a\u0016AB8gMN,G/A\nhKRd\u0015m\u001d;N_\u0012Lg-[3e)&lW\rF\u0002]\u0005+Aq!a@$\u0001\u0004\t9\tF\u0003k\u00053\u0011Y\u0002C\u0004\u0002L\u0011\u0002\r!a\f\t\u000f\tuA\u00051\u0001\u0003 \u0005aq.\u001e;qkR\u001cFO]3b[B\u0019qN!\t\n\u0007\t\r\u0002O\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e")
public abstract class IndexBasedZipOps
implements CreateZip {
    @Override
    public void createZip(File target, Seq<Tuple2<File, String>> files) {
        CreateZip.createZip$(this, target, files);
    }

    public void removeEntries(File zipFile, Iterable<String> entries) {
        this.removeEntries(zipFile.toPath(), (Set<String>)entries.toSet());
    }

    public void mergeArchives(File into, File from) {
        this.mergeArchives(into.toPath(), from.toPath());
    }

    public void includeInArchive(File zipFile, Seq<Tuple2<File, String>> files) {
        if (zipFile.exists()) {
            File tempZip = zipFile.toPath().resolveSibling(new StringBuilder(4).append(UUID.randomUUID()).append(".jar").toString()).toFile();
            this.createZip(tempZip, files);
            this.mergeArchives(zipFile, tempZip);
            return;
        }
        this.createZip(zipFile, files);
    }

    public Object readCentralDir(File zipFile) {
        return this.readCentralDir(zipFile.toPath());
    }

    public void writeCentralDir(File zipFile, Object centralDir) {
        this.writeCentralDir(zipFile.toPath(), centralDir);
    }

    public Seq<String> listEntries(File zipFile) {
        Object centralDir = this.readCentralDir(zipFile);
        return (Seq)this.getHeaders(centralDir).map((Function1 & Serializable)header -> this.getFileName(header));
    }

    private void writeCentralDir(Path path, Object newCentralDir) {
        Object currentCentralDir = this.readCentralDir(path);
        long currentCentralDirStart = this.truncateCentralDir(currentCentralDir, path);
        this.finalizeZip(newCentralDir, path, currentCentralDirStart);
    }

    private void removeEntries(Path path, Set<String> toRemove) {
        if (toRemove.nonEmpty()) {
            Object centralDir = this.readCentralDir(path);
            this.removeEntriesFromCentralDir(centralDir, toRemove);
            long writeOffset = this.truncateCentralDir(centralDir, path);
            this.finalizeZip(centralDir, path, writeOffset);
            return;
        }
    }

    private void removeEntriesFromCentralDir(Object centralDir, Set<String> toRemove) {
        Seq clearedHeaders = (Seq)this.getHeaders(centralDir).filterNot((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)toRemove.contains((Object)this.getFileName(header))));
        this.setHeaders(centralDir, (Seq<Object>)clearedHeaders);
    }

    public void mergeArchives(Path target, Path source) {
        Object targetCentralDir = this.readCentralDir(target);
        Object sourceCentralDir = this.readCentralDir(source);
        long sourceStart = this.truncateCentralDir(targetCentralDir, target);
        long sourceLength = this.getCentralDirStart(sourceCentralDir);
        this.transferAll(source, target, sourceStart, sourceLength);
        Seq<Object> mergedHeaders = this.mergeHeaders(targetCentralDir, sourceCentralDir, sourceStart);
        this.setHeaders(targetCentralDir, mergedHeaders);
        long centralDirStart = sourceStart + sourceLength;
        this.finalizeZip(targetCentralDir, target, centralDirStart);
        Files.delete(source);
    }

    private Seq<Object> mergeHeaders(Object targetCentralDir, Object sourceCentralDir, long sourceStart) {
        Seq<Object> sourceHeaders = this.getHeaders(sourceCentralDir);
        sourceHeaders.foreach((Function1 & Serializable)header -> {
            IndexBasedZipOps.$anonfun$mergeHeaders$1(this, sourceStart, header);
            return BoxedUnit.UNIT;
        });
        Set sourceNames = ((IterableOnceOps)sourceHeaders.map((Function1 & Serializable)header -> this.getFileName(header))).toSet();
        return (Seq)((Seq)this.getHeaders(targetCentralDir).filterNot((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)sourceNames.contains((Object)this.getFileName(h))))).$plus$plus(sourceHeaders);
    }

    private long truncateCentralDir(Object centralDir, Path path) {
        long sizeAfterTruncate = this.getCentralDirStart(centralDir);
        new FileOutputStream(path.toFile(), true).getChannel().truncate(sizeAfterTruncate).close();
        return sizeAfterTruncate;
    }

    private void finalizeZip(Object centralDir, Path path, long centralDirStart) {
        this.setCentralDirStart(centralDir, centralDirStart);
        FileOutputStream fileOutputStream = new FileOutputStream(path.toFile(), true);
        fileOutputStream.getChannel().position(centralDirStart);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        this.writeCentralDir(centralDir, outputStream);
        outputStream.close();
    }

    private void transferAll(Path source, Path target, long startPos, long bytesToTransfer) {
        long transferred;
        ReadableByteChannel sourceFile = this.openFileForReading(source);
        FileChannel targetFile = this.openFileForWriting(target);
        long offset = startPos;
        for (long remaining = bytesToTransfer; remaining > 0L; remaining -= transferred) {
            transferred = targetFile.transferFrom(sourceFile, offset, remaining);
            offset += transferred;
        }
        sourceFile.close();
        targetFile.close();
    }

    private ReadableByteChannel openFileForReading(Path path) {
        return Channels.newChannel(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
    }

    private FileChannel openFileForWriting(Path path) {
        return new FileOutputStream(path.toFile(), true).getChannel();
    }

    public abstract Object readCentralDir(Path var1);

    public abstract long getCentralDirStart(Object var1);

    public abstract void setCentralDirStart(Object var1, long var2);

    public abstract Seq<Object> getHeaders(Object var1);

    public abstract void setHeaders(Object var1, Seq<Object> var2);

    public abstract String getFileName(Object var1);

    public abstract long getFileOffset(Object var1);

    public abstract void setFileOffset(Object var1, long var2);

    public abstract long getLastModifiedTime(Object var1);

    public abstract void writeCentralDir(Object var1, OutputStream var2);

    public static final /* synthetic */ void $anonfun$mergeHeaders$1(IndexBasedZipOps $this, long sourceStart$1, Object header) {
        long newOffset = $this.getFileOffset(header) + sourceStart$1;
        $this.setFileOffset(header, newOffset);
    }

    public IndexBasedZipOps() {
        CreateZip.$init$(this);
    }

    public final class CachedStamps {
        private final Map<String, Object> cachedNameToTimestamp;

        private Map<String, Object> cachedNameToTimestamp() {
            return this.cachedNameToTimestamp;
        }

        public long getStamp(String entry) {
            return BoxesRunTime.unboxToLong((Object)this.cachedNameToTimestamp().getOrElse((Object)entry, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }

        private Map<String, Object> initializeCache(Path zipFile) {
            if (Files.exists(zipFile, new LinkOption[0])) {
                Object centralDir = IndexBasedZipOps.this.readCentralDir(zipFile);
                return IndexBasedZipOps.this.getHeaders(centralDir).iterator().map((Function1 & Serializable)header -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.IndexBasedZipOps.this.getFileName(header)), (Object)BoxesRunTime.boxToLong((long)$this.IndexBasedZipOps.this.getLastModifiedTime(header)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return Predef$.MODULE$.Map().empty();
        }

        public CachedStamps(Path zip) {
            if (IndexBasedZipOps.this == null) {
                throw null;
            }
            this.cachedNameToTimestamp = this.initializeCache(zip);
        }
    }
}

