/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.consistent;

import java.io.Serializable;
import java.io.Writer;
import sbt.internal.inc.consistent.Serializer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u000e\u001d\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006g\u0001!\t\u0001\u000e\u0004\u0007o\u0001\u0001\u000bQ\u0002\u001d\t\u0011}\u001a!Q1A\u0005\u0002\u0001C\u0001\u0002R\u0002\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u000e\u0011)\u0019!C\u0001\r\"A!j\u0001B\u0001B\u0003%q\t\u0003\u0005L\u0007\t\u0005\r\u0011\"\u0001G\u0011!a5A!a\u0001\n\u0003i\u0005\u0002C*\u0004\u0005\u0003\u0005\u000b\u0015B$\t\u000bM\u001aA\u0011\u0001+\t\ri\u0003\u0001\u0015)\u0003H\u0011\u0019Y\u0006\u0001)Q\u00059\"1\u0001\u000e\u0001Q\u0005\n%DaA\u001b\u0001!\n\u0013I\u0007BB6\u0001A\u0013%A\u000eC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0003|\u0001\u0011\u0005A\u0010\u0003\u0004\u0002\u0002\u0001!\t!\u001b\u0005\u0007\u0003\u0007\u0001A\u0011A5\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAa!!\u000e\u0001\t\u0003I'A\u0004+fqR\u001cVM]5bY&TXM\u001d\u0006\u0003;y\t!bY8og&\u001cH/\u001a8u\u0015\ty\u0002%A\u0002j]\u000eT!!\t\u0012\u0002\u0011%tG/\u001a:oC2T\u0011aI\u0001\u0004g\n$8\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0015\u000e\u0003qI!!\u000b\u000f\u0003\u0015M+'/[1mSj,'/A\u0002pkR\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0005%|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u0016:ji\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00026mA\u0011q\u0005\u0001\u0005\u0006U\t\u0001\ra\u000b\u0002\u0006\u00052|7m[\n\u0003\u0007e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0017!B1se\u0006LX#A!\u0011\u0005i\u0012\u0015BA\"<\u0005\u001d\u0011un\u001c7fC:\fa!\u0019:sCf\u0004\u0013\u0001C3ya\u0016\u001cG/\u001a3\u0016\u0003\u001d\u0003\"A\u000f%\n\u0005%[$aA%oi\u0006IQ\r\u001f9fGR,G\rI\u0001\u0007C\u000e$X/\u00197\u0002\u0015\u0005\u001cG/^1m?\u0012*\u0017\u000f\u0006\u0002O#B\u0011!hT\u0005\u0003!n\u0012A!\u00168ji\"9!+CA\u0001\u0002\u00049\u0015a\u0001=%c\u00059\u0011m\u0019;vC2\u0004C\u0003B+X1f\u0003\"AV\u0002\u000e\u0003\u0001AQaP\u0006A\u0002\u0005CQ!R\u0006A\u0002\u001dCQaS\u0006A\u0002\u001d\u000ba!\u001b8eK:$\u0018!B:uC\u000e\\\u0007cA/f+:\u0011al\u0019\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u0012\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u0011\\\u0014a\u00029bG.\fw-Z\u0005\u0003M\u001e\u0014A\u0001T5ti*\u0011AmO\u0001\faJLg\u000e^%oI\u0016tG\u000fF\u0001O\u0003\u0015\u0019w.\u001e8u\u0003\u001d\u0001(/\u001b8uY:$\"AT7\t\u000b9\u0004\u0002\u0019A8\u0002\u0003M\u0004\"\u0001\u001d;\u000f\u0005E\u0014\bCA0<\u0013\t\u00198(\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:<\u0003)\u0019H/\u0019:u\u00052|7m\u001b\u000b\u0003\u001dfDQA_\tA\u0002=\fAA\\1nK\u0006Q1\u000f^1si\u0006\u0013(/Y=\u0015\u00079kh\u0010C\u0003{%\u0001\u0007q\u000eC\u0003\u0000%\u0001\u0007q)\u0001\u0004mK:<G\u000f[\u0001\tK:$'\t\\8dW\u0006AQM\u001c3BeJ\f\u00170\u0001\u0004tiJLgn\u001a\u000b\u0004\u001d\u0006%\u0001\"\u00028\u0016\u0001\u0004y\u0017\u0001\u00022p_2$2ATA\b\u0011\u0019\t\tB\u0006a\u0001\u0003\u0006\t!-A\u0002j]R$2ATA\f\u0011\u0019\tIb\u0006a\u0001\u000f\u0006\t\u0011.\u0001\u0003csR,Gc\u0001(\u0002 !9\u0011\u0011\u0003\rA\u0002\u0005\u0005\u0002c\u0001\u001e\u0002$%\u0019\u0011QE\u001e\u0003\t\tKH/Z\u0001\u0005Y>tw\rF\u0002O\u0003WAq!!\f\u001a\u0001\u0004\ty#A\u0001m!\rQ\u0014\u0011G\u0005\u0004\u0003gY$\u0001\u0002'p]\u001e\f1!\u001a8e\u0001")
public class TextSerializer
extends Serializer {
    private final Writer out;
    private int indent;
    private List<Block> stack;

    private void printIndent() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.indent * 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> $this.out.write(32));
    }

    private void count() {
        if (this.stack.nonEmpty()) {
            Block block = (Block)this.stack.head();
            block.actual_$eq(block.actual() + 1);
            return;
        }
    }

    private void println(String s) {
        this.out.write(s);
        this.out.write(10);
    }

    @Override
    public void startBlock(String name) {
        this.count();
        this.printIndent();
        this.println(new StringBuilder(2).append(name).append(" {").toString());
        Block block = new Block(this, false, 0, 0);
        this.stack = this.stack.$colon$colon((Object)block);
        ++this.indent;
    }

    @Override
    public void startArray(String name, int length) {
        this.count();
        this.printIndent();
        this.println(new StringBuilder(2).append(name).append(" [").toString());
        Block block = new Block(this, true, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(length), 0), 0);
        this.stack = this.stack.$colon$colon((Object)block);
        ++this.indent;
        this.printIndent();
        this.println(Integer.toString(length));
    }

    @Override
    public void endBlock() {
        Predef$.MODULE$.assert(this.stack.nonEmpty());
        Block b = (Block)this.stack.head();
        this.stack = (List)this.stack.tail();
        Predef$.MODULE$.assert(!b.array());
        --this.indent;
        this.printIndent();
        this.println("}");
    }

    @Override
    public void endArray() {
        Predef$.MODULE$.assert(this.stack.nonEmpty());
        Block b = (Block)this.stack.head();
        this.stack = (List)this.stack.tail();
        Predef$.MODULE$.assert(b.array());
        Predef$.MODULE$.assert(b.expected() == b.actual(), (Function0 & Serializable)() -> new StringBuilder(33).append("Expected to write ").append(b.expected()).append(" values, wrote ").append(b.actual()).toString());
        --this.indent;
        this.printIndent();
        this.println("]");
    }

    @Override
    public void string(String s) {
        this.count();
        this.printIndent();
        if (s == null) {
            this.out.write("\\0\n");
            return;
        }
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x0$1 -> {
            TextSerializer.$anonfun$string$1(this, BoxesRunTime.unboxToChar((Object)x0$1));
            return BoxedUnit.UNIT;
        });
        this.out.write(10);
    }

    @Override
    public void bool(boolean b) {
        this.long(b ? 1L : 0L);
    }

    @Override
    public void int(int i) {
        this.long(i);
    }

    @Override
    public void byte(byte b) {
        this.long(b);
    }

    @Override
    public void long(long l) {
        this.count();
        this.printIndent();
        this.println(Long.toString(l));
    }

    @Override
    public void end() {
        this.out.flush();
        Predef$.MODULE$.assert(this.stack.isEmpty() && this.indent == 0);
    }

    public static final /* synthetic */ void $anonfun$string$1(TextSerializer $this, char x0$1) {
        char c = x0$1;
        switch (c) {
            case '\n': {
                $this.out.write("\\n");
                return;
            }
            case '\r': {
                $this.out.write("\\r");
                return;
            }
            case '\\': {
                $this.out.write("\\\\");
                return;
            }
        }
        $this.out.write(c);
    }

    public TextSerializer(Writer out) {
        this.out = out;
        this.indent = 0;
        this.stack = Nil$.MODULE$;
    }

    private final class Block {
        private final boolean array;
        private final int expected;
        private int actual;

        public boolean array() {
            return this.array;
        }

        public int expected() {
            return this.expected;
        }

        public int actual() {
            return this.actual;
        }

        public void actual_$eq(int x$1) {
            this.actual = x$1;
        }

        public Block(TextSerializer $outer, boolean array, int expected, int actual) {
            this.array = array;
            this.expected = expected;
            this.actual = actual;
        }
    }
}

