/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.CompileConfiguration;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.Incremental$;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import sbt.internal.inc.VirtualFileUtil$;
import sbt.internal.inc.javac.AnalyzingJavaCompiler;
import sbt.internal.util.ConsoleAppender$;
import sbt.io.DirectoryFilter$;
import sbt.io.IO$;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.FileConverter;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncToolOptions;
import xsbti.compile.JavaCompiler;
import xsbti.compile.MiniSetup;
import xsbti.compile.MultipleOutput;
import xsbti.compile.Output;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.SingleOutput;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0005\rMf\u0001\u0002\u0015*\u0005AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005s!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\")!\r\u0001C\u0001G\"1!\u000e\u0001Q\u0001\n-DQa\u001e\u0001\u0005\u0002aDq!a\n\u0001\t\u0003\tI\u0003\u0003\u0004=\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003K\u0002A\u0011BA4\u0011!\ti\b\u0001Q\u0005\n\u0005}\u0004\u0002CAF\u0001\u0001&I!!$\t\u0011\u0005}\u0006\u0001)C\u0005\u0003\u0003<q!a6*\u0011\u0003\tIN\u0002\u0004)S!\u0005\u00111\u001c\u0005\u0007ER!\t!!8\t\u0011\u0005}G\u0003\"\u0001.\u0003CDq!a=\u0015\t\u0003\t)\u0010C\u0005\u00030R\t\n\u0011\"\u0001\u00032\"I!q\u0019\u000b\u0012\u0002\u0013\u0005!\u0011\u001a\u0005\n\u0005\u001b$\u0012\u0013!C\u0001\u0005\u0013D\u0011Ba4\u0015#\u0003%\tA!5\t\u0013\tUG#%A\u0005\u0002\t]\u0007B\u0002&\u0015\t\u0003\u0011Y\u000eC\u0004\u0004\u0006Q!\taa\u0002\t\u000f\r\u0015A\u0003\"\u0001\u0004\u0016!91\u0011\u0006\u000b\u0005\u0002\r-\u0002bBB\u0018)\u0011\u00051\u0011\u0007\u0005\b\u0007s!B\u0011AB\u001e\u0011!\u0019Y\u0005\u0006Q\u0005\n\r5\u0003\u0002\u0003B\u000b)\u0001\u0006Iaa\u0015\t\u000f\r=D\u0003\"\u0003\u0004r!911\u0010\u000b\u0005\u0002\ru\u0004bBB>)\u0011\u00051q\u0011\u0002\u0017\u001b&DX\rZ!oC2L(0\u001b8h\u0007>l\u0007/\u001b7fe*\u0011!fK\u0001\u0004S:\u001c'B\u0001\u0017.\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u0018\u0002\u0007M\u0014Go\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g-\u0001\u0004tG\u0006d\u0017mY\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\bG>l\u0007/\u001b7f\u0015\u0005q\u0014!\u0002=tERL\u0017B\u0001!<\u00055\u00196-\u00197b\u0007>l\u0007/\u001b7fe\u000691oY1mC\u000e\u0004\u0013!\u00026bm\u0006\u001cW#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\tK\u0013B\u0001%G\u0005U\te.\u00197zu&twMS1wC\u000e{W\u000e]5mKJ\faA[1wC\u000e\u0004\u0013AB2p]\u001aLw-F\u0001M!\tie*D\u0001*\u0013\ty\u0015F\u0001\u000bD_6\u0004\u0018\u000e\\3D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u0003\rawnZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a+L\u0001\u0005kRLG.\u0003\u0002Y+\n1Aj\\4hKJ\fA\u0001\\8hA\u0005\u0001r.\u001e;qkRT\u0015M]\"p]R,g\u000e\u001e\t\u00039~s!!T/\n\u0005yK\u0013\u0001\u0003&beV#\u0018\u000e\\:\n\u0005\u0001\f'\u0001E(viB,HOS1s\u0007>tG/\u001a8u\u0015\tq\u0016&\u0001\u0004=S:LGO\u0010\u000b\u0007I\u00164w\r[5\u0011\u00055\u0003\u0001\"B\u001c\u000b\u0001\u0004I\u0004\"\u0002\"\u000b\u0001\u0004!\u0005\"\u0002&\u000b\u0001\u0004a\u0005\"B)\u000b\u0001\u0004\u0019\u0006\"\u0002.\u000b\u0001\u0004Y\u0016\u0001D1cg\u000ec\u0017m]:qCRD\u0007c\u00017rg6\tQN\u0003\u0002o_\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003aN\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011XNA\u0002TKF\u0004\"\u0001^;\u000e\u0003uJ!A^\u001f\u0003\u0017YK'\u000f^;bY\u001aKG.Z\u0001\fG>l\u0007/\u001b7f\u0015\u00064\u0018\r\u0006\u0004zy\u0006M\u0011Q\u0004\t\u0003eiL!a_\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006{2\u0001\rA`\u0001\tU\u00064\u0018m\u0015:dgB!q0a\u0004t\u001d\u0011\t\t!a\u0003\u000f\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u00020\u0003\u0019a$o\\8u}%\tA'C\u0002\u0002\u000eM\nq\u0001]1dW\u0006<W-C\u0002s\u0003#Q1!!\u00044\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\t\u0001bY1mY\n\f7m\u001b\t\u0004i\u0006e\u0011bAA\u000e{\t\u0001\u0012I\\1msNL7oQ1mY\n\f7m\u001b\u0005\b\u0003?a\u0001\u0019AA\u0011\u0003A\u0019G.Y:tM&dW-T1oC\u001e,'\u000fE\u0002;\u0003GI1!!\n<\u0005A\u0019E.Y:t\r&dW-T1oC\u001e,'/\u0001\u0007f]N,(/Z(viB,H/\u0006\u0002\u0002,A)q0a\u0004\u0002.A!\u0011qFA\u001f\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u00024jY\u0016TA!a\u000e\u0002:\u0005\u0019a.[8\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006LA!a\u0010\u00022\t!\u0001+\u0019;i)%I\u00181IA,\u0003C\n\u0019\u0007C\u0004\u0002F9\u0001\r!a\u0012\u0002\u000f%t7\r\\;eKB)\u0011\u0011JA)g:!\u00111JA'!\r\t\u0019aM\u0005\u0004\u0003\u001f\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#aA*fi*\u0019\u0011qJ\u001a\t\u000f\u0005ec\u00021\u0001\u0002\\\u000591\r[1oO\u0016\u001c\bc\u0001\u001e\u0002^%\u0019\u0011qL\u001e\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017p\u00115b]\u001e,7\u000fC\u0004\u0002\u00169\u0001\r!a\u0006\t\u000f\u0005}a\u00021\u0001\u0002\"\u0005\u0019\u0002/\u001e;KCZ\f7mT;uaV$\u0018J\u001c&beR)\u00110!\u001b\u0002z!9\u00111N\bA\u0002\u00055\u0014!C8viB,HOS1s!\u0011\ty'!\u001e\u000e\u0005\u0005E$\u0002BA:\u0003s\t!![8\n\t\u0005]\u0014\u0011\u000f\u0002\u0005\r&dW\rC\u0004\u0002|=\u0001\r!!\u001c\u0002\u0013=,H\u000f];u\t&\u0014\u0018!E8viB,H\u000fR5sK\u000e$xN]5fgR!\u00111FAA\u0011\u001d\t\u0019\t\u0005a\u0001\u0003\u000b\u000baa\\;uaV$\bc\u0001\u001e\u0002\b&\u0019\u0011\u0011R\u001e\u0003\r=+H\u000f];u\u0003\u0015!\u0018.\\3e+\u0011\ty)a&\u0015\r\u0005E\u00151WA_)\u0011\t\u0019*!+\u0011\t\u0005U\u0015q\u0013\u0007\u0001\t\u001d\tI*\u0005b\u0001\u00037\u0013\u0011\u0001V\t\u0005\u0003;\u000b\u0019\u000bE\u00023\u0003?K1!!)4\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AMAS\u0013\r\t9k\r\u0002\u0004\u0003:L\b\u0002CAV#\u0011\u0005\r!!,\u0002\u0003Q\u0004RAMAX\u0003'K1!!-4\u0005!a$-\u001f8b[\u0016t\u0004bBA[#\u0001\u0007\u0011qW\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0005\u0003\u0013\nI,\u0003\u0003\u0002<\u0006U#AB*ue&tw\rC\u0003R#\u0001\u00071+A\u0005m_\u001eLe\u000e];ugRI\u00110a1\u0002F\u0006=\u00171\u001b\u0005\u0006#J\u0001\ra\u0015\u0005\b\u0003\u000f\u0014\u0002\u0019AAe\u0003%Q\u0017M^1D_VtG\u000fE\u00023\u0003\u0017L1!!44\u0005\rIe\u000e\u001e\u0005\b\u0003#\u0014\u0002\u0019AAe\u0003)\u00198-\u00197b\u0007>,h\u000e\u001e\u0005\b\u0003+\u0014\u0002\u0019AA\u0016\u0003)yW\u000f\u001e9vi\u0012K'o]\u0001\u0017\u001b&DX\rZ!oC2L(0\u001b8h\u0007>l\u0007/\u001b7feB\u0011Q\nF\n\u0003)E\"\"!!7\u0002\u0011)\fg/Y(oYf$B!a9\u0002jB\u0019!'!:\n\u0007\u0005\u001d8GA\u0004C_>dW-\u00198\t\u000f\u0005-h\u00031\u0001\u0002n\u0006\ta\rE\u0002u\u0003_L1!!=>\u000591\u0016N\u001d;vC24\u0015\u000e\\3SK\u001a\f!\"\\1lK\u000e{gNZ5h)5b\u0015q_A}\u0005\u0003\u0011)Aa\u0004\u0003\u0014\tu!Q\u0006B\u001a\u0005o\u0011\tE!\u0014\u0003X\t\u0005$1\u000eB8\u0005s\u0012YH! \u0003\u0004\n=%q\u0014\u0005\u0006o]\u0001\r!\u000f\u0005\u0007\u0005^\u0001\r!a?\u0011\u0007i\ni0C\u0002\u0002\u0000n\u0012ABS1wC\u000e{W\u000e]5mKJDaAa\u0001\u0018\u0001\u0004q\u0018aB:pkJ\u001cWm\u001d\u0005\b\u0005\u000f9\u0002\u0019\u0001B\u0005\u0003%\u0019wN\u001c<feR,'\u000fE\u0002u\u0005\u0017I1A!\u0004>\u000551\u0015\u000e\\3D_:4XM\u001d;fe\"1!\u0011C\fA\u0002y\f\u0011b\u00197bgN\u0004\u0018\r\u001e5\t\u000f\tUq\u00031\u0001\u0003\u0018\u0005)1-Y2iKB\u0019!H!\u0007\n\u0007\tm1H\u0001\u0007HY>\u0014\u0017\r\\:DC\u000eDW\rC\u0005\u0003 ]\u0001\n\u00111\u0001\u0003\"\u0005A\u0001O]8he\u0016\u001c8\u000fE\u00033\u0005G\u00119#C\u0002\u0003&M\u0012aa\u00149uS>t\u0007c\u0001\u001e\u0003*%\u0019!1F\u001e\u0003\u001f\r{W\u000e]5mKB\u0013xn\u001a:fgND\u0011Ba\f\u0018!\u0003\u0005\rA!\r\u0002\u000f=\u0004H/[8ogB)q0a\u0004\u00028\"I!QG\f\u0011\u0002\u0003\u0007!\u0011G\u0001\rU\u00064\u0018mY(qi&|gn\u001d\u0005\b\u0005s9\u0002\u0019\u0001B\u001e\u0003A\u0001(/\u001a<j_V\u001c\u0018I\\1msNL7\u000fE\u0002;\u0005{I1Aa\u0010<\u0005=\u0019u.\u001c9jY\u0016\fe.\u00197zg&\u001c\bb\u0002B\"/\u0001\u0007!QI\u0001\u000eaJ,g/[8vgN+G/\u001e9\u0011\u000bI\u0012\u0019Ca\u0012\u0011\u0007i\u0012I%C\u0002\u0003Lm\u0012\u0011\"T5oSN+G/\u001e9\t\u000f\t=s\u00031\u0001\u0003R\u00059\u0002/\u001a:DY\u0006\u001c8\u000f]1uQ\u0016sGO]=M_>\\W\u000f\u001d\t\u0004u\tM\u0013b\u0001B+w\t9\u0002+\u001a:DY\u0006\u001c8\u000f]1uQ\u0016sGO]=M_>\\W\u000f\u001d\u0005\b\u00053:\u0002\u0019\u0001B.\u0003!\u0011X\r]8si\u0016\u0014\bc\u0001;\u0003^%\u0019!qL\u001f\u0003\u0011I+\u0007o\u001c:uKJD\u0011Ba\u0019\u0018!\u0003\u0005\rA!\u001a\u0002\u0019\r|W\u000e]5mK>\u0013H-\u001a:\u0011\u0007i\u00129'C\u0002\u0003jm\u0012AbQ8na&dWm\u0014:eKJD\u0011B!\u001c\u0018!\u0003\u0005\r!a9\u0002\tM\\\u0017\u000e\u001d\u0005\b\u0005c:\u0002\u0019\u0001B:\u0003iIgn\u0019:f[\u0016tG/\u00197D_6\u0004\u0018\u000e\\3s\u001fB$\u0018n\u001c8t!\rQ$QO\u0005\u0004\u0005oZ$AC%oG>\u0003H/[8og\"9\u00111Q\fA\u0002\u0005\u0015\u0005\"\u0002.\u0018\u0001\u0004Y\u0006b\u0002B@/\u0001\u0007!\u0011Q\u0001\fK\u0006\u0014H._(viB,H\u000fE\u00033\u0005G\t)\tC\u0004\u0003\u0006^\u0001\rAa\"\u0002%\u0015\f'\u000f\\=B]\u0006d\u0017p]5t'R|'/\u001a\t\u0006e\t\r\"\u0011\u0012\t\u0004u\t-\u0015b\u0001BGw\ti\u0011I\\1msNL7o\u0015;pe\u0016DqA!%\u0018\u0001\u0004\u0011\u0019*A\u0004ti\u0006l\u0007/\u001a:\u0011\t\tU%1T\u0007\u0003\u0005/S1A!'<\u0003!\tg.\u00197zg&\u001c\u0018\u0002\u0002BO\u0005/\u0013!BU3bIN#\u0018-\u001c9t\u0011\u001d\u0011\tk\u0006a\u0001\u0005G\u000bQ!\u001a=ue\u0006\u0004Ra BS\u0005SKAAa*\u0002\u0012\t!A*[:u!\u001d\u0011$1VA\\\u0003oK1A!,4\u0005\u0019!V\u000f\u001d7fe\u0005!R.Y6f\u0007>tg-[4%I\u00164\u0017-\u001e7uI]*\"Aa-+\t\t\u0005\"QW\u0016\u0003\u0005o\u0003BA!/\u0003D6\u0011!1\u0018\u0006\u0005\u0005{\u0013y,A\u0005v]\u000eDWmY6fI*\u0019!\u0011Y\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003F\nm&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!R.Y6f\u0007>tg-[4%I\u00164\u0017-\u001e7uIa*\"Aa3+\t\tE\"QW\u0001\u0015[\u0006\\WmQ8oM&<G\u0005Z3gCVdG\u000fJ\u001d\u0002+5\f7.Z\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00132iU\u0011!1\u001b\u0016\u0005\u0005K\u0012),A\u000bnC.,7i\u001c8gS\u001e$C-\u001a4bk2$H%M\u001b\u0016\u0005\te'\u0006BAr\u0005k#R\u0005\u0014Bo\u0005?\u0014\tOa9\u0003h\n%(1\u001eBw\u0005_\u0014\u0019P!>\u0003x\ne(1 B\u007f\u0005\u007f\u001c\taa\u0001\t\r\t\rQ\u00041\u0001\u007f\u0011\u001d\u00119!\ba\u0001\u0005\u0013AaA!\u0005\u001e\u0001\u0004q\bb\u0002Bs;\u0001\u0007!qI\u0001\u0006g\u0016$X\u000f\u001d\u0005\b\u0005?i\u0002\u0019\u0001B\u0011\u0011\u001d\u0011I$\ba\u0001\u0005wAqAa\u0011\u001e\u0001\u0004\u0011)\u0005C\u0004\u0003Pu\u0001\rA!\u0015\t\r\tEX\u00041\u0001:\u0003!\u0019w.\u001c9jY\u0016\u0014\bB\u0002\"\u001e\u0001\u0004\tY\u0010C\u0004\u0003Zu\u0001\rAa\u0017\t\u000f\t5T\u00041\u0001\u0002d\"9!QC\u000fA\u0002\t]\u0001b\u0002B9;\u0001\u0007!1\u000f\u0005\u00065v\u0001\ra\u0017\u0005\b\u0005\u007fj\u0002\u0019\u0001BA\u0011\u001d\u0011))\ba\u0001\u0005\u000fCqA!%\u001e\u0001\u0004\u0011\u0019*\u0001\rtK\u0006\u00148\r[\"mCN\u001c\b/\u0019;i\u0003:$Gj\\8lkB$Ba!\u0003\u0004\u0014A1!Ga+\u007f\u0007\u0017\u0001rAMB\u0007\u0003o\u001b\t\"C\u0002\u0004\u0010M\u0012\u0011BR;oGRLwN\\\u0019\u0011\tI\u0012\u0019c\u001d\u0005\u0006\u0015z\u0001\r\u0001\u0014\u000b\r\u0007\u0013\u00199b!\u0007\u0004\u001c\r\u00152q\u0005\u0005\b\u0005\u000fy\u0002\u0019\u0001B\u0005\u0011\u0019\u0011\tb\ba\u0001}\"91QD\u0010A\u0002\r}\u0011!D:dC2\f7m\u00149uS>t7\u000fE\u00033\u0007C\t9,C\u0002\u0004$M\u0012Q!\u0011:sCfDqAa\u0014 \u0001\u0004\u0011\t\u0006\u0003\u0004\u0003r~\u0001\r!O\u0001\u0010G2\f7o\u001d)bi\"dun\\6vaR!11BB\u0017\u0011\u0015Q\u0005\u00051\u0001M\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\u0019\u0019da\u000e\u0015\u0007\u0011\u001c)\u0004C\u0003RC\u0001\u000f1\u000bC\u0003KC\u0001\u0007A*A\txSRD'i\\8uG2\f7o\u001d9bi\"$rA`B\u001f\u0007\u000f\u001aI\u0005C\u0004\u0004@\t\u0002\ra!\u0011\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b\u000e\r\u0013bAB#S\t\t2i\\7qS2,'/\u0011:hk6,g\u000e^:\t\r\tE!\u00051\u0001\u007f\u0011\u001d\u00119A\ta\u0001\u0005\u0013\tQ#\u001a=qY&\u001c\u0017\u000e\u001e\"p_R\u001cE.Y:ta\u0006$\b\u000eF\u0003\u007f\u0007\u001f\u001a\t\u0006C\u0004\u00030\r\u0002\rA!\r\t\u000f\t\u001d1\u00051\u0001\u0003\nAA1QKB.\u0003[\u0019y&\u0004\u0002\u0004X)\u00191\u0011L8\u0002\u000f5,H/\u00192mK&!1QLB,\u0005\u001dA\u0015m\u001d5NCB\u0004ba!\u0019\u0004l\t%UBAB2\u0015\u0011\u0019)ga\u001a\u0002\u0007I,gM\u0003\u0003\u0004j\u0005e\u0012\u0001\u00027b]\u001eLAa!\u001c\u0004d\tI!+\u001a4fe\u0016t7-Z\u0001\fgR\fG/[2DC\u000eDW\r\u0006\u0004\u0003\n\u000eM4Q\u000f\u0005\b\u0003g)\u0003\u0019AA\u0017\u0011!\u00199(\nCA\u0002\re\u0014a\u00022bG.Lgn\u001a\t\u0006e\u0005=&\u0011R\u0001\u0012gR\fG/[2DC\u000eDW\rZ*u_J,GC\u0002BE\u0007\u007f\u001a\u0019\tC\u0004\u0004\u0002\u001a\u0002\r!!\f\u0002\u0019\u0005t\u0017\r\\=tSN4\u0015\u000e\\3\t\u000f\r\u0015e\u00051\u0001\u0002d\u0006yQo]3UKb$\u0018I\\1msNL7\u000f\u0006\t\u0003\n\u000e%51RBG\u0007#\u001bYja(\u00040\"91\u0011Q\u0014A\u0002\u00055\u0002bBBCO\u0001\u0007\u00111\u001d\u0005\b\u0007\u001f;\u0003\u0019AAr\u00035)8/Z\"p]NL7\u000f^3oi\"911S\u0014A\u0002\rU\u0015aB7baB,'o\u001d\t\u0005\u0005+\u001b9*\u0003\u0003\u0004\u001a\n]%\u0001\u0005*fC\u0012<&/\u001b;f\u001b\u0006\u0004\b/\u001a:t\u0011\u001d\u0019ij\na\u0001\u0003G\fAa]8si\"91\u0011U\u0014A\u0002\r\r\u0016AA3d!\u0011\u0019)ka+\u000e\u0005\r\u001d&bABUg\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\r56q\u0015\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDqa!-(\u0001\u0004\tI-A\u0006qCJ\fG\u000e\\3mSNl\u0007")
public final class MixedAnalyzingCompiler {
    private final ScalaCompiler scalac;
    private final AnalyzingJavaCompiler javac;
    private final CompileConfiguration config;
    private final Logger log;
    private final JarUtils.OutputJarContent outputJarContent;
    private final Seq<VirtualFile> absClasspath;

    public static AnalysisStore staticCachedStore(Path analysisFile, boolean useTextAnalysis, boolean useConsistent, ReadWriteMappers mappers, boolean sort, ExecutionContext ec, int parallelism) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(analysisFile, useTextAnalysis, useConsistent, mappers, sort, ec, parallelism);
    }

    public static AnalysisStore staticCachedStore(Path analysisFile, boolean useTextAnalysis) {
        return MixedAnalyzingCompiler$.MODULE$.staticCachedStore(analysisFile, useTextAnalysis);
    }

    public static Seq<VirtualFile> withBootclasspath(CompilerArguments args, Seq<VirtualFile> classpath, FileConverter converter) {
        return MixedAnalyzingCompiler$.MODULE$.withBootclasspath(args, classpath, converter);
    }

    public static MixedAnalyzingCompiler apply(CompileConfiguration config, Logger log) {
        return MixedAnalyzingCompiler$.MODULE$.apply(config, log);
    }

    public static Function1<String, Option<VirtualFile>> classPathLookup(CompileConfiguration config) {
        return MixedAnalyzingCompiler$.MODULE$.classPathLookup(config);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(FileConverter converter, Seq<VirtualFile> classpath, String[] scalacOptions, PerClasspathEntryLookup perClasspathEntryLookup, ScalaCompiler compiler) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(converter, classpath, scalacOptions, perClasspathEntryLookup, compiler);
    }

    public static Tuple2<Seq<VirtualFile>, Function1<String, Option<VirtualFile>>> searchClasspathAndLookup(CompileConfiguration config) {
        return MixedAnalyzingCompiler$.MODULE$.searchClasspathAndLookup(config);
    }

    public static boolean makeConfig$default$15() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$15();
    }

    public static CompileOrder makeConfig$default$14() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$14();
    }

    public static Seq<String> makeConfig$default$9() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$9();
    }

    public static Seq<String> makeConfig$default$8() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$8();
    }

    public static Option<CompileProgress> makeConfig$default$7() {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig$default$7();
    }

    public static CompileConfiguration makeConfig(ScalaCompiler scalac, JavaCompiler javac, Seq<VirtualFile> sources, FileConverter converter, Seq<VirtualFile> classpath, GlobalsCache cache, Option<CompileProgress> progress, Seq<String> options, Seq<String> javacOptions, CompileAnalysis previousAnalysis, Option<MiniSetup> previousSetup, PerClasspathEntryLookup perClasspathEntryLookup, Reporter reporter, CompileOrder compileOrder, boolean skip, IncOptions incrementalCompilerOptions, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, ReadStamps stamper, List<Tuple2<String, String>> extra) {
        return MixedAnalyzingCompiler$.MODULE$.makeConfig(scalac, javac, sources, converter, classpath, cache, progress, options, javacOptions, previousAnalysis, previousSetup, perClasspathEntryLookup, reporter, compileOrder, skip, incrementalCompilerOptions, output, outputJarContent, earlyOutput, earlyAnalysisStore, stamper, extra);
    }

    public ScalaCompiler scalac() {
        return this.scalac;
    }

    public AnalyzingJavaCompiler javac() {
        return this.javac;
    }

    public CompileConfiguration config() {
        return this.config;
    }

    public Logger log() {
        return this.log;
    }

    public void compileJava(Seq<VirtualFile> javaSrcs, AnalysisCallback callback, ClassFileManager classfileManager) {
        this.ensureOutput();
        if (javaSrcs.nonEmpty()) {
            this.timed("Java compilation + analysis", this.log(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Output output = this.config().currentSetup().output();
                IncToolOptions incToolOptions = IncToolOptions.of(Optional.of(classfileManager), (boolean)this.config().incOptions().useCustomizedFileManager());
                String[] joptions = this.config().currentSetup().options().javacOptions();
                Option option = JarUtils$.MODULE$.getOutputJar(output);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Path outputJar = (Path)some.value();
                    if (!this.javac().supportsDirectToJar()) {
                        Path outputDir = JarUtils$.MODULE$.javacTempOutput(outputJar);
                        Files.createDirectories(outputDir, new FileAttribute[0]);
                        this.javac().compile(javaSrcs, (Seq<VirtualFile>)new .colon.colon((Object)this.toVirtualFile$1(outputJar), (List)Nil$.MODULE$), this.config().converter(), (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)joptions), CompileOutput$.MODULE$.apply(outputDir), (Option<Path>)new Some((Object)outputJar), callback, incToolOptions, this.config().reporter(), (xsbti.Logger)this.log(), this.config().progress());
                        this.putJavacOutputInJar(outputJar.toFile(), outputDir.toFile());
                        return;
                    }
                }
                JarUtils$.MODULE$.withPreviousJar(output, (Function1 & Serializable)extraClasspath -> {
                    MixedAnalyzingCompiler.$anonfun$compileJava$2(this, javaSrcs, joptions, output, callback, incToolOptions, extraClasspath);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    public Seq<Path> ensureOutput() {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.outputDirectories(output);
        outputDirs.foreach((Function1 & Serializable)d -> {
            Path dir = ((Object)d).toString().endsWith(".jar") ? d.getParent() : d;
            return Files.createDirectories(dir, new FileAttribute[0]);
        });
        return outputDirs;
    }

    public void compile(Set<VirtualFile> include, DependencyChanges changes, AnalysisCallback callback, ClassFileManager classfileManager) {
        Output output = this.config().currentSetup().output();
        Seq<Path> outputDirs = this.ensureOutput();
        Seq incSrc = (Seq)this.config().sources().filter(include);
        Tuple2 tuple2 = incSrc.partition((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MixedAnalyzingCompiler$.MODULE$.javaOnly(f)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq javaSrcs = (Seq)tuple2._1();
        Seq scalaSrcs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)javaSrcs, (Object)scalaSrcs);
        Seq javaSrcs2 = (Seq)tuple22._1();
        Seq scalaSrcs2 = (Seq)tuple22._2();
        this.logInputs(this.log(), javaSrcs2.size(), scalaSrcs2.size(), outputDirs);
        boolean pickleJava = Incremental$.MODULE$.isPickleJava((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.config().currentSetup().options().scalacOptions()));
        if (this.config().incOptions().pipelining()) {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            if (scalaSrcs2.nonEmpty()) {
                this.log().debug((Function0 & Serializable)() -> "done compiling Scala sources");
                return;
            }
            return;
        }
        CompileOrder compileOrder = this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.JavaThenScala;
        if (!(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null)) {
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
        } else {
            this.compileScala$1(scalaSrcs2, pickleJava, callback, output, incSrc, changes);
            this.compileJava0$1(javaSrcs2, callback, classfileManager);
        }
        if (javaSrcs2.size() + scalaSrcs2.size() > 0) {
            if (ConsoleAppender$.MODULE$.showProgress()) {
                this.log().debug((Function0 & Serializable)() -> "done compiling");
                return;
            }
            this.log().info((Function0 & Serializable)() -> "done compiling");
            return;
        }
    }

    private void putJavacOutputInJar(File outputJar, File outputDir) {
        Seq compiledClasses = (Seq)syntax$.MODULE$.singleFileFinder(outputDir).$times$times(DirectoryFilter$.MODULE$.unary_$minus()).get().flatMap((Function1 & Serializable)classFile -> {
            Option option = IO$.MODULE$.relativize(outputDir, classFile);
            if (option instanceof Some) {
                Some some = (Some)option;
                String relPath = (String)some.value();
                return new .colon.colon((Object)new Tuple2(classFile, (Object)relPath), (List)Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        });
        if (compiledClasses.nonEmpty()) {
            JarUtils$.MODULE$.includeInJar(outputJar, compiledClasses);
            this.outputJarContent.addClasses(((IterableOnceOps)compiledClasses.map((Function1 & Serializable)x$3 -> (String)x$3._2())).toSet());
        }
        IO$.MODULE$.delete(outputDir);
    }

    private Seq<Path> outputDirectories(Output output) {
        Output output2 = output;
        if (output2 instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output2;
            return new .colon.colon((Object)singleOutput.getOutputDirectoryAsPath(), (List)Nil$.MODULE$);
        }
        if (output2 instanceof MultipleOutput) {
            MultipleOutput multipleOutput = (MultipleOutput)output2;
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])multipleOutput.getOutputGroups()), (Function1 & Serializable)x$4 -> x$4.getOutputDirectoryAsPath(), ClassTag$.MODULE$.apply(Path.class)));
        }
        throw new MatchError((Object)output2);
    }

    private <T> T timed(String label, Logger log, Function0<T> t) {
        long start = System.nanoTime();
        Object result = t.apply();
        long elapsed = System.nanoTime() - start;
        log.debug((Function0 & Serializable)() -> new StringBuilder(8).append(label).append(" took ").append((double)elapsed / 1.0E9).append(" s").toString());
        return (T)result;
    }

    private void logInputs(Logger log, int javaCount, int scalaCount, Seq<Path> outputDirs) {
        Option scalaMsg = Analysis$.MODULE$.counted("Scala source", "", "s", scalaCount);
        Option javaMsg = Analysis$.MODULE$.counted("Java source", "", "s", javaCount);
        Iterable combined = (Iterable)Option$.MODULE$.option2Iterable(scalaMsg).$plus$plus((IterableOnce)javaMsg);
        if (combined.nonEmpty()) {
            String targets = ((IterableOnceOps)outputDirs.map((Function1 & Serializable)x$5 -> x$5.toAbsolutePath())).mkString(",");
            log.info((Function0 & Serializable)() -> combined.mkString("compiling ", " and ", new StringBuilder(8).append(" to ").append(targets).append(" ...").toString()));
            return;
        }
    }

    private final VirtualFile toVirtualFile$1(Path p) {
        return this.config().converter().toVirtualFile(p.toAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$compileJava$2(MixedAnalyzingCompiler $this, Seq javaSrcs$1, String[] joptions$1, Output output$1, AnalysisCallback callback$1, IncToolOptions incToolOptions$1, Seq extraClasspath) {
        $this.javac().compile((Seq<VirtualFile>)javaSrcs$1, (Seq<VirtualFile>)((Seq)extraClasspath.map((Function1 & Serializable)p -> $this.toVirtualFile$1((Path)p))), $this.config().converter(), (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)joptions$1), output$1, (Option<Path>)None$.MODULE$, callback$1, incToolOptions$1, $this.config().reporter(), (xsbti.Logger)$this.log(), $this.config().progress());
    }

    public static final /* synthetic */ void $anonfun$compile$4(MixedAnalyzingCompiler $this, Seq incSrc$1, Seq scalaSrcs$1, boolean pickleJava$1, DependencyChanges changes$1, String[] scalacOpts$1, Output output$2, AnalysisCallback callback$2, Seq extraClasspath) {
        Vector vector;
        CompileOrder compileOrder = $this.config().currentSetup().order();
        CompileOrder compileOrder2 = CompileOrder.Mixed;
        Seq sources = !(compileOrder != null ? !compileOrder.equals(compileOrder2) : compileOrder2 != null) ? incSrc$1 : scalaSrcs$1;
        Vector cp0 = (Vector)((IterableOps)extraClasspath.toVector().map((Function1 & Serializable)x -> $this.config().converter().toVirtualFile(x.toAbsolutePath()))).$plus$plus((IterableOnce)$this.absClasspath.toVector());
        if (scalaSrcs$1.isEmpty() && pickleJava$1) {
            Vector libraryJars = (Vector)Predef$.MODULE$.wrapRefArray((Object[])$this.scalac().scalaInstance().libraryJars()).toVector().map((Function1 & Serializable)x -> $this.config().converter().toVirtualFile(x.toPath()));
            vector = (Vector)((SeqOps)cp0.$plus$plus((IterableOnce)libraryJars)).distinct();
        } else {
            vector = cp0;
        }
        Vector cp = vector;
        $this.timed("Scala compilation", $this.log(), (Function0)(JFunction0.mcV.sp & Serializable)() -> $this.config().compiler().compile((VirtualFile[])sources.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), (VirtualFile[])cp.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)), $this.config().converter(), changes$1, (String[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])scalacOpts$1), ClassTag$.MODULE$.apply(String.class)), output$2, callback$2, $this.config().reporter(), JavaInterfaceUtil$.MODULE$.EnrichOption($this.config().progress()).toOptional(), (xsbti.Logger)$this.log()));
    }

    private final void compileScala$1(Seq scalaSrcs$1, boolean pickleJava$1, AnalysisCallback callback$2, Output output$2, Seq incSrc$1, DependencyChanges changes$1) {
        if (scalaSrcs$1.nonEmpty() || pickleJava$1) {
            String[] stringArray;
            Some some;
            Tuple2 tuple2;
            Option pickleJarPair = JavaInterfaceUtil$.MODULE$.EnrichOptional(callback$2.getPickleJarPair()).toOption().map((Function1 & Serializable)t2 -> new Tuple2(t2.get1(), t2.get2()));
            Option option = pickleJarPair;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Path originalJar = (Path)tuple2._1();
                Path updatesJar = (Path)tuple2._2();
                String path = ((Object)originalJar).toString();
                String fwdSlashPath = path.replace('\\', '/');
                stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.config().currentSetup().options().scalacOptions()), (Function1 & Serializable)x0$1 -> {
                    String string;
                    block5: {
                        block4: {
                            string = x0$1;
                            switch (string == null ? 0 : string.hashCode()) {
                                default: 
                            }
                            String string2 = string;
                            String string3 = path;
                            if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block4;
                            String string4 = string;
                            String string5 = fwdSlashPath;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block5;
                        }
                        return ((Object)updatesJar).toString();
                    }
                    return string;
                }, ClassTag$.MODULE$.apply(String.class));
            } else {
                stringArray = this.config().currentSetup().options().scalacOptions();
            }
            String[] scalacOpts = stringArray;
            JarUtils$.MODULE$.withPreviousJar(output$2, (Function1 & Serializable)extraClasspath -> {
                MixedAnalyzingCompiler.$anonfun$compile$4(this, incSrc$1, scalaSrcs$1, pickleJava$1, changes$1, scalacOpts, output$2, callback$2, extraClasspath);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void compileJava0$1(Seq javaSrcs$2, AnalysisCallback callback$2, ClassFileManager classfileManager$2) {
        this.compileJava((Seq<VirtualFile>)javaSrcs$2, callback$2, classfileManager$2);
    }

    public MixedAnalyzingCompiler(ScalaCompiler scalac, AnalyzingJavaCompiler javac, CompileConfiguration config, Logger log, JarUtils.OutputJarContent outputJarContent) {
        this.scalac = scalac;
        this.javac = javac;
        this.config = config;
        this.log = log;
        this.outputJarContent = outputJarContent;
        this.absClasspath = (Seq)config.classpath().map((Function1 & Serializable)x$1 -> VirtualFileUtil$.MODULE$.toAbsolute(x$1));
    }
}

