/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import coursierapi.MavenRepository;
import coursierapi.Repository;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.scalafmt.dynamic.BuildInfo$;
import org.scalafmt.dynamic.ConsoleScalafmtReporter$;
import org.scalafmt.dynamic.ScalafmtDynamic$;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader;
import org.scalafmt.dynamic.ScalafmtDynamicDownloader$;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtReflect;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.exceptions.ReflectionException$;
import org.scalafmt.dynamic.exceptions.ScalafmtConfigException;
import org.scalafmt.dynamic.utils.ReentrantCache;
import org.scalafmt.dynamic.utils.ReentrantCache$;
import org.scalafmt.interfaces.Scalafmt;
import org.scalafmt.interfaces.ScalafmtReporter;
import org.scalafmt.interfaces.ScalafmtSession;
import org.scalafmt.interfaces.ScalafmtSessionFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\red\u0001\u0002#F\u00052C\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005S\"AQ\u000e\u0001BK\u0002\u0013\u0005a\u000eC\u0005\u0002\u0004\u0001\u0011\t\u0012)A\u0005_\"Q\u0011Q\u0001\u0001\u0003\u0016\u0004%\t!a\u0002\t\u0015\u0005=\u0001A!E!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011)\u001a!C\u0001\u0003\u000fA!\"a\u0005\u0001\u0005#\u0005\u000b\u0011BA\u0005\u0011)\t)\u0002\u0001BK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003S\u0001!\u0011#Q\u0001\n\u0005e\u0001BCA\u0016\u0001\tU\r\u0011\"\u0001\u0002.!Q\u0011\u0011\u001f\u0001\u0003\u0012\u0003\u0006I!a\f\t\u0015\u0005\u001d\u0006A!f\u0001\n\u0003\t9\u0001\u0003\u0006\u0002t\u0002\u0011\t\u0012)A\u0005\u0003\u0013A!\"a+\u0001\u0005+\u0007I\u0011AA{\u0011)\tY\u0010\u0001B\tB\u0003%\u0011q\u001f\u0005\b\u00033\u0002A\u0011AA\u007f\u0011\u001d\tI\u0006\u0001C\u0001\u0005\u001fAqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!q\u0005\u0001\u0005B\t%\u0002b\u0002B\u0017\u0001\u0011\u0005#q\u0006\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011\u001d\u0011I\u0004\u0001C!\u0005wAqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\t}\u0003\u0001\"\u0003\u0003b!9!q\r\u0001\u0005\n\t%\u0004b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005s\u0002A\u0011\u0002B>\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000bCqAa'\u0001\t\u0013\u0011i\nC\u0004\u0003*\u0002!IAa+\t\u000f\tM\u0006\u0001\"\u0003\u00036\"9!1\u0018\u0001\u0005B\tu\u0006b\u0002Bd\u0001\u0011\u0005#\u0011\u001a\u0004\u0007\u0005'\u0004AA!6\t\u0015\t]gE!A!\u0002\u0013\t9\rC\u0004\u0002Z\u0019\"\tA!7\t\u000f\teb\u0005\"\u0011\u0003b\"9!q\u001d\u0014\u0005B\t%\b\"\u0003Bw\u0001\u0005\u0005I\u0011\u0001Bx\u0011%\u0019\t\u0001AI\u0001\n\u0003\u0019\u0019\u0001C\u0005\u0004\u001a\u0001\t\n\u0011\"\u0001\u0004\u001c!I1q\u0004\u0001\u0012\u0002\u0013\u00051\u0011\u0005\u0005\n\u0007K\u0001\u0011\u0013!C\u0001\u0007CA\u0011ba\n\u0001#\u0003%\ta!\u000b\t\u0013\r5\u0002!%A\u0005\u0002\r=\u0002\"CB\u001a\u0001E\u0005I\u0011AB\u0011\u0011%\u0019)\u0004AI\u0001\n\u0003\u00199\u0004C\u0005\u0004<\u0001\t\t\u0011\"\u0011\u0004>!I11\t\u0001\u0002\u0002\u0013\u00051Q\t\u0005\n\u0007\u001b\u0002\u0011\u0011!C\u0001\u0007\u001fB\u0011b!\u0016\u0001\u0003\u0003%\tea\u0016\t\u0013\r\u0015\u0004!!A\u0005\u0002\r\u001d\u0004\"CB6\u0001\u0005\u0005I\u0011IB7\u0011%\u0019y\u0007AA\u0001\n\u0003\u001a\t\bC\u0005\u0004t\u0001\t\t\u0011\"\u0011\u0004v\u001d9\u00111J#\t\u0002\u00055cA\u0002#F\u0011\u0003\t\t\u0006C\u0004\u0002Zu\"\t!a\u0017\u0006\r\u0005uS\bAA0\u000b\u0019\tY'\u0010\u0003\u0002n!I\u0011qQ\u001f\u0002\u0002\u0013\u0005\u0015\u0011\u0012\u0005\n\u00033l\u0014\u0011!CA\u00037D\u0011\"!<>\u0003\u0003%I!a<\u0003\u001fM\u001b\u0017\r\\1g[R$\u0015P\\1nS\u000eT!AR$\u0002\u000f\u0011Lh.Y7jG*\u0011\u0001*S\u0001\tg\u000e\fG.\u00194ni*\t!*A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001\u001bV[f\f\u001a\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019y%M[3diB\u0011a+W\u0007\u0002/*\u0011\u0001lR\u0001\u000bS:$XM\u001d4bG\u0016\u001c\u0018B\u0001.X\u0005!\u00196-\u00197bM6$\bC\u0001,]\u0013\tivK\u0001\fTG\u0006d\u0017MZ7u'\u0016\u001c8/[8o\r\u0006\u001cGo\u001c:z!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u001d\u0001&o\u001c3vGR\u0004\"aX3\n\u0005\u0019\u0004'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u0003:fa>\u0014H/\u001a:\u0016\u0003%\u0004\"A\u00166\n\u0005-<&\u0001E*dC2\fg-\u001c;SKB|'\u000f^3s\u0003%\u0011X\r]8si\u0016\u0014\b%\u0001\u0007sKB|7/\u001b;pe&,7/F\u0001p!\r\u0001\bp\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001^&\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0017BA<a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\t1K7\u000f\u001e\u0006\u0003o\u0002\u0004\"\u0001`@\u000e\u0003uT\u0011A`\u0001\fG>,(o]5fe\u0006\u0004\u0018.C\u0002\u0002\u0002u\u0014!BU3q_NLGo\u001c:z\u00035\u0011X\r]8tSR|'/[3tA\u0005q!/Z:qK\u000e$h+\u001a:tS>tWCAA\u0005!\ry\u00161B\u0005\u0004\u0003\u001b\u0001'a\u0002\"p_2,\u0017M\\\u0001\u0010e\u0016\u001c\b/Z2u-\u0016\u00148/[8oA\u0005)\"/Z:qK\u000e$X\t_2mk\u0012,g)\u001b7uKJ\u001c\u0018A\u0006:fgB,7\r^#yG2,H-\u001a$jYR,'o\u001d\u0011\u0002\u001d\u0011,g-Y;miZ+'o]5p]V\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005}\u0001C\u0001:a\u0013\r\t\t\u0003Y\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0002-A\beK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8!\u0003-1wN]7bi\u000e\u000b7\r[3\u0016\u0005\u0005=\u0002\u0003CA\u0019\u0003o\tI\"a\u000f\u000e\u0005\u0005M\"bAA\u001b\u000b\u0006)Q\u000f^5mg&!\u0011\u0011HA\u001a\u00059\u0011V-\u001a8ue\u0006tGoQ1dQ\u0016\u0004R!!\u0010A\u0003?s1!a\u0010=\u001d\u0011\t\t%!\u0013\u000f\t\u0005\r\u0013q\t\b\u0004e\u0006\u0015\u0013\"\u0001&\n\u0005!K\u0015B\u0001$H\u0003=\u00196-\u00197bM6$H)\u001f8b[&\u001c\u0007cAA({5\tQi\u0005\u0003>\u0003'\"\u0007cA0\u0002V%\u0019\u0011q\u000b1\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011Q\n\u0002\r\r>\u0014X.\u0019;SKN,H\u000e\u001e\t\ba\u0006\u0005\u0014QMA\r\u0013\r\t\u0019G\u001f\u0002\u0007\u000b&$\b.\u001a:\u0011\t\u0005=\u0013qM\u0005\u0004\u0003S*%\u0001F*dC2\fg-\u001c;Es:\fW.[2FeJ|'O\u0001\u0006G_Jl\u0017\r^#wC2,B!a\u001c\u0002vA9\u0001/!\u0019\u0002f\u0005E\u0004\u0003BA:\u0003kb\u0001\u0001B\u0004\u0002x\u0001\u0013\r!!\u001f\u0003\u0003Q\u000bB!a\u001f\u0002\u0002B\u0019q,! \n\u0007\u0005}\u0004MA\u0004O_RD\u0017N\\4\u0011\u0007}\u000b\u0019)C\u0002\u0002\u0006\u0002\u00141!\u00118z\u0003\u0015\t\u0007\u000f\u001d7z)I\tY)!$\u0002\u0010\u0006E\u00151SAK\u0003/\u000b)+!+\u0011\u0007\u0005=\u0003\u0001C\u0003h\u0003\u0002\u0007\u0011\u000eC\u0003n\u0003\u0002\u0007q\u000eC\u0004\u0002\u0006\u0005\u0003\r!!\u0003\t\u000f\u0005E\u0011\t1\u0001\u0002\n!9\u0011QC!A\u0002\u0005e\u0001bBA\u0016\u0003\u0002\u0007\u0011\u0011\u0014\t\t\u0003c\t9$!\u0007\u0002\u001cB)\u0011Q\u0014!\u0002 6\tQ\b\u0005\u0003\u0002P\u0005\u0005\u0016bAAR\u000b\ny1kY1mC\u001alGOU3gY\u0016\u001cG\u000fC\u0004\u0002(\u0006\u0003\r!!\u0003\u0002\u0019\r\f7\r[3D_:4\u0017nZ:\t\u000f\u0005-\u0016\t1\u0001\u0002.\u0006a1m\u001c8gS\u001e\u001c8)Y2iKBA\u0011\u0011GA\u001c\u0003_\u000by\f\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\t\u0019LG.\u001a\u0006\u0004\u0003s\u000b\u0016a\u00018j_&!\u0011QXAZ\u0005\u0011\u0001\u0016\r\u001e5\u0011\u000b\u0005u\u0005)!1\u0011\u000f}\u000b\u0019-a2\u0002N&\u0019\u0011Q\u00191\u0003\rQ+\b\u000f\\33!\u0011\ty%!3\n\u0007\u0005-WIA\u000bTG\u0006d\u0017MZ7u%\u00164G.Z2u\u0007>tg-[4\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#TA!a5\u00024\u0006I\u0011\r\u001e;sS\n,H/Z\u0005\u0005\u0003/\f\tN\u0001\u0005GS2,G+[7f\u0003\u001d)h.\u00199qYf$B!!8\u0002jB)q,a8\u0002d&\u0019\u0011\u0011\u001d1\u0003\r=\u0003H/[8o!Ey\u0016Q]5p\u0003\u0013\tI!!\u0007\u0002\u001a\u0006%\u0011QV\u0005\u0004\u0003O\u0004'A\u0002+va2,\u0007\bC\u0005\u0002l\n\u000b\t\u00111\u0001\u0002\f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002\u001b\u0006aam\u001c:nCR\u001c\u0015m\u00195fA\u0005i1-Y2iK\u000e{gNZ5hg\u0002*\"!a>\u0011\u0011\u0005E\u0012qGAX\u0003s\u0004R!!\u0010A\u0003\u0003\fQbY8oM&<7oQ1dQ\u0016\u0004CCEAF\u0003\u007f\u0014\tAa\u0001\u0003\u0006\t\u001d!\u0011\u0002B\u0006\u0005\u001bAQaZ\tA\u0002%DQ!\\\tA\u0002=Dq!!\u0002\u0012\u0001\u0004\tI\u0001C\u0004\u0002\u0012E\u0001\r!!\u0003\t\u000f\u0005U\u0011\u00031\u0001\u0002\u001a!9\u00111F\tA\u0002\u0005=\u0002bBAT#\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003W\u000b\u0002\u0019AA|)\t\tY)A\u0003dY\u0016\f'\u000f\u0006\u0002\u0003\u0016A\u0019qLa\u0006\n\u0007\te\u0001M\u0001\u0003V]&$\u0018\u0001D<ji\"\u0014V\r]8si\u0016\u0014H\u0003BAF\u0005?AQa\u001a\u000bA\u0002%\f\u0011d^5uQJ+7\u000f]3diB\u0013xN[3di\u001aKG\u000e^3sgR!\u00111\u0012B\u0013\u0011\u001d\t\t\"\u0006a\u0001\u0003\u0013\t!c^5uQJ+7\u000f]3diZ+'o]5p]R!\u00111\u0012B\u0016\u0011\u001d\t)A\u0006a\u0001\u0003\u0013\t!c^5uQ\u0012+g-Y;miZ+'o]5p]R!\u00111\u0012B\u0019\u0011\u001d\t)b\u0006a\u0001\u00033\t\u0011c^5uQ\u000e{gNZ5h\u0007\u0006\u001c\u0007.\u001b8h)\u0011\tYIa\u000e\t\u000f\u0005\u001d\u0006\u00041\u0001\u0002\n\u00051am\u001c:nCR$\u0002\"!\u0007\u0003>\t\u0005#1\t\u0005\b\u0005\u007fI\u0002\u0019AAX\u0003\u0019\u0019wN\u001c4jO\"9\u0011QW\rA\u0002\u0005=\u0006b\u0002B#3\u0001\u0007\u0011\u0011D\u0001\u0005G>$W-A\u0006sKB|'\u000f^#se>\u0014HC\u0002B\u000b\u0005\u0017\u0012i\u0005C\u0004\u00026j\u0001\r!a,\t\u000f\t=#\u00041\u0001\u0002f\u0005)QM\u001d:pe\u0006qam\u001c:nCR$U\r^1jY\u0016$G\u0003\u0003B+\u0005/\u0012YF!\u0018\u0011\u0007\u0005ur\bC\u0004\u0003Zm\u0001\r!a,\u0002\u0015\r|gNZ5h!\u0006$\b\u000eC\u0004\u00026n\u0001\r!a,\t\u000f\t\u00153\u00041\u0001\u0002\u001a\u0005i!/Z:pYZ,7i\u001c8gS\u001e$BAa\u0019\u0003fA9\u0001/!\u0019\u0002f\u0005\u001d\u0007b\u0002B-9\u0001\u0007\u0011qV\u0001\u001ae\u0016\u001cx\u000e\u001c<f\u0007>tg-[4XSRD7kY1mC\u001alG\u000f\u0006\u0003\u0003l\t5\u0004#BA\u001f\u0001\u0006\u001d\u0007b\u0002B-;\u0001\u0007\u0011qV\u0001\fa\u0006\u00148/Z\"p]\u001aLw\r\u0006\u0004\u0003l\tM$Q\u000f\u0005\b\u00053r\u0002\u0019AAX\u0011\u001d\u00119H\ba\u0001\u0003?\u000b!BZ7u%\u00164G.Z2u\u0003A\u0011Xm]8mm\u00164uN]7biR,'\u000f\u0006\u0004\u0002<\tu$q\u0010\u0005\b\u00053z\u0002\u0019AAX\u0011\u001d\u0011\ti\ba\u0001\u00033\tqA^3sg&|g.\u0001\tsKN|GN^3DY\u0006\u001c8\u000fU1uQR1\u00111\bBD\u0005\u0013CqA!\u0017!\u0001\u0004\ty\u000bC\u0004\u0003\f\u0002\u0002\rA!$\u0002\u001f\u0011|wO\u001c7pC\u0012\u001cVoY2fgN\u0004BAa$\u0003\u0016:!\u0011q\bBI\u0013\r\u0011\u0019*R\u0001\u001a'\u000e\fG.\u00194ni\u0012Kh.Y7jG\u0012{wO\u001c7pC\u0012,'/\u0003\u0003\u0003\u0018\ne%a\u0004#po:dw.\u00193Tk\u000e\u001cWm]:\u000b\u0007\tMU)A\u0005uef4uN]7biRQ!Q\u000bBP\u0005C\u0013\u0019Ka*\t\u000f\u0005U\u0016\u00051\u0001\u00020\"9!QI\u0011A\u0002\u0005e\u0001b\u0002BSC\u0001\u0007\u0011qT\u0001\be\u00164G.Z2u\u0011\u001d\u0011y$\ta\u0001\u0003\u000f\fQ\"[:JO:|'/\u001a3GS2,GCBA\u0005\u0005[\u0013\t\fC\u0004\u00030\n\u0002\r!!\u0007\u0002\u0011\u0019LG.\u001a8b[\u0016DqAa\u0010#\u0001\u0004\t9-A\u0006sK\u0006$g+\u001a:tS>tG\u0003\u0002B\\\u0005s\u0003RaXAp\u00033AqAa\u0010$\u0001\u0004\ty+A\u000bxSRDW*\u0019<f]J+\u0007o\\:ji>\u0014\u0018.Z:\u0015\u0007U\u0013y\f\u0003\u0004nI\u0001\u0007!\u0011\u0019\t\u0006?\n\r\u0017\u0011D\u0005\u0004\u0005\u000b\u0004'A\u0003\u001fsKB,\u0017\r^3e}\u0005i1M]3bi\u0016\u001cVm]:j_:$BAa3\u0003RB\u0019aK!4\n\u0007\t=wKA\bTG\u0006d\u0017MZ7u'\u0016\u001c8/[8o\u0011\u001d\u0011y$\na\u0001\u0003_\u0013\u0011\"T=TKN\u001c\u0018n\u001c8\u0014\t\u0019j%1Z\u0001\u0004G\u001a<G\u0003\u0002Bn\u0005?\u00042A!8'\u001b\u0005\u0001\u0001b\u0002BlQ\u0001\u0007\u0011q\u0019\u000b\u0007\u00033\u0011\u0019O!:\t\u000f\u0005U\u0016\u00061\u0001\u00020\"9!QI\u0015A\u0002\u0005e\u0011!F7bi\u000eDWm\u001d)s_*,7\r\u001e$jYR,'o\u001d\u000b\u0005\u0003\u0013\u0011Y\u000fC\u0004\u00026*\u0002\r!a,\u0002\t\r|\u0007/\u001f\u000b\u0013\u0003\u0017\u0013\tPa=\u0003v\n](\u0011 B~\u0005{\u0014y\u0010C\u0004hWA\u0005\t\u0019A5\t\u000f5\\\u0003\u0013!a\u0001_\"I\u0011QA\u0016\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003#Y\u0003\u0013!a\u0001\u0003\u0013A\u0011\"!\u0006,!\u0003\u0005\r!!\u0007\t\u0013\u0005-2\u0006%AA\u0002\u0005=\u0002\"CATWA\u0005\t\u0019AA\u0005\u0011%\tYk\u000bI\u0001\u0002\u0004\t90\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r\u0015!fA5\u0004\b-\u00121\u0011\u0002\t\u0005\u0007\u0017\u0019)\"\u0004\u0002\u0004\u000e)!1qBB\t\u0003%)hn\u00195fG.,GMC\u0002\u0004\u0014\u0001\f!\"\u00198o_R\fG/[8o\u0013\u0011\u00199b!\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\ru!fA8\u0004\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u0012U\u0011\tIaa\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAB\u0016U\u0011\tIba\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u00111\u0011\u0007\u0016\u0005\u0003_\u00199!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u00111\u0011\b\u0016\u0005\u0003o\u001c9!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007\u007f\u00012ATB!\u0013\r\t)cT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0007\u000f\u00022aXB%\u0013\r\u0019Y\u0005\u0019\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\u001b\t\u0006C\u0005\u0004TY\n\t\u00111\u0001\u0004H\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0017\u0011\r\rm3\u0011MAA\u001b\t\u0019iFC\u0002\u0004`\u0001\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019g!\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\u0019I\u0007C\u0005\u0004Ta\n\t\u00111\u0001\u0002\u0002\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0004H\u0005AAo\\*ue&tw\r\u0006\u0002\u0004@\u00051Q-];bYN$B!!\u0003\u0004x!I11K\u001e\u0002\u0002\u0003\u0007\u0011\u0011\u0011")
public final class ScalafmtDynamic
implements Scalafmt,
ScalafmtSessionFactory,
Product,
scala.Serializable {
    private final ScalafmtReporter reporter;
    private final List<Repository> repositories;
    private final boolean respectVersion;
    private final boolean respectExcludeFilters;
    private final String defaultVersion;
    private final ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache;
    private final boolean cacheConfigs;
    private final ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache;

    public static Option<Tuple8<ScalafmtReporter, List<Repository>, Object, Object, String, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>>, Object, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>>> unapply(ScalafmtDynamic scalafmtDynamic) {
        return ScalafmtDynamic$.MODULE$.unapply(scalafmtDynamic);
    }

    public static ScalafmtDynamic apply(ScalafmtReporter scalafmtReporter, List<Repository> list, boolean bl, boolean bl2, String string, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache, boolean bl3, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache2) {
        return ScalafmtDynamic$.MODULE$.apply(scalafmtReporter, list, bl, bl2, string, reentrantCache, bl3, reentrantCache2);
    }

    public ScalafmtReporter reporter() {
        return this.reporter;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public boolean respectVersion() {
        return this.respectVersion;
    }

    public boolean respectExcludeFilters() {
        return this.respectExcludeFilters;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache() {
        return this.formatCache;
    }

    public boolean cacheConfigs() {
        return this.cacheConfigs;
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache() {
        return this.configsCache;
    }

    public void clear() {
        this.formatCache().clear().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ScalafmtDynamic.$anonfun$clear$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
    }

    public ScalafmtDynamic withReporter(ScalafmtReporter reporter) {
        return this.copy(reporter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
    }

    public ScalafmtDynamic withRespectProjectFilters(boolean respectExcludeFilters) {
        boolean x$1 = respectExcludeFilters;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withRespectVersion(boolean respectVersion) {
        boolean x$1 = respectVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withDefaultVersion(String defaultVersion) {
        String x$1 = defaultVersion;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
    }

    public ScalafmtDynamic withConfigCaching(boolean cacheConfigs) {
        boolean x$1 = cacheConfigs;
        ScalafmtReporter x$2 = this.copy$default$1();
        List<Repository> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        String x$6 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$7 = this.copy$default$6();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    public String format(Path config, Path file, String code) {
        String string;
        Either<ScalafmtDynamicError, String> either = this.formatDetailed(config, file, code);
        if (either instanceof Right) {
            String codeFormatted;
            Right right = (Right)either;
            string = codeFormatted = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ScalafmtDynamicError error = (ScalafmtDynamicError)left.value();
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, error);
            string = code;
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public void org$scalafmt$dynamic$ScalafmtDynamic$$reportError(Path file, ScalafmtDynamicError error) {
        ScalafmtDynamicError scalafmtDynamicError = error;
        if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigParseError) {
            ScalafmtDynamicError.ConfigParseError configParseError = (ScalafmtDynamicError.ConfigParseError)scalafmtDynamicError;
            Path configPath = configParseError.configPath();
            ScalafmtConfigException cause = configParseError.cause();
            this.reporter().error(configPath, cause.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigDoesNotExist) {
            ScalafmtDynamicError.ConfigDoesNotExist configDoesNotExist = (ScalafmtDynamicError.ConfigDoesNotExist)scalafmtDynamicError;
            Path configPath = configDoesNotExist.configPath();
            this.reporter().error(configPath, "file does not exist");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.ConfigMissingVersion) {
            ScalafmtDynamicError.ConfigMissingVersion configMissingVersion = (ScalafmtDynamicError.ConfigMissingVersion)scalafmtDynamicError;
            Path configPath = configMissingVersion.configPath();
            this.reporter().missingVersion(configPath, this.defaultVersion());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CannotDownload) {
            ScalafmtDynamicError.CannotDownload cannotDownload = (ScalafmtDynamicError.CannotDownload)scalafmtDynamicError;
            Path configPath = cannotDownload.configPath();
            String version = cannotDownload.version();
            Option<Throwable> cause = cannotDownload.cause();
            String message = new StringBuilder(37).append("failed to resolve Scalafmt version '").append(version).append("'").toString();
            Option<Throwable> option = cause;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable e = (Throwable)some.value();
                this.reporter().error(configPath, message, e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.reporter().error(configPath, message);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.CorruptedClassPath) {
            ScalafmtDynamicError.CorruptedClassPath corruptedClassPath = (ScalafmtDynamicError.CorruptedClassPath)scalafmtDynamicError;
            Path configPath = corruptedClassPath.configPath();
            String version = corruptedClassPath.version();
            Throwable cause = corruptedClassPath.cause();
            String message = new StringBuilder(40).append("scalafmt version ").append(version).append(" classpath is corrupted").toString();
            this.reporter().error(configPath, message, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (scalafmtDynamicError instanceof ScalafmtDynamicError.UnknownError) {
            ScalafmtDynamicError.UnknownError unknownError = (ScalafmtDynamicError.UnknownError)scalafmtDynamicError;
            Throwable cause = unknownError.cause();
            this.reporter().error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)scalafmtDynamicError);
        }
    }

    public Either<ScalafmtDynamicError, String> formatDetailed(Path configPath, Path file, String code) {
        return this.resolveConfig(configPath).flatMap((Function1 & Serializable & scala.Serializable)config -> this.org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, config.fmtReflect(), (ScalafmtReflectConfig)config).map((Function1 & Serializable & scala.Serializable)codeFormatted -> codeFormatted));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfig(Path configPath) {
        Left left;
        if (!Files.exists(configPath, new LinkOption[0])) {
            left = package$.MODULE$.Left().apply((Object)new ScalafmtDynamicError.ConfigDoesNotExist(configPath));
        } else if (this.cacheConfigs()) {
            FileTime currentTimestamp = Files.getLastModifiedTime(configPath, new LinkOption[0]);
            left = this.configsCache().getOrAddToCache(configPath, (Function1<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$1(currentTimestamp, x$4)), (Function0<Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>>)(Function0 & Serializable & scala.Serializable)() -> this.resolveConfigWithScalafmt(configPath).map((Function1 & Serializable & scala.Serializable)config -> {
                this.reporter().parsedConfig(configPath, config.version());
                return new Tuple2(config, (Object)currentTimestamp);
            })).map((Function1 & Serializable & scala.Serializable)x$7 -> (ScalafmtReflectConfig)x$7._1());
        } else {
            left = this.resolveConfigWithScalafmt(configPath);
        }
        return left;
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> resolveConfigWithScalafmt(Path configPath) {
        return this.readVersion(configPath).toRight((Function0 & Serializable & scala.Serializable)() -> new ScalafmtDynamicError.ConfigMissingVersion(configPath)).flatMap((Function1 & Serializable & scala.Serializable)version -> this.resolveFormatter(configPath, (String)version).flatMap((Function1 & Serializable & scala.Serializable)fmtReflect -> this.parseConfig(configPath, (ScalafmtReflect)fmtReflect).map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    private Either<ScalafmtDynamicError, ScalafmtReflectConfig> parseConfig(Path configPath, ScalafmtReflect fmtReflect) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fmtReflect.parseConfig(configPath)).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ScalafmtConfigException) {
                ScalafmtConfigException scalafmtConfigException = (ScalafmtConfigException)throwable;
                product = new ScalafmtDynamicError.ConfigParseError(configPath, scalafmtConfigException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveFormatter(Path configPath, String version) {
        return this.formatCache().getOrAddToCache(version, this.formatCache().getOrAddToCache$default$2(), (Function0<Either<ScalafmtDynamicError, ScalafmtReflect>>)(Function0 & Serializable & scala.Serializable)() -> {
            OutputStreamWriter writer = this.reporter().downloadOutputStreamWriter();
            ScalafmtDynamicDownloader downloader = new ScalafmtDynamicDownloader(writer, this.repositories(), ScalafmtDynamicDownloader$.MODULE$.$lessinit$greater$default$3());
            return downloader.download(version).left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ScalafmtDynamicError.CannotDownload cannotDownload;
                ScalafmtDynamicDownloader.DownloadFailure downloadFailure = x0$1;
                if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadResolutionError) {
                    ScalafmtDynamicDownloader.DownloadResolutionError downloadResolutionError = (ScalafmtDynamicDownloader.DownloadResolutionError)downloadFailure;
                    String v = downloadResolutionError.version();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)None$.MODULE$);
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.DownloadUnknownError) {
                    ScalafmtDynamicDownloader.DownloadUnknownError downloadUnknownError = (ScalafmtDynamicDownloader.DownloadUnknownError)downloadFailure;
                    String v = downloadUnknownError.version();
                    Throwable cause = downloadUnknownError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else if (downloadFailure instanceof ScalafmtDynamicDownloader.InvalidVersionError) {
                    ScalafmtDynamicDownloader.InvalidVersionError invalidVersionError = (ScalafmtDynamicDownloader.InvalidVersionError)downloadFailure;
                    String v = invalidVersionError.version();
                    ScalafmtVersion.InvalidVersionException cause = invalidVersionError.cause();
                    cannotDownload = new ScalafmtDynamicError.CannotDownload(configPath, v, (Option<Throwable>)Option$.MODULE$.apply((Object)cause));
                } else {
                    throw new MatchError((Object)downloadFailure);
                }
                return cannotDownload;
            }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> this.resolveClassPath(configPath, (ScalafmtDynamicDownloader.DownloadSuccess)x$8));
        });
    }

    private Either<ScalafmtDynamicError, ScalafmtReflect> resolveClassPath(Path configPath, ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess) {
        ScalafmtDynamicDownloader.DownloadSuccess downloadSuccess2 = downloadSuccess;
        if (downloadSuccess2 == null) {
            throw new MatchError((Object)downloadSuccess2);
        }
        String version = downloadSuccess2.version();
        Seq<URL> urls = downloadSuccess2.jarUrls();
        Tuple2 tuple2 = new Tuple2((Object)version, urls);
        Tuple2 tuple22 = tuple2;
        String version2 = (String)tuple22._1();
        Seq urls2 = (Seq)tuple22._2();
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader classloader = new URLClassLoader((URL[])urls2.toArray(ClassTag$.MODULE$.apply(URL.class)), null);
            return new ScalafmtReflect(classloader, version2, this.respectVersion());
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            Throwable throwable = x0$1;
            if (throwable instanceof ReflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException = (ReflectiveOperationException)throwable;
                product = new ScalafmtDynamicError.CorruptedClassPath(configPath, version2, (Seq<URL>)urls2, reflectiveOperationException);
            } else {
                product = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return product;
        });
    }

    public Either<ScalafmtDynamicError, String> org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(Path file, String code, ScalafmtReflect reflect, ScalafmtReflectConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            ScalafmtReflectConfig configWithDialect;
            String filename = ((Object)file).toString();
            ScalafmtReflectConfig scalafmtReflectConfig = configWithDialect = filename.endsWith(".sbt") || filename.endsWith(".sc") ? config.withSbtDialect() : config;
            if (this.isIgnoredFile(filename, configWithDialect)) {
                this.reporter().excluded(file);
                string = code;
            } else {
                string = reflect.format(code, configWithDialect, (Option<Path>)new Some((Object)file));
            }
            return string;
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalafmtDynamicError.UnknownError unknownError;
            Throwable throwable = x0$1;
            Option<Throwable> option = ReflectionException$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                unknownError = new ScalafmtDynamicError.UnknownError(e);
            } else {
                unknownError = new ScalafmtDynamicError.UnknownError(throwable);
            }
            return unknownError;
        });
    }

    private boolean isIgnoredFile(String filename, ScalafmtReflectConfig config) {
        return this.respectExcludeFilters() && !config.isIncludedInProject(filename);
    }

    private Option<String> readVersion(Path config) {
        Some some;
        try {
            some = new Some((Object)ConfigFactory.parseFile((File)config.toFile()).getString("version"));
        }
        catch (Throwable throwable) {
            Some some2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ConfigException.Missing && !this.respectVersion()) {
                some2 = new Some((Object)this.defaultVersion());
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    some2 = None$.MODULE$;
                } else {
                    throw throwable;
                }
            }
            some = some2;
        }
        return some;
    }

    public Scalafmt withMavenRepositories(Seq<String> repositories) {
        List x$12 = ((TraversableOnce)repositories.map((Function1 & Serializable & scala.Serializable)x$1 -> MavenRepository.of((String)x$1), Seq$.MODULE$.canBuildFrom())).toList();
        ScalafmtReporter x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        String x$5 = this.copy$default$5();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> x$6 = this.copy$default$6();
        boolean x$7 = this.copy$default$7();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> x$8 = this.copy$default$8();
        return this.copy(x$2, (List<Repository>)x$12, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    public ScalafmtSession createSession(Path config2) {
        return (ScalafmtSession)this.resolveConfig(config2).fold((Function1 & Serializable & scala.Serializable)error -> {
            this.org$scalafmt$dynamic$ScalafmtDynamic$$reportError(config2, (ScalafmtDynamicError)error);
            return null;
        }, (Function1 & Serializable & scala.Serializable)config -> new MySession(this, (ScalafmtReflectConfig)config));
    }

    public ScalafmtDynamic copy(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        return new ScalafmtDynamic(reporter, repositories, respectVersion, respectExcludeFilters, defaultVersion, formatCache, cacheConfigs, configsCache);
    }

    public ScalafmtReporter copy$default$1() {
        return this.reporter();
    }

    public List<Repository> copy$default$2() {
        return this.repositories();
    }

    public boolean copy$default$3() {
        return this.respectVersion();
    }

    public boolean copy$default$4() {
        return this.respectExcludeFilters();
    }

    public String copy$default$5() {
        return this.defaultVersion();
    }

    public ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> copy$default$6() {
        return this.formatCache();
    }

    public boolean copy$default$7() {
        return this.cacheConfigs();
    }

    public ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> copy$default$8() {
        return this.configsCache();
    }

    public String productPrefix() {
        return "ScalafmtDynamic";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.reporter();
                break;
            }
            case 1: {
                object = this.repositories();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectVersion());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.respectExcludeFilters());
                break;
            }
            case 4: {
                object = this.defaultVersion();
                break;
            }
            case 5: {
                object = this.formatCache();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.cacheConfigs());
                break;
            }
            case 7: {
                object = this.configsCache();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalafmtDynamic;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.reporter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.repositories()));
        n = Statics.mix((int)n, (int)(this.respectVersion() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.respectExcludeFilters() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultVersion()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.formatCache()));
        n = Statics.mix((int)n, (int)(this.cacheConfigs() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.configsCache()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalafmtDynamic)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalafmtDynamic scalafmtDynamic = (ScalafmtDynamic)x$1;
        ScalafmtReporter scalafmtReporter = this.reporter();
        ScalafmtReporter scalafmtReporter2 = scalafmtDynamic.reporter();
        if (scalafmtReporter == null) {
            if (scalafmtReporter2 != null) {
                return false;
            }
        } else if (!scalafmtReporter.equals(scalafmtReporter2)) return false;
        List<Repository> list = this.repositories();
        List<Repository> list2 = scalafmtDynamic.repositories();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (this.respectVersion() != scalafmtDynamic.respectVersion()) return false;
        if (this.respectExcludeFilters() != scalafmtDynamic.respectExcludeFilters()) return false;
        String string = this.defaultVersion();
        String string2 = scalafmtDynamic.defaultVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache = this.formatCache();
        ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> reentrantCache2 = scalafmtDynamic.formatCache();
        if (reentrantCache == null) {
            if (reentrantCache2 != null) {
                return false;
            }
        } else if (!reentrantCache.equals(reentrantCache2)) return false;
        if (this.cacheConfigs() != scalafmtDynamic.cacheConfigs()) return false;
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache3 = this.configsCache();
        ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> reentrantCache4 = scalafmtDynamic.configsCache();
        if (reentrantCache3 == null) {
            if (reentrantCache4 == null) return true;
            return false;
        } else {
            if (!reentrantCache3.equals(reentrantCache4)) return false;
            return true;
        }
    }

    public Scalafmt withMavenRepositories(String[] repositories) {
        return this.withMavenRepositories((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])repositories));
    }

    public static final /* synthetic */ void $anonfun$clear$3(ScalafmtReflect x$3) {
        x$3.classLoader().close();
    }

    public static final /* synthetic */ void $anonfun$clear$2(Either x$2) {
        x$2.right().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ScalafmtDynamic.$anonfun$clear$3(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$2(ScalafmtDynamicError x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$3(FileTime currentTimestamp$1, Tuple2 x$6) {
        return ((FileTime)x$6._2()).compareTo(currentTimestamp$1) != 0;
    }

    public static final /* synthetic */ boolean $anonfun$resolveConfig$1(FileTime currentTimestamp$1, Either x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.fold((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$2(x$5)), (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalafmtDynamic.$anonfun$resolveConfig$3(currentTimestamp$1, x$6))));
    }

    public ScalafmtDynamic(ScalafmtReporter reporter, List<Repository> repositories, boolean respectVersion, boolean respectExcludeFilters, String defaultVersion, ReentrantCache<String, Either<ScalafmtDynamicError, ScalafmtReflect>> formatCache, boolean cacheConfigs, ReentrantCache<Path, Either<ScalafmtDynamicError, Tuple2<ScalafmtReflectConfig, FileTime>>> configsCache) {
        this.reporter = reporter;
        this.repositories = repositories;
        this.respectVersion = respectVersion;
        this.respectExcludeFilters = respectExcludeFilters;
        this.defaultVersion = defaultVersion;
        this.formatCache = formatCache;
        this.cacheConfigs = cacheConfigs;
        this.configsCache = configsCache;
        Product.$init$((Product)this);
    }

    public ScalafmtDynamic() {
        this(ConsoleScalafmtReporter$.MODULE$, (List<Repository>)Nil$.MODULE$, true, true, BuildInfo$.MODULE$.stable(), ReentrantCache$.MODULE$.apply(), true, ReentrantCache$.MODULE$.apply());
    }

    public class MySession
    implements ScalafmtSession {
        private final ScalafmtReflectConfig cfg;
        public final /* synthetic */ ScalafmtDynamic $outer;

        public String format(Path file, String code) {
            return (String)this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$tryFormat(file, code, this.cfg.fmtReflect(), this.cfg).fold((Function1 & Serializable & scala.Serializable)error -> {
                this.org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer().org$scalafmt$dynamic$ScalafmtDynamic$$reportError(file, (ScalafmtDynamicError)error);
                return code;
            }, (Function1 & Serializable & scala.Serializable)formatted -> formatted);
        }

        public boolean matchesProjectFilters(Path file) {
            return this.cfg.isIncludedInProject(((Object)file).toString());
        }

        public /* synthetic */ ScalafmtDynamic org$scalafmt$dynamic$ScalafmtDynamic$MySession$$$outer() {
            return this.$outer;
        }

        public MySession(ScalafmtDynamic $outer, ScalafmtReflectConfig cfg) {
            this.cfg = cfg;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

