/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.sum$;
import breeze.math.Semiring$;
import breeze.optimize.DiffFunction;
import breeze.optimize.DiffFunction$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.ProjectedQuasiNewton;
import breeze.optimize.ProjectedQuasiNewton$;
import breeze.optimize.SpectralProjectedGradient;
import breeze.optimize.SpectralProjectedGradient$;
import breeze.optimize.proximal.Constraint$;
import breeze.optimize.proximal.LinearGenerator;
import breeze.optimize.proximal.LinearGenerator$;
import breeze.optimize.proximal.LogisticGenerator$;
import breeze.optimize.proximal.NonlinearMinimizer;
import breeze.optimize.proximal.ProjectBox;
import breeze.optimize.proximal.ProjectHyperPlane;
import breeze.optimize.proximal.ProjectIdentity;
import breeze.optimize.proximal.ProjectL1;
import breeze.optimize.proximal.ProjectPos;
import breeze.optimize.proximal.ProjectProbabilitySimplex;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalL1;
import breeze.optimize.proximal.ProximalL1$;
import breeze.optimize.proximal.QuadraticMinimizer;
import breeze.optimize.proximal.QuadraticMinimizer$;
import breeze.storage.Zero$DoubleZero$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class NonlinearMinimizer$
implements scala.Serializable {
    public static NonlinearMinimizer$ MODULE$;

    static {
        new NonlinearMinimizer$();
    }

    public FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> project(Proximal proximal, int maxIter, int m, double tolerance, boolean usePQN) {
        FirstOrderMinimizer firstOrderMinimizer;
        NonlinearMinimizer.Projection projectionOp = new NonlinearMinimizer.Projection(proximal);
        if (usePQN) {
            Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)x -> projectionOp.project((DenseVector<Object>)x);
            double x$8 = 1.0E-6;
            int x$9 = maxIter;
            int x$10 = m;
            boolean x$11 = ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$3();
            boolean x$12 = ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$4();
            int x$13 = ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$6();
            double x$14 = ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$7();
            boolean x$15 = ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$9();
            firstOrderMinimizer = new ProjectedQuasiNewton(x$8, x$10, x$11, x$12, x$9, x$13, x$14, (Function1<DenseVector<Object>, DenseVector<Object>>)x$7, x$15, DenseVector$.MODULE$.space_Double());
        } else {
            Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)x -> projectionOp.project((DenseVector<Object>)x);
            double x$17 = tolerance;
            int x$18 = maxIter;
            int x$19 = m;
            double x$20 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$3();
            int x$21 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$4();
            double x$22 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$5();
            double x$23 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$6();
            boolean x$24 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$9();
            boolean x$25 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$10();
            int x$26 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$11();
            int x$27 = SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$12();
            firstOrderMinimizer = new SpectralProjectedGradient(x$16, x$17, x$20, x$21, x$22, x$23, x$19, x$18, x$24, x$25, x$26, x$27, DenseVector$.MODULE$.space_Double());
        }
        return firstOrderMinimizer;
    }

    public int project$default$2() {
        return -1;
    }

    public int project$default$3() {
        return 10;
    }

    public double project$default$4() {
        return 1.0E-6;
    }

    public boolean project$default$5() {
        return false;
    }

    public FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> apply(int ndim, Enumeration.Value constraint, double lambda, boolean usePQN) {
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> firstOrderMinimizer;
        Enumeration.Value value2 = constraint;
        Enumeration.Value value3 = Constraint$.MODULE$.IDENTITY();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            firstOrderMinimizer = this.project(new ProjectIdentity(), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
        } else {
            Enumeration.Value value5 = Constraint$.MODULE$.POSITIVE();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                firstOrderMinimizer = this.project(new ProjectPos(), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
            } else {
                Enumeration.Value value7 = Constraint$.MODULE$.BOX();
                Enumeration.Value value8 = value2;
                if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                    DenseVector<Object> lb = DenseVector$.MODULE$.zeros$mDc$sp(ndim, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
                    DenseVector<Object> ub = DenseVector$.MODULE$.ones$mDc$sp(ndim, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
                    firstOrderMinimizer = this.project(new ProjectBox(lb, ub), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                } else {
                    Enumeration.Value value9 = Constraint$.MODULE$.EQUALITY();
                    Enumeration.Value value10 = value2;
                    if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                        DenseVector<Object> aeq = DenseVector$.MODULE$.ones$mDc$sp(ndim, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
                        firstOrderMinimizer = this.project(new ProjectHyperPlane(aeq, 1.0), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                    } else {
                        Enumeration.Value value11 = Constraint$.MODULE$.PROBABILITYSIMPLEX();
                        Enumeration.Value value12 = value2;
                        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                            firstOrderMinimizer = this.project(new ProjectProbabilitySimplex(lambda), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                        } else {
                            Enumeration.Value value13 = Constraint$.MODULE$.SPARSE();
                            Enumeration.Value value14 = value2;
                            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                                firstOrderMinimizer = this.project(new ProjectL1(lambda), this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5());
                            } else {
                                throw new IllegalArgumentException("NonlinearMinimizer does not support the Projection Operator");
                            }
                        }
                    }
                }
            }
        }
        return firstOrderMinimizer;
    }

    public boolean apply$default$4() {
        return false;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Usage: ProjectedQuasiNewton n lambda beta");
            Predef$.MODULE$.println((Object)"Test NonlinearMinimizer with a quadratic function of dimenion n and m equalities with lambda beta for elasticNet");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        int problemSize = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
        double lambda = new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble();
        double beta = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generating Linear and Logistic Loss with rank ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)problemSize)})));
        Tuple3<DiffFunction<DenseVector<Object>>, DenseMatrix<Object>, DenseVector<Object>> tuple3 = LinearGenerator$.MODULE$.apply(problemSize);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DiffFunction quadraticCost = (DiffFunction)tuple3._1();
        DenseMatrix h = (DenseMatrix)tuple3._2();
        DenseVector q = (DenseVector)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)quadraticCost, (Object)h, (Object)q);
        Tuple3 tuple33 = tuple32;
        DiffFunction quadraticCost2 = (DiffFunction)tuple33._1();
        DenseMatrix h2 = (DenseMatrix)tuple33._2();
        DenseVector q2 = (DenseVector)tuple33._3();
        double lambdaL1 = lambda * beta;
        double lambdaL2 = lambda * (1.0 - beta);
        OWLQN<Object, DenseVector<Object>> owlqn = new OWLQN<Object, DenseVector<Object>>(-1, 10, lambdaL1, 1.0E-6, DenseVector$.MODULE$.space_Double());
        DenseMatrix<Object> regularizedGram = h2.$plus(DenseMatrix$.MODULE$.eye$mDc$sp(h2.rows(), (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()).$times$colon$times(BoxesRunTime.boxToDouble((double)lambdaL2), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulScalar()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd());
        QuadraticMinimizer sparseQp = QuadraticMinimizer$.MODULE$.apply(h2.rows(), Constraint$.MODULE$.SPARSE(), lambdaL1);
        long sparseQpStart = System.nanoTime();
        QuadraticMinimizer.State sparseQpResult = sparseQp.minimizeAndReturnState(regularizedGram, q2);
        long sparseQpTime = System.nanoTime() - sparseQpStart;
        DenseVector<Object> init = DenseVector$.MODULE$.zeros$mDc$sp(problemSize, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        long owlqnStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> owlqnResult = owlqn.minimizeAndReturnState(new LinearGenerator.Cost(regularizedGram, q2), init);
        long owlqnTime = System.nanoTime() - owlqnStart;
        Predef$.MODULE$.println((Object)"ElasticNet Formulation");
        Predef$.MODULE$.println((Object)"Linear Regression");
        double owlqnObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, owlqnResult.x()) + lambdaL1 * BoxesRunTime.unboxToDouble((Object)((Vector)owlqnResult.x()).foldLeft$mcD$sp(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double sparseQpL1Obj = BoxesRunTime.unboxToDouble((Object)sparseQpResult.x().foldLeft$mcD$sp(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double sparseQpObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, sparseQpResult.x()) + lambdaL1 * sparseQpL1Obj;
        QuadraticMinimizer.Cost quadraticCostWithL2 = new QuadraticMinimizer.Cost(regularizedGram, q2);
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        ProjectL1 projectL1Linear = new ProjectL1(sparseQpL1Obj);
        long nlSparseStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlSparseResult = this.project(projectL1Linear, this.project$default$2(), this.project$default$3(), this.project$default$4(), this.project$default$5()).minimizeAndReturnState(quadraticCostWithL2, init);
        long nlSparseTime = System.nanoTime() - nlSparseStart;
        double nlSparseL1Obj = BoxesRunTime.unboxToDouble((Object)((Vector)nlSparseResult.x()).foldLeft$mcD$sp(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        double nlSparseObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, nlSparseResult.x()) + lambdaL1 * nlSparseL1Obj;
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        NonlinearMinimizer nlProx = new NonlinearMinimizer(new ProximalL1(lambdaL1), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long nlProxStart = System.nanoTime();
        NonlinearMinimizer.State nlProxResult = nlProx.minimizeAndReturnState(quadraticCostWithL2, init);
        long nlProxTime = System.nanoTime() - nlProxStart;
        double nlProxObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, nlProxResult.z()) + lambdaL1 * BoxesRunTime.unboxToDouble((Object)nlProxResult.z().foldLeft$mcD$sp(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(agg, entry) -> agg + package$.MODULE$.abs(entry)));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"owlqn ", " ms iters ", " sparseQp ", " ms iters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)owlqnTime / 1000000.0)), BoxesRunTime.boxToInteger((int)owlqnResult.iter()), BoxesRunTime.boxToDouble((double)((double)sparseQpTime / 1000000.0)), BoxesRunTime.boxToInteger((int)sparseQpResult.iter())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nlSparseTime ", " ms iters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlSparseTime / 1000000.0)), BoxesRunTime.boxToInteger((int)nlSparseResult.iter())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nlProxTime ", " ms iters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlProxTime / 1000000.0)), BoxesRunTime.boxToInteger((int)nlProxResult.iter())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"owlqnObj ", " sparseQpObj ", " nlSparseObj ", " nlProxObj ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)owlqnObj), BoxesRunTime.boxToDouble((double)sparseQpObj), BoxesRunTime.boxToDouble((double)nlSparseObj), BoxesRunTime.boxToDouble((double)nlProxObj)})));
        DiffFunction<DenseVector<Object>> logisticLoss = LogisticGenerator$.MODULE$.apply(problemSize);
        DiffFunction<DenseVector<Object>> elasticNetLoss = DiffFunction$.MODULE$.withL2Regularization(logisticLoss, lambdaL2, DenseVector$.MODULE$.space_Double());
        Predef$.MODULE$.println((Object)"Linear Regression with Bounds");
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> nlBox = this.apply(problemSize, Constraint$.MODULE$.BOX(), 0.0, this.apply$default$4());
        long nlBoxStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlBoxResult = nlBox.minimizeAndReturnState(quadraticCostWithL2, init);
        long nlBoxTime = System.nanoTime() - nlBoxStart;
        double nlBoxObj = quadraticCostWithL2.calculate(nlBoxResult.x())._1$mcD$sp();
        QuadraticMinimizer qpBox = QuadraticMinimizer$.MODULE$.apply(problemSize, Constraint$.MODULE$.BOX(), 0.0);
        long qpBoxStart = System.nanoTime();
        QuadraticMinimizer.State qpBoxResult = qpBox.minimizeAndReturnState(regularizedGram, q2);
        long qpBoxTime = System.nanoTime() - qpBoxStart;
        double qpBoxObj = QuadraticMinimizer$.MODULE$.computeObjective(regularizedGram, q2, qpBoxResult.x());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"qpBox ", " ms iters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)qpBoxTime / 1000000.0)), BoxesRunTime.boxToInteger((int)qpBoxResult.iter())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nlBox ", " ms iters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlBoxTime / 1000000.0)), BoxesRunTime.boxToInteger((int)nlBoxResult.iter())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"qpBoxObj ", " nlBoxObj ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)qpBoxObj), BoxesRunTime.boxToDouble((double)nlBoxObj)})));
        Predef$.MODULE$.println((Object)"Logistic Regression with Bounds");
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        long nlBoxLogisticStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlBoxLogisticResult = nlBox.minimizeAndReturnState(elasticNetLoss, init);
        long nlBoxLogisticTime = System.nanoTime() - nlBoxLogisticStart;
        double nlBoxLogisticObj = elasticNetLoss.calculate(nlBoxLogisticResult.x())._1$mcD$sp();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Objective nl ", " time ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)nlBoxLogisticObj), BoxesRunTime.boxToDouble((double)((double)nlBoxLogisticTime / 1000000.0))})));
        Predef$.MODULE$.println((Object)"Linear Regression with ProbabilitySimplex");
        FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> nlSimplex = this.apply(problemSize, Constraint$.MODULE$.PROBABILITYSIMPLEX(), 1.0, this.apply$default$4());
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        long nlSimplexStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlSimplexResult = nlSimplex.minimizeAndReturnState(quadraticCost2, init);
        long nlSimplexTime = System.nanoTime() - nlSimplexStart;
        double nlSimplexObj = quadraticCost2.calculate(nlSimplexResult.x())._1$mcD$sp();
        long qpSimplexStart = System.nanoTime();
        QuadraticMinimizer.State qpSimplexResult = QuadraticMinimizer$.MODULE$.apply(problemSize, Constraint$.MODULE$.EQUALITY(), QuadraticMinimizer$.MODULE$.apply$default$3()).minimizeAndReturnState(h2, q2);
        long qpSimplexTime = System.nanoTime() - qpSimplexStart;
        double qpSimplexObj = quadraticCost2.calculate(qpSimplexResult.x())._1$mcD$sp();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Objective nl ", " qp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)nlSimplexObj), BoxesRunTime.boxToDouble((double)qpSimplexObj)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Constraint nl ", " qp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sum$.MODULE$.apply(nlSimplexResult.x(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())), sum$.MODULE$.apply(qpSimplexResult.x(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time nl ", " ms qp ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlSimplexTime / 1000000.0)), BoxesRunTime.boxToDouble((double)((double)qpSimplexTime / 1000000.0))})));
        Predef$.MODULE$.println((Object)"Logistic Regression with ProbabilitySimplex");
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        long nlLogisticSimplexStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlLogisticSimplexResult = nlSimplex.minimizeAndReturnState(elasticNetLoss, init);
        long nlLogisticSimplexTime = System.nanoTime() - nlLogisticSimplexStart;
        double nlLogisticSimplexObj = elasticNetLoss.calculate(nlLogisticSimplexResult.x())._1$mcD$sp();
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        NonlinearMinimizer nlProxSimplex = new NonlinearMinimizer(new ProjectProbabilitySimplex(1.0), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long nlProxLogisticSimplexStart = System.nanoTime();
        NonlinearMinimizer.State nlProxLogisticSimplexResult = nlProxSimplex.minimizeAndReturnState(elasticNetLoss, init);
        long nlProxLogisticSimplexTime = System.nanoTime() - nlProxLogisticSimplexStart;
        double nlProxLogisticSimplexObj = elasticNetLoss.calculate(nlProxLogisticSimplexResult.z())._1$mcD$sp();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Objective nl ", " admm ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)nlLogisticSimplexObj), BoxesRunTime.boxToDouble((double)nlProxLogisticSimplexObj)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Constraint nl ", " admm ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sum$.MODULE$.apply(nlLogisticSimplexResult.x(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())), sum$.MODULE$.apply(nlProxLogisticSimplexResult.z(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time nlProjection ", " ms nlProx ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlLogisticSimplexTime / 1000000.0)), BoxesRunTime.boxToDouble((double)((double)nlProxLogisticSimplexTime / 1000000.0))})));
        Predef$.MODULE$.println((Object)"Logistic Regression with ProximalL1 and ProjectL1");
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        long owlqnLogisticStart = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> owlqnLogisticResult = owlqn.minimizeAndReturnState(elasticNetLoss, init);
        long owlqnLogisticTime = System.nanoTime() - owlqnLogisticStart;
        double owlqnLogisticObj = elasticNetLoss.calculate(owlqnLogisticResult.x())._1$mcD$sp();
        double s = BoxesRunTime.unboxToDouble((Object)((Vector)owlqnLogisticResult.x()).foldLeft$mcD$sp(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double agg = sp2._1$mcD$sp();
            double entry = sp2._2$mcD$sp();
            double d = agg + package$.MODULE$.abs(entry);
            return d;
        }));
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        ProximalL1 proximalL1 = new ProximalL1(ProximalL1$.MODULE$.apply$default$1()).setLambda(lambdaL1);
        long nlLogisticProximalL1Start = System.nanoTime();
        NonlinearMinimizer.State nlLogisticProximalL1Result = new NonlinearMinimizer(proximalL1, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8()).minimizeAndReturnState(elasticNetLoss, init);
        long nlLogisticProximalL1Time = System.nanoTime() - nlLogisticProximalL1Start;
        init.$colon$eq(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
        long nlLogisticProjectL1Start = System.nanoTime();
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> nlLogisticProjectL1Result = this.apply(problemSize, Constraint$.MODULE$.SPARSE(), s, this.apply$default$4()).minimizeAndReturnState(elasticNetLoss, init);
        long nlLogisticProjectL1Time = System.nanoTime() - nlLogisticProjectL1Start;
        double proximalL1Obj = elasticNetLoss.calculate(nlLogisticProximalL1Result.z())._1$mcD$sp();
        double projectL1Obj = elasticNetLoss.calculate(nlLogisticProjectL1Result.x())._1$mcD$sp();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Objective proximalL1 ", " projectL1 ", " owlqn ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)proximalL1Obj), BoxesRunTime.boxToDouble((double)projectL1Obj), BoxesRunTime.boxToDouble((double)owlqnLogisticObj)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time proximalL1 ", " ms projectL1 ", " ms owlqn ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nlLogisticProximalL1Time / 1000000.0)), BoxesRunTime.boxToDouble((double)((double)nlLogisticProjectL1Time / 1000000.0)), BoxesRunTime.boxToDouble((double)((double)owlqnLogisticTime / 1000000.0))})));
    }

    public int $lessinit$greater$default$2() {
        return -1;
    }

    public int $lessinit$greater$default$3() {
        return 3;
    }

    public int $lessinit$greater$default$4() {
        return 7;
    }

    public double $lessinit$greater$default$5() {
        return 1.0;
    }

    public double $lessinit$greater$default$6() {
        return 1.0;
    }

    public double $lessinit$greater$default$7() {
        return 1.0E-6;
    }

    public double $lessinit$greater$default$8() {
        return 1.0E-4;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NonlinearMinimizer$() {
        MODULE$ = this;
    }
}

