package breeze.util

import scala.runtime.ScalaRunTime

/**
 * Mixin for case classes that compute their hashcode once, and then cache it.
 * Only good if the case class is immutable, and its contents are also immutable "all the way down".
 *
 * @author dlwh
 */
trait CachedHashCode {  self: Product =>
  override lazy val hashCode = ScalaRunTime._hashCode(this);
}
