/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.Args;
import org.scalatest.Args$;
import org.scalatest.DistributedSuiteSorter;
import org.scalatest.DistributedTestSorter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.Location;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStarting$;
import org.scalatest.events.Summary;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00014Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xmE\u0003\u0001\u000f=\u0019\u0012\u0004\u0005\u0002\t\u001b5\t\u0011B\u0003\u0002\u000b\u0017\u0005!A.\u00198h\u0015\u0005a\u0011\u0001\u00026bm\u0006L!AD\u0005\u0003\r=\u0013'.Z2u!\t\u0001\u0012#D\u0001\u0003\u0013\t\u0011\"A\u0001\u0005SKJ,hN\\3s!\t!r#D\u0001\u0016\u0015\t12\"\u0001\u0002j_&\u0011\u0001$\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003#\u00039\u0019X/\u001b;f\u00072\f7o\u001d(b[\u0016\u001c\u0001\u0001\u0005\u0002$M9\u0011!\u0004J\u0005\u0003Km\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\u0019\u0019FO]5oO*\u0011Qe\u0007\u0005\tU\u0001\u0011\t\u0011)A\u0005E\u0005AA/Z:u\u001d\u0006lW\rC\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004C\u0001\t\u0001\u0011\u0015\u00013\u00061\u0001#\u0011\u0015Q3\u00061\u0001#\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0015\t\u0007\u000f\u001d7z)!!t\u0007P!G\u001dZ[\u0006C\u0001\u000e6\u0013\t14D\u0001\u0003V]&$\b\"\u0002\u001d2\u0001\u0004I\u0014A\u0002:fa>\u0014H\u000f\u0005\u0002\u0011u%\u00111H\u0001\u0002\t%\u0016\u0004xN\u001d;fe\")Q(\ra\u0001}\u000591\u000f^8qa\u0016\u0014\bC\u0001\t@\u0013\t\u0001%AA\u0004Ti>\u0004\b/\u001a:\t\u000b\t\u000b\u0004\u0019A\"\u0002\r\u0019LG\u000e^3s!\t\u0001B)\u0003\u0002F\u0005\t1a)\u001b7uKJDQaR\u0019A\u0002!\u000b\u0011bY8oM&<W*\u00199\u0011\t\rJ%eS\u0005\u0003\u0015\"\u00121!T1q!\tQB*\u0003\u0002N7\t\u0019\u0011I\\=\t\u000b=\u000b\u0004\u0019\u0001)\u0002\u0017\u0011L7\u000f\u001e:jEV$xN\u001d\t\u00045E\u001b\u0016B\u0001*\u001c\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\u0003V\u0005\u0003+\n\u00111\u0002R5tiJL'-\u001e;pe\")q+\ra\u00011\u00069AO]1dW\u0016\u0014\bC\u0001\tZ\u0013\tQ&AA\u0004Ue\u0006\u001c7.\u001a:\t\u000bq\u000b\u0004\u0019A/\u0002\r1|\u0017\rZ3s!\tAa,\u0003\u0002`\u0013\tY1\t\\1tg2{\u0017\rZ3s\u0001")
public class TestRerunner
implements Rerunner,
Serializable,
ScalaObject {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(new RunStarting(tracker.nextOrdinal(), 1, configMap, (Option<Formatter>)RunStarting$.MODULE$.apply$default$4(), (Option<Location>)RunStarting$.MODULE$.apply$default$5(), (Option<Object>)RunStarting$.MODULE$.apply$default$6(), RunStarting$.MODULE$.apply$default$7(), RunStarting$.MODULE$.apply$default$8()));
            suite.run((Option<String>)new Some((Object)this.testName), new Args(report, stopper, filter2, configMap, distributor, tracker, (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.apply$default$8(), (Option<DistributedTestSorter>)Args$.MODULE$.apply$default$9(), (Option<DistributedSuiteSorter>)Args$.MODULE$.apply$default$10()));
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunCompleted(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunCompleted$.MODULE$.apply$default$3(), (Option<Formatter>)RunCompleted$.MODULE$.apply$default$4(), (Option<Location>)RunCompleted$.MODULE$.apply$default$5(), (Option<Object>)RunCompleted$.MODULE$.apply$default$6(), RunCompleted$.MODULE$.apply$default$7(), RunCompleted$.MODULE$.apply$default$8()));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Summary>)RunAborted$.MODULE$.apply$default$5(), (Option<Formatter>)RunAborted$.MODULE$.apply$default$6(), (Option<Location>)RunAborted$.MODULE$.apply$default$7(), (Option<Object>)RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

