/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Either;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class BitVector$
implements scala.Serializable {
    public static BitVector$ MODULE$;
    private final BitVector empty;
    private final BitVector zero;
    private final BitVector one;
    private final BitVector lowByte;
    private final BitVector highByte;

    static {
        new BitVector$();
    }

    public BitVector empty() {
        return this.empty;
    }

    public BitVector zero() {
        return this.zero;
    }

    public BitVector one() {
        return this.one;
    }

    public BitVector lowByte() {
        return this.lowByte;
    }

    public BitVector highByte() {
        return this.highByte;
    }

    public BitVector bit(boolean high) {
        return high ? this.one() : this.zero();
    }

    public BitVector bits(Iterable<Object> b2) {
        return (BitVector)b2.iterator().zipWithIndex().foldLeft((Object)this.low(b2.size()), (Function2 & Serializable & scala.Serializable)(acc, b) -> acc.update(b._2$mcI$sp(), b._1$mcZ$sp()));
    }

    public BitVector high(long n) {
        return this.fill(n, true);
    }

    public BitVector low(long n) {
        return this.fill(n, false);
    }

    public BitVector apply(ByteVector bs) {
        return this.toBytes(bs, bs.size() * 8L);
    }

    public BitVector apply(ByteBuffer buffer) {
        return this.apply(ByteVector$.MODULE$.apply(buffer));
    }

    public BitVector apply(byte[] bs) {
        return this.toBytes(ByteVector$.MODULE$.apply(bs), (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bs)).size() * 8L);
    }

    public BitVector apply(GenTraversableOnce<Object> bs) {
        return this.apply(ByteVector$.MODULE$.apply(bs));
    }

    public <A> BitVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        return this.apply(ByteVector$.MODULE$.apply(bytes, evidence$1));
    }

    public BitVector view(ByteBuffer buffer) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), (long)buffer.limit() * 8L);
    }

    public BitVector view(ByteBuffer buffer, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), sizeInBits);
    }

    public BitVector view(byte[] bs) {
        return this.view(bs, (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bs)).size() * 8L);
    }

    public BitVector view(byte[] bs, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(bs), sizeInBits);
    }

    public BitVector fill(long n, boolean high) {
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(n);
        ByteVector bs = ByteVector$.MODULE$.fill(needed, high ? BoxesRunTime.boxToInteger((int)-1) : BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$);
        return this.toBytes(bs, n);
    }

    public BitVector fromByte(byte b, int size) {
        Predef$.MODULE$.require(size <= 8);
        return ((BitVector)this.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{b}), (Integral)Numeric.ByteIsIntegral$.MODULE$).$less$less(BoxesRunTime.boxToLong((long)(8L - (long)size)))).take(size);
    }

    public int fromByte$default$2() {
        return 8;
    }

    public BitVector fromShort(short s, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 16);
        ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(16L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromShort$default$2() {
        return 16;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromInt(int i, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 32);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(32L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromInt$default$2() {
        return 32;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromLong(long l, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 64);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(64L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromLong$default$2() {
        return 64;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final BitVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, BitVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        return ByteVector$.MODULE$.fromBinInternal(str, alphabet).right().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int n;
            ByteVector bytes;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int size;
                bytes = (ByteVector)tuple2._1();
                int n2 = size = tuple2._2$mcI$sp();
                switch (n2) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    default: {
                        if (n2 % 8 == 0) {
                            n = 0;
                            break;
                        }
                        n = 8 - n2 % 8;
                        break;
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            int toDrop = n;
            BitVector bitVector = bytes.toBitVector().drop(toDrop);
            return bitVector;
        });
    }

    public Option<BitVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).right().toOption();
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public BitVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (BitVector)this.fromBinDescriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, BitVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        return ByteVector$.MODULE$.fromHexInternal(str, alphabet).right().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteVector bytes = (ByteVector)tuple2._1();
            int count = tuple2._2$mcI$sp();
            int toDrop = count % 2 == 0 ? 0 : 4;
            BitVector bitVector = bytes.toBitVector().drop(toDrop);
            return bitVector;
        });
    }

    public Option<BitVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).right().toOption();
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public BitVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (BitVector)this.fromHexDescriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, BitVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase64Descriptive(str, alphabet).right().map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.toBitVector());
    }

    public Option<BitVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).right().toOption();
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public BitVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (BitVector)this.fromBase64Descriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, BitVector> encodeString(String str, Charset charset) {
        return ByteVector$.MODULE$.encodeString(str, charset).right().map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.bits());
    }

    public Either<CharacterCodingException, BitVector> encodeUtf8(String str) {
        return ByteVector$.MODULE$.encodeUtf8(str).right().map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.bits());
    }

    public Either<CharacterCodingException, BitVector> encodeAscii(String str) {
        return ByteVector$.MODULE$.encodeAscii(str).right().map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.bits());
    }

    public BitVector concat(GenTraversableOnce<BitVector> bvs) {
        return (BitVector)bvs.foldLeft((Object)this.empty(), (Function2 & Serializable & scala.Serializable)(x$34, x$35) -> x$34.$plus$plus((BitVector)x$35));
    }

    public <S> BitVector unfold(S s, Function1<S, Option<Tuple2<BitVector, S>>> f) {
        return new BitVector.Suspend((Function0<BitVector>)(Function0 & Serializable & scala.Serializable)() -> (BitVector)((Option)f.apply(s)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector h = (BitVector)tuple2._1();
            Object t = tuple2._2();
            BitVector.Append append = new BitVector.Append(h, this.unfold(t, f));
            return append;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.empty()));
    }

    public BitVector fromInputStream(InputStream in2, int chunkSizeInBytes) {
        return this.unfold(in2, (Function1 & Serializable & scala.Serializable)in -> {
            byte[] buf = new byte[chunkSizeInBytes];
            int nRead = in.read(buf);
            return nRead == chunkSizeInBytes ? new Some((Object)new Tuple2((Object)MODULE$.apply(buf), in)) : (nRead == -1 ? None$.MODULE$ : new Some((Object)new Tuple2((Object)MODULE$.apply((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buf)).take(nRead)), in)));
        });
    }

    public int fromInputStream$default$2() {
        return 0xFA0000;
    }

    public BitVector fromChannel(ReadableByteChannel in2, int chunkSizeInBytes, boolean direct) {
        return this.unfold(in2, (Function1 & Serializable & scala.Serializable)in -> {
            ByteBuffer buf = direct ? ByteBuffer.allocateDirect(chunkSizeInBytes) : ByteBuffer.allocate(chunkSizeInBytes);
            int nRead = in.read(buf);
            buf.flip();
            return nRead != -1 ? new Some((Object)new Tuple2((Object)MODULE$.view(buf, (long)nRead * 8L), in)) : None$.MODULE$;
        });
    }

    public int fromChannel$default$2() {
        return 0xFA0000;
    }

    public boolean fromChannel$default$3() {
        return false;
    }

    public BitVector fromMmap(FileChannel in, int chunkSizeInBytes) {
        return this.unfold(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)in), (Object)BoxesRunTime.boxToLong((long)0L)), (Function1 & Serializable & scala.Serializable)x0$4 -> {
            None$ none$;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                FileChannel in = (FileChannel)tuple2._1();
                long pos = tuple2._2$mcJ$sp();
                if (pos == in.size()) {
                    none$ = None$.MODULE$;
                } else {
                    Predef$.MODULE$.require(pos < in.size());
                    long bytesToRead = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(in.size() - pos), (long)chunkSizeInBytes);
                    MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, pos, bytesToRead);
                    Predef$.MODULE$.require((long)buf.limit() == bytesToRead);
                    none$ = new Some((Object)new Tuple2((Object)MODULE$.view(buf), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)in), (Object)BoxesRunTime.boxToLong((long)(pos + bytesToRead)))));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            None$ none$2 = none$;
            return none$2;
        });
    }

    public int fromMmap$default$2() {
        return 0xFA0000;
    }

    public BitVector.Bytes toBytes(ByteVector bs, long sizeInBits) {
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(sizeInBits);
        Predef$.MODULE$.require(needed <= bs.size());
        ByteVector b = bs.size() > needed ? bs.take(needed) : bs;
        return new BitVector.Bytes(b, sizeInBits);
    }

    public BitVector concat(Vector<BitVector> vs) {
        return (BitVector)vs.foldLeft((Object)this.empty(), (Function2 & Serializable & scala.Serializable)(x$42, x$43) -> x$42.$plus$plus((BitVector)x$43));
    }

    public boolean scodec$bits$BitVector$$getBit(byte by, int n) {
        return (128 >> n & by) != 0;
    }

    public byte scodec$bits$BitVector$$setBit(byte by, int n, boolean high) {
        return (byte)(high ? 128 >> n | by : ~(128 >> n) & by);
    }

    /*
     * WARNING - void declaration
     */
    public long scodec$bits$BitVector$$validBitsInLastByte(long size) {
        void var3_2;
        long mod = size % 8L;
        return mod == 0L ? 8L : var3_2;
    }

    public byte scodec$bits$BitVector$$topNBits(int n) {
        return (byte)(-1 << 8 - n);
    }

    public long scodec$bits$BitVector$$bytesNeededForBits(long size) {
        return (size + 7L) / 8L;
    }

    public byte reverseBitsInByte(byte b) {
        int x = (b & 0x55) << 1 | (b & 0xAA) >> 1;
        x = (x & 0x33) << 2 | (x & 0xCC) >> 2;
        x = (x & 0xF) << 4 | (x & 0xF0) >> 4;
        return (byte)x;
    }

    public ByteVector scodec$bits$BitVector$$clearUnneededBits(long size, ByteVector bytes) {
        ByteVector byteVector;
        int valid = (int)this.scodec$bits$BitVector$$validBitsInLastByte(size);
        if (bytes.nonEmpty() && valid < 8) {
            long idx = bytes.size() - 1L;
            byte last = bytes.apply(idx);
            byteVector = bytes.update(idx, (byte)(last & this.scodec$bits$BitVector$$topNBits(valid)));
        } else {
            byteVector = bytes;
        }
        return byteVector;
    }

    public <A> A reduceBalanced(TraversableOnce<A> v, Function1<A, Object> size, Function2<A, A, A> f) {
        return (A)((LinearSeqOptimized)((List)v.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(stack, a) -> {
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), size.apply(a));
            return this.fixup$1(stack.$colon$colon((Object)tuple2), f);
        })).reverse().map((Function1 & Serializable & scala.Serializable)x$46 -> x$46._1(), List$.MODULE$.canBuildFrom())).reduceLeft(f);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final List fixup$1(List stack, Function2 f$2) {
        List list;
        while ((list = stack) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.tl$access$1();
            if (tuple2 == null) break;
            Object h2 = tuple2._1();
            long n = tuple2._2$mcJ$sp();
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon3 = (.colon.colon)list2;
            Tuple2 tuple22 = (Tuple2)colon3.head();
            List t = colon3.tl$access$1();
            if (tuple22 == null) break;
            Object h = tuple22._1();
            long m = tuple22._2$mcJ$sp();
            if (n <= m / 2L) break;
            Tuple2 tuple23 = new Tuple2(f$2.apply(h, h2), (Object)BoxesRunTime.boxToLong((long)(m + n)));
            stack = t.$colon$colon((Object)tuple23);
        }
        List list3 = stack;
        return list3;
    }

    private BitVector$() {
        MODULE$ = this;
        this.empty = this.toBytes(ByteVector$.MODULE$.empty(), 0L);
        this.zero = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.one = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{255}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.lowByte = this.toBytes(ByteVector$.MODULE$.fill(8L, BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), 8L);
        this.highByte = this.toBytes(ByteVector$.MODULE$.fill(8L, BoxesRunTime.boxToInteger((int)1), Numeric.IntIsIntegral$.MODULE$), 8L);
    }
}

