/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.UUID;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right$;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$AtEmpty$;

public final class ByteVector$
implements scala.Serializable {
    public static ByteVector$ MODULE$;
    private final ByteVector empty;

    static {
        new ByteVector$();
    }

    public ByteVector empty() {
        return this.empty;
    }

    public <A> ByteVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$1);
        byte[] buf = new byte[bytes.size()];
        IntRef i = IntRef.create((int)0);
        bytes.foreach((Function1 & Serializable & scala.Serializable)b -> {
            ByteVector$.$anonfun$apply$1(integral, buf, i, b);
            return BoxedUnit.UNIT;
        });
        return this.view(buf);
    }

    public ByteVector apply(Vector<Object> bytes) {
        return this.viewAt((Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)idx -> BoxesRunTime.boxToByte((byte)ByteVector$.$anonfun$apply$2(bytes, BoxesRunTime.unboxToLong((Object)idx))), bytes.size());
    }

    public ByteVector apply(byte[] bytes) {
        byte[] copy = (byte[])bytes.clone();
        return this.view(copy);
    }

    public ByteVector apply(byte[] bytes, int offset, int length) {
        byte[] fresh = new byte[length];
        System.arraycopy(bytes, offset, fresh, 0, length);
        return this.view(fresh);
    }

    public ByteVector apply(ByteBuffer buffer) {
        ByteBuffer c = buffer.duplicate();
        byte[] arr = (byte[])Array$.MODULE$.ofDim(c.remaining(), ClassTag$.MODULE$.Byte());
        c.get(arr);
        return this.view(arr);
    }

    public ByteVector apply(GenTraversableOnce<Object> bs) {
        return this.view((byte[])bs.toArray(ClassTag$.MODULE$.Byte()));
    }

    public ByteVector view(byte[] bytes) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtArray(bytes), 0L, bytes.length));
    }

    public ByteVector view(byte[] bytes, int offset, int size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtArray(bytes), offset, size));
    }

    public ByteVector view(ByteBuffer bytes) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.AtByteBuffer(bytes.slice()), 0L, bytes.limit()));
    }

    public ByteVector viewAt(Function1<Object, Object> at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(at){
            private final Function1 at$1;

            public byte apply(long i) {
                return BoxesRunTime.unboxToByte((Object)this.at$1.apply((Object)BoxesRunTime.boxToLong((long)i)));
            }
            {
                this.at$1 = at$1;
            }
        }, 0L, size));
    }

    public ByteVector view(ByteVector.At at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(at, 0L, size));
    }

    public ByteVector viewI(Function1<Object, Object> at, long size) {
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(at){
            private final Function1 at$2;

            public byte apply(long i) {
                return (byte)this.at$2.apply$mcIJ$sp(i);
            }
            {
                this.at$2 = at$2;
            }
        }, 0L, size));
    }

    public <A> ByteVector fill(long size, A b, Integral<A> evidence$2) {
        Integral integral = (Integral)Predef$.MODULE$.implicitly(evidence$2);
        byte value = (byte)integral.toInt(b);
        return new ByteVector.Chunk(new ByteVector.View(new ByteVector.At(value){
            private final byte value$1;

            public byte apply(long i) {
                return this.value$1;
            }
            {
                this.value$1 = value$1;
            }
        }, 0L, size));
    }

    public ByteVector low(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)0), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector high(long size) {
        return this.fill(size, (Object)BoxesRunTime.boxToInteger((int)255), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public ByteVector fromByte(byte b) {
        return BitVector$.MODULE$.fromByte(b, 8).bytes();
    }

    public ByteVector fromShort(short s, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromShort(s, size * 8, ordering).bytes();
    }

    public int fromShort$default$2() {
        return 2;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromInt(int i, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromInt(i, size * 8, ordering).bytes();
    }

    public int fromInt$default$2() {
        return 4;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public ByteVector fromLong(long l, int size, ByteOrdering ordering) {
        return BitVector$.MODULE$.fromLong(l, size * 8, ordering).bytes();
    }

    public int fromLong$default$2() {
        return 8;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final ByteVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, ByteVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexInternal(str, alphabet).right().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            ByteVector res;
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteVector byteVector = res = (ByteVector)tuple2._1();
            return byteVector;
        });
    }

    public Either<String, Tuple2<ByteVector, Object>> fromHexInternal(String str, Bases.HexAlphabet alphabet) {
        Left left;
        boolean prefixed = str.startsWith("0x") || str.startsWith("0X");
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int hi = 0;
        int count = 0;
        boolean midByte = false;
        String err = null;
        ByteBuffer bldr = ByteBuffer.allocate((new StringOps(Predef$.MODULE$.augmentString(str)).size() + 1) / 2);
        for (int idx = 0; idx < withoutPrefix.length() && err == null; ++idx) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(withoutPrefix), idx);
            if (alphabet.ignore(c)) continue;
            try {
                int nibble = alphabet.toIndex(c);
                if (midByte) {
                    bldr.put((byte)(hi | nibble));
                    midByte = false;
                } else {
                    hi = (byte)(nibble << 4);
                    midByte = true;
                }
                ++count;
                continue;
            }
            catch (IllegalArgumentException e) {
                err = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid hexadecimal character '", "' at index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), BoxesRunTime.boxToInteger((int)(idx + (prefixed ? 2 : 0)))}));
            }
        }
        if (err == null) {
            ByteVector byteVector;
            Right$ right$ = package$.MODULE$.Right();
            if (midByte) {
                bldr.put((byte)hi);
                bldr.flip();
                byteVector = this.apply(bldr).shiftRight(4L, false);
            } else {
                bldr.flip();
                byteVector = this.apply(bldr);
            }
            left = right$.apply((Object)new Tuple2((Object)byteVector, (Object)BoxesRunTime.boxToInteger((int)count)));
        } else {
            left = package$.MODULE$.Left().apply(err);
        }
        return left;
    }

    public Option<ByteVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).right().toOption();
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public ByteVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (ByteVector)this.fromHexDescriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, ByteVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinInternal(str, alphabet).right().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            ByteVector res;
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteVector byteVector = res = (ByteVector)tuple2._1();
            return byteVector;
        });
    }

    public Either<String, Tuple2<ByteVector, Object>> fromBinInternal(String str, Bases.BinaryAlphabet alphabet) {
        Left left;
        boolean prefixed = str.startsWith("0b") || str.startsWith("0B");
        String withoutPrefix = prefixed ? str.substring(2) : str;
        int n = 0;
        int bits = 0;
        int count = 0;
        String err = null;
        ByteBuffer bldr = ByteBuffer.allocate((new StringOps(Predef$.MODULE$.augmentString(str)).size() + 7) / 8);
        for (int idx = 0; idx < withoutPrefix.length() && err == null; ++idx) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(withoutPrefix), idx);
            if (!alphabet.ignore(c)) {
                try {
                    n = n << 1 | 1 & alphabet.toIndex(c);
                    ++bits;
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    err = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid binary character '", "' at index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), BoxesRunTime.boxToInteger((int)(idx + (prefixed ? 2 : 0)))}));
                }
            }
            if (bits != 8) continue;
            bldr.put((byte)n);
            n = 0;
            bits = 0;
        }
        if (err == null) {
            ByteVector byteVector;
            Right$ right$ = package$.MODULE$.Right();
            if (bits > 0) {
                bldr.put((byte)(n << 8 - bits));
                bldr.flip();
                byteVector = this.apply(bldr).shiftRight(8 - bits, false);
            } else {
                bldr.flip();
                byteVector = this.apply(bldr);
            }
            left = right$.apply((Object)new Tuple2((Object)byteVector, (Object)BoxesRunTime.boxToInteger((int)count)));
        } else {
            left = package$.MODULE$.Left().apply(err);
        }
        return left;
    }

    public Option<ByteVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).right().toOption();
    }

    public Bases.BinaryAlphabet fromBinInternal$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public ByteVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (ByteVector)this.fromBinDescriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, ByteVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        char Pad = alphabet.pad();
        int bidx = 0;
        int buffer = 0;
        int mod = 0;
        int padding = 0;
        byte[] acc = (byte[])Array$.MODULE$.ofDim(new StringOps(Predef$.MODULE$.augmentString(str)).size() / 4 * 3, ClassTag$.MODULE$.Byte());
        block10: for (int idx = 0; idx < str.length(); ++idx) {
            int n;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx);
            switch (c) {
                default: 
            }
            if (alphabet.ignore(c)) continue;
            if (padding == 0) {
                try {
                    if (c == Pad) {
                        ++padding;
                        n = 0;
                    }
                    n = alphabet.toIndex(c);
                }
                catch (IllegalArgumentException e) {
                    return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid base 64 character '", "' at index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), BoxesRunTime.boxToInteger((int)idx)})));
                }
            } else if (c == Pad) {
                ++padding;
                n = 0;
            } else {
                return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected character '", "' at index ", " after padding character; only '=' and whitespace characters allowed after first padding character"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), BoxesRunTime.boxToInteger((int)idx)})));
            }
            int cidx = n;
            int n2 = mod++;
            switch (n2) {
                case 0: {
                    buffer = cidx & 0x3F;
                    continue block10;
                }
                case 1: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block10;
                }
                case 2: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    ++mod;
                    continue block10;
                }
                case 3: {
                    buffer = buffer << 6 | cidx & 0x3F;
                    mod = 0;
                    int c2 = buffer & 0xFF;
                    int b = buffer >> 8 & 0xFF;
                    int a = buffer >> 16 & 0xFF;
                    acc[bidx] = (byte)a;
                    acc[bidx + 1] = (byte)b;
                    acc[bidx + 2] = (byte)c2;
                    bidx += 3;
                    continue block10;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
            }
        }
        return package$.MODULE$.Right().apply((Object)this.apply(acc).take(bidx - padding));
    }

    public Option<ByteVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).right().toOption();
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public ByteVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (ByteVector)this.fromBase64Descriptive(str, alphabet).fold((Function1 & Serializable & scala.Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable & scala.Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, ByteVector> encodeString(String str, Charset charset) {
        Left left;
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer buffer = CharBuffer.wrap(str);
        try {
            left = package$.MODULE$.Right().apply((Object)this.apply(encoder.encode(buffer)));
        }
        catch (CharacterCodingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Either<CharacterCodingException, ByteVector> encodeUtf8(String str) {
        return this.encodeString(str, Charset.forName("UTF-8"));
    }

    public Either<CharacterCodingException, ByteVector> encodeAscii(String str) {
        return this.encodeString(str, Charset.forName("US-ASCII"));
    }

    public ByteVector concat(GenTraversableOnce<ByteVector> bvs) {
        return ((ByteVector)bvs.foldLeft((Object)this.empty(), (Function2 & Serializable & scala.Serializable)(x$28, x$29) -> x$28.$plus$plus((ByteVector)x$29))).unbuffer();
    }

    public int scodec$bits$ByteVector$$toIntSize(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size must be <= Int.MaxValue but is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)size)})));
        }
        return (int)size;
    }

    public Some<Seq<Object>> unapplySeq(ByteVector b) {
        return new Some(b.toIndexedSeq());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$apply$1(Integral integral$1, byte[] buf$1, IntRef i$3, Object b) {
        buf$1[i$3.elem] = (byte)integral$1.toInt(b);
        ++i$3.elem;
    }

    public static final /* synthetic */ byte $anonfun$apply$2(Vector bytes$1, long idx) {
        return BoxesRunTime.unboxToByte((Object)bytes$1.apply((int)idx));
    }

    private ByteVector$() {
        MODULE$ = this;
        this.empty = new ByteVector.Chunk(new ByteVector.View(ByteVector$AtEmpty$.MODULE$, 0L, 0L));
    }
}

