/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scoverage.Constants$;
import scoverage.IOUtils$;

public final class IOUtils$ {
    public static final IOUtils$ MODULE$;
    private final char UnixSeperator;
    private final char WindowsSeperator;
    private final String UTF8Encoding;
    private final Function1<File, Object> isMeasurementFile;
    private final Function1<File, Object> isReportFile;
    private final Function1<File, Object> isDebugReportFile;

    static {
        new IOUtils$();
    }

    public File getTempDirectory() {
        return new File(this.getTempPath());
    }

    public String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public String readStreamAsString(InputStream in) {
        return Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private char UnixSeperator() {
        return this.UnixSeperator;
    }

    private char WindowsSeperator() {
        return this.WindowsSeperator;
    }

    private String UTF8Encoding() {
        return this.UTF8Encoding;
    }

    public Object getName(String path) {
        int lastUnixPos = path.lastIndexOf(this.UnixSeperator());
        int lastWindowsPos = path.lastIndexOf(this.WindowsSeperator());
        int index = Math.max(lastUnixPos, lastWindowsPos);
        return new StringOps(Predef$.MODULE$.augmentString(path)).drop(index + 1);
    }

    public File reportFile(File outputDir, boolean debug) {
        boolean bl;
        block4: {
            File file;
            block3: {
                block2: {
                    bl = debug;
                    if (!bl) break block2;
                    file = new File(outputDir, Constants$.MODULE$.XMLReportFilenameWithDebug());
                    break block3;
                }
                if (bl) break block4;
                file = new File(outputDir, Constants$.MODULE$.XMLReportFilename());
            }
            return file;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean reportFile$default$2() {
        return false;
    }

    public void clean(File dataDir) {
        Predef$.MODULE$.refArrayOps((Object[])this.findMeasurementFiles(dataDir)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.delete();
            }
        });
    }

    public void clean(String dataDir) {
        this.clean(new File(dataDir));
    }

    /*
     * WARNING - void declaration
     */
    public void writeToFile(File file, String str) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.UTF8Encoding()));
        try {
            writer.write(str);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        writer.close();
    }

    public File measurementFile(File dataDir) {
        return this.measurementFile(dataDir.getAbsolutePath());
    }

    public File measurementFile(String dataDir) {
        return new File(dataDir, new StringBuilder().append((Object)Constants$.MODULE$.MeasurementsPrefix()).append((Object)BoxesRunTime.boxToLong((long)Thread.currentThread().getId())).toString());
    }

    public File[] findMeasurementFiles(String dataDir) {
        return this.findMeasurementFiles(new File(dataDir));
    }

    public File[] findMeasurementFiles(File dataDir) {
        return dataDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
            }
        });
    }

    public Seq<File> reportFileSearch(File baseDir, Function1<File, Object> condition) {
        return this.scoverage$IOUtils$$search$1(baseDir);
    }

    public Function1<File, Object> isMeasurementFile() {
        return this.isMeasurementFile;
    }

    public Function1<File, Object> isReportFile() {
        return this.isReportFile;
    }

    public Function1<File, Object> isDebugReportFile() {
        return this.isDebugReportFile;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Object> invoked(Seq<File> files2) {
        void var2_2;
        scala.collection.mutable.Set acc = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        files2.foreach((Function1)new Serializable(acc){
            public static final long serialVersionUID = 0L;
            public final scala.collection.mutable.Set acc$1;

            public final void apply(File file) {
                BufferedSource reader = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                reader.getLines().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.invoked.1 $outer;

                    public final Object apply(String line) {
                        return line.isEmpty() ? BoxedUnit.UNIT : this.$outer.acc$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(line)).toInt()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                reader.close();
            }
            {
                this.acc$1 = acc$1;
            }
        });
        return var2_2;
    }

    public final Seq scoverage$IOUtils$$search$1(File file) {
        File file2 = file;
        Object object = file2.isDirectory() ? (Seq)((GenericTraversableTemplate)Predef$.MODULE$.refArrayOps((Object[])file2.listFiles()).toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File file) {
                return IOUtils$.MODULE$.scoverage$IOUtils$$search$1(file);
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms()) : (BoxesRunTime.unboxToBoolean((Object)this.isReportFile().apply((Object)file2)) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file2})) : Nil$.MODULE$);
        return object;
    }

    private IOUtils$() {
        MODULE$ = this;
        this.UnixSeperator = (char)47;
        this.WindowsSeperator = (char)92;
        this.UTF8Encoding = "UTF-8";
        this.isMeasurementFile = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
            }
        };
        this.isReportFile = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                String string = file.getName();
                String string2 = Constants$.MODULE$.XMLReportFilename();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        };
        this.isDebugReportFile = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                String string = file.getName();
                String string2 = Constants$.MODULE$.XMLReportFilenameWithDebug();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        };
    }
}

