/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class SCoverageForkedLifecycleConfigurator {
    private static final String PROP_ORIG_OUTPUT_DIRECTORY = "_scoverage.original.outputDirectory";
    private static final String PROP_ORIG_ARTIFACT_FILE = "_scoverage.original.artifactFile";
    private static final String PROP_FORKED_OUTPUT_DIRECTORY = "_scoverage.forked.outputDirectory";
    private static final String PROP_FORKED_ARTIFACT_FILE = "_scoverage.forked.artifactFile";

    public static void afterForkedLifecycleEnter(MavenProject project, List<MavenProject> reactorProjects, Map<String, String> additionalProjectPropertiesMap) {
        File classesDirectory = new File(project.getBuild().getOutputDirectory());
        File scoverageClassesDirectory = new File(classesDirectory.getParentFile(), "scoverage-" + classesDirectory.getName());
        project.getArtifact().setFile(null);
        project.getBuild().setOutputDirectory(scoverageClassesDirectory.getAbsolutePath());
        if (additionalProjectPropertiesMap != null) {
            for (Map.Entry entry : additionalProjectPropertiesMap.entrySet()) {
                project.getProperties().put(entry.getKey(), entry.getValue());
            }
        }
        for (MavenProject mavenProject : reactorProjects) {
            if (mavenProject == project) continue;
            if (mavenProject.getProperties().containsKey(PROP_FORKED_OUTPUT_DIRECTORY)) {
                String forkedOutputDirectory = (String)mavenProject.getProperties().remove(PROP_FORKED_OUTPUT_DIRECTORY);
                mavenProject.getProperties().put(PROP_ORIG_OUTPUT_DIRECTORY, mavenProject.getBuild().getOutputDirectory());
                mavenProject.getBuild().setOutputDirectory(forkedOutputDirectory);
            }
            if (!mavenProject.getProperties().containsKey(PROP_FORKED_ARTIFACT_FILE)) continue;
            String forkedArtifactFilePath = (String)mavenProject.getProperties().remove(PROP_FORKED_ARTIFACT_FILE);
            File originalArtifactFile = mavenProject.getArtifact().getFile();
            mavenProject.getProperties().put(PROP_ORIG_ARTIFACT_FILE, originalArtifactFile == null ? "" : originalArtifactFile.getAbsolutePath());
            mavenProject.getArtifact().setFile("".equals(forkedArtifactFilePath) ? null : new File(forkedArtifactFilePath));
        }
    }

    public static void afterForkedLifecycleExit(MavenProject project, List<MavenProject> reactorProjects) {
        String forkedOutputDirectory = project.getExecutionProject().getBuild().getOutputDirectory();
        project.getProperties().put(PROP_FORKED_OUTPUT_DIRECTORY, forkedOutputDirectory);
        File forkedArtifactFile = project.getExecutionProject().getArtifact().getFile();
        project.getProperties().put(PROP_FORKED_ARTIFACT_FILE, forkedArtifactFile != null ? forkedArtifactFile.getAbsolutePath() : "");
        for (MavenProject reactorProject : reactorProjects) {
            if (reactorProject == project) continue;
            if (reactorProject.getProperties().containsKey(PROP_ORIG_OUTPUT_DIRECTORY)) {
                String originalOutputDirectory = (String)reactorProject.getProperties().remove(PROP_ORIG_OUTPUT_DIRECTORY);
                forkedOutputDirectory = reactorProject.getBuild().getOutputDirectory();
                reactorProject.getProperties().put(PROP_FORKED_OUTPUT_DIRECTORY, forkedOutputDirectory);
                reactorProject.getBuild().setOutputDirectory(originalOutputDirectory);
            }
            if (!reactorProject.getProperties().containsKey(PROP_ORIG_ARTIFACT_FILE)) continue;
            String originalArtifactFilePath = (String)reactorProject.getProperties().remove(PROP_ORIG_ARTIFACT_FILE);
            forkedArtifactFile = reactorProject.getArtifact().getFile();
            reactorProject.getProperties().put(PROP_FORKED_ARTIFACT_FILE, forkedArtifactFile == null ? "" : forkedArtifactFile.getAbsolutePath());
            reactorProject.getArtifact().setFile("".equals(originalArtifactFilePath) ? null : new File(originalArtifactFilePath));
        }
    }
}

