/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.conforms;

import java.io.File;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.FileContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolTools;
import org.scribble.protocol.ProtocolTools;
import org.scribble.protocol.conformance.ConformanceHandler;
import org.scribble.protocol.conformance.LoggingConformanceHandler;
import org.scribble.protocol.conformance.ProtocolConformer;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;

public class ConformsCommand
implements Command {
    private Journal _journal = null;
    private ProtocolParserManager _protocolParserManager = null;
    private ProtocolConformer _conformer = null;

    public void setJournal(Journal journal) {
        this._journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this._protocolParserManager = parser;
    }

    public void setConformer(ProtocolConformer conformer) {
        this._conformer = conformer;
    }

    public String getName() {
        return "conforms";
    }

    public String getDescription() {
        return "Check two Scribble descriptions for conformance";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 2) {
            File f1 = new File(args[0]);
            File f2 = new File(args[1]);
            if (!f1.exists()) {
                this._journal.error("File not found '" + args[0] + "'", null);
            } else if (!f2.exists()) {
                this._journal.error("File not found '" + args[1] + "'", null);
            } else {
                try {
                    FileContent content1 = new FileContent(f1);
                    ProtocolModel p1 = this._protocolParserManager.parse((ProtocolTools)new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f1.getParentFile())), (Content)content1, this._journal);
                    FileContent content2 = new FileContent(f2);
                    ProtocolModel p2 = this._protocolParserManager.parse((ProtocolTools)new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f2.getParentFile())), (Content)content2, this._journal);
                    if (p1 != null && p2 != null) {
                        this._conformer.conforms(p1, p2, (ConformanceHandler)new LoggingConformanceHandler(this._journal));
                        ret = true;
                    }
                }
                catch (Exception e) {
                    this._journal.error("Failed to check conformance of '" + args[0] + "' against '" + args[1] + "': " + e, null);
                    e.printStackTrace();
                }
            }
        } else {
            this._journal.error("CONFORMS EXPECTING 2 PARAMETERS", null);
        }
        return ret;
    }
}

