/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.simulate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.command.Command;
import org.scribble.command.simulate.Event;
import org.scribble.command.simulate.EventProcessor;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.FileContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolTools;
import org.scribble.protocol.ProtocolTools;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.monitor.DefaultMonitorContext;
import org.scribble.protocol.monitor.DefaultSession;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.util.MonitorModelUtil;
import org.scribble.protocol.parser.ProtocolParserManager;

public class SimulateCommand
implements Command {
    private ProtocolMonitor _protocolMonitor = null;
    private ProtocolExportManager _protocolExportManager = null;
    private Journal _journal = null;
    private ProtocolParserManager _protocolParserManager = null;
    private static final Logger LOG = Logger.getLogger(SimulateCommand.class.getName());

    public void setProtocolMonitor(ProtocolMonitor pm) {
        this._protocolMonitor = pm;
    }

    public void setJournal(Journal journal) {
        this._journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this._protocolParserManager = parser;
    }

    public void setProtocolExportManager(ProtocolExportManager exportManager) {
        this._protocolExportManager = exportManager;
    }

    public String getName() {
        return "simulate";
    }

    public String getDescription() {
        return "Simulate a Scribble endpoint description against a list of events";
    }

    public boolean execute(String[] args) {
        boolean ret;
        block11: {
            ret = false;
            if (args.length == 2) {
                this._journal.info("SIMULATE " + args[0] + " " + args[1], null);
                File f1 = new File(args[0]);
                File f2 = new File(args[1]);
                if (!f1.exists()) {
                    this._journal.error("File not found '" + args[0] + "'", null);
                } else if (!f2.exists()) {
                    this._journal.error("File not found '" + args[1] + "'", null);
                } else {
                    try {
                        FileContent content = new FileContent(f1);
                        ProtocolModel model = this._protocolParserManager.parse((ProtocolTools)new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f1.getParentFile())), (Content)content, this._journal);
                        if (model != null) {
                            if (model.getProtocol().getLocatedRole() != null) {
                                this.simulate(model, f2);
                                ret = true;
                            } else {
                                this._journal.error("Protocol is not located at a role - only located protocols can be simulated", null);
                            }
                            break block11;
                        }
                        this._journal.error("Protocol model not retrieved", null);
                    }
                    catch (Exception e) {
                        this._journal.error("Failed to simulate file '" + args[0] + "'", null);
                        e.printStackTrace();
                    }
                }
            } else {
                System.err.println("Simulation expects 2 parameters");
            }
        }
        return ret;
    }

    public void simulate(ProtocolModel model, File eventFile) {
        ProtocolExporter exporter = this._protocolExportManager.getExporter("monitor");
        if (exporter != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                exporter.export(model, this._journal, (OutputStream)os);
                ByteArrayInputStream prtis = new ByteArrayInputStream(os.toByteArray());
                Description protocol = MonitorModelUtil.deserialize((InputStream)prtis);
                ((InputStream)prtis).close();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Protocol = " + protocol);
                }
                DefaultMonitorContext context = new DefaultMonitorContext();
                Session conv = this._protocolMonitor.createSession((MonitorContext)context, protocol, DefaultSession.class);
                FileInputStream is = new FileInputStream(eventFile);
                EventProcessor eventProcessor = new EventProcessor();
                eventProcessor.initialize(is);
                ((InputStream)is).close();
                for (Event event : eventProcessor.getEvents()) {
                    if (event.validate(this._protocolMonitor, (MonitorContext)context, protocol, conv).isValid()) {
                        this._journal.info("Validated " + event, null);
                        continue;
                    }
                    this._journal.error(event.toString(), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this._journal.error("Failed to simulate process model: " + e, null);
            }
        } else {
            this._journal.error("Failed to export protocol model to monitoring representation", null);
        }
    }
}

