/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.conformance.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Unordered;
import org.scribble.protocol.model.Visitor;

public final class ProtocolNormalizer {
    private static final Logger LOG = Logger.getLogger(ProtocolNormalizer.class.getName());

    private ProtocolNormalizer() {
    }

    public static ProtocolModel normalize(ProtocolModel pm) {
        pm.visit((Visitor)new NormalizingVisitor());
        return pm;
    }

    private static class NormalizingVisitor
    extends DefaultVisitor {
        private NormalizingVisitor() {
        }

        public boolean start(Choice elem) {
            Collections.sort(elem.getPaths(), new Comparator<Block>(){

                @Override
                public int compare(Block arg0, Block arg1) {
                    return arg0.toString().compareTo(arg1.toString());
                }
            });
            return true;
        }

        public boolean start(DirectedChoice elem) {
            Collections.sort(elem.getOnMessages(), new Comparator<OnMessage>(){

                @Override
                public int compare(OnMessage arg0, OnMessage arg1) {
                    return arg0.getMessageSignature().toString().compareTo(arg1.getMessageSignature().toString());
                }
            });
            return true;
        }

        public boolean start(Parallel elem) {
            Collections.sort(elem.getPaths(), new Comparator<Block>(){

                @Override
                public int compare(Block arg0, Block arg1) {
                    return arg0.toString().compareTo(arg1.toString());
                }
            });
            return true;
        }

        public boolean start(Protocol elem) {
            return true;
        }

        public boolean start(Unordered elem) {
            Parallel p = new Parallel();
            p.derivedFrom((ModelObject)elem);
            for (int i = elem.getBlock().size() - 1; i >= 0; --i) {
                Activity act = (Activity)elem.getBlock().getContents().remove(i);
                Block b = new Block();
                b.add(act);
                p.getPaths().add(0, b);
            }
            this.start(p);
            ModelObject parent = elem.getParent();
            if (parent instanceof Block) {
                int pos = ((Block)parent).indexOf((Activity)elem);
                if (pos == -1) {
                    LOG.severe("Could not find unordered construct in parent block");
                } else {
                    ((Block)parent).getContents().set(pos, p);
                }
            } else {
                LOG.severe("Unordered construct's parent was not a block");
            }
            return true;
        }

        public boolean start(Do elem) {
            Collections.sort(elem.getInterrupts(), new Comparator<Interrupt>(){

                @Override
                public int compare(Interrupt arg0, Interrupt arg1) {
                    return arg0.toString().compareTo(arg1.toString());
                }
            });
            return true;
        }

        public void accept(Run elem) {
        }
    }
}

