/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.protocol.monitor.Message;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.MessageNode;
import org.scribble.protocol.monitor.model.MessageType;

public class DefaultMonitorContext
implements MonitorContext {
    private static final Logger LOG = Logger.getLogger(DefaultMonitorContext.class.getName());

    public Result validate(Session session, MessageNode mesgNode, Message mesg) {
        Result ret = Result.NOT_HANDLED;
        if (mesgNode.getMessageType().size() > 0) {
            if (mesgNode.getMessageType().size() == mesg.getTypes().size()) {
                ret = Result.VALID;
                for (int i = 0; i < mesgNode.getMessageType().size(); ++i) {
                    MessageType mt = mesgNode.getMessageType().get(i);
                    if (mt.getValue() != null && mt.getValue().equals(mesg.getTypes().get(i))) continue;
                    ret = Result.NOT_HANDLED;
                    break;
                }
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Number of message types different (" + mesgNode.getMessageType().size() + " : " + mesg.getTypes().size() + ")");
            }
        } else if (mesgNode.getOperator() != null && mesg.getOperator() != null && mesgNode.getOperator().equals(mesg.getOperator())) {
            ret = Result.VALID;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Session (" + session + ") validate message '" + mesg + "' against node " + mesgNode + " ret = " + ret);
        }
        return ret;
    }

    public Boolean evaluate(Session session, String expression) {
        Boolean ret = null;
        ret = this.evalOR(session, expression);
        return ret;
    }

    protected Boolean evalOR(Session session, String expression) {
        String[] ors;
        Boolean ret = Boolean.FALSE;
        for (String or : ors = expression.split("or")) {
            Boolean result = this.evalAND(session, or.trim());
            if (result == null) {
                ret = null;
                continue;
            }
            if (result == null || !result.booleanValue()) continue;
            ret = Boolean.TRUE;
            break;
        }
        return ret;
    }

    protected Boolean evalAND(Session session, String expression) {
        Boolean ret = null;
        String[] ands = expression.split("and");
        if (ands.length > 0) {
            ret = Boolean.TRUE;
            for (String and : ands) {
                Object result = session.getState(and.trim());
                if (result == null) {
                    ret = null;
                    break;
                }
                if (!(result instanceof Boolean)) {
                    ret = Boolean.FALSE;
                    break;
                }
                if (((Boolean)result).booleanValue()) continue;
                ret = Boolean.FALSE;
                break;
            }
        }
        return ret;
    }

    public boolean fork(Session session, String linkName, String condition) {
        session.setState(linkName, Boolean.TRUE);
        return true;
    }
}

