/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.protocol.monitor.Message;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Call;
import org.scribble.protocol.monitor.model.Choice;
import org.scribble.protocol.monitor.model.Decision;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.model.Do;
import org.scribble.protocol.monitor.model.Fork;
import org.scribble.protocol.monitor.model.Join;
import org.scribble.protocol.monitor.model.LinkDeclaration;
import org.scribble.protocol.monitor.model.MessageNode;
import org.scribble.protocol.monitor.model.Node;
import org.scribble.protocol.monitor.model.Parallel;
import org.scribble.protocol.monitor.model.Path;
import org.scribble.protocol.monitor.model.ReceiveMessage;
import org.scribble.protocol.monitor.model.Scope;
import org.scribble.protocol.monitor.model.SendMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProtocolMonitor
implements ProtocolMonitor {
    private static final Logger LOG = Logger.getLogger(DefaultProtocolMonitor.class.getName());

    @Override
    public Session createSession(MonitorContext context, Description protocol, Class<? extends Session> sessionClass) {
        Session ret = null;
        try {
            ret = sessionClass.newInstance();
            if (protocol.getNode().size() > 0) {
                this.addNodeToConversation(context, protocol, ret, 0);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to create and initialize session '" + sessionClass + "'", e);
        }
        return ret;
    }

    @Override
    public Result messageSent(MonitorContext context, Description protocol, Session session, Message mesg) {
        int i;
        Result ret = Result.NOT_HANDLED;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("messageSent start: session=" + session + " mesg=" + mesg);
        }
        if (session == null) {
            return new Result(false, "Cannot monitor message due to no session instance");
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < session.getNumberOfNodeIndexes(); ++i) {
            ret = this.checkForMessage(context, protocol, i, session.getNodeIndexAt(i), session, mesg, true);
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < session.getNestedConversations().size(); ++i) {
            Session nested = session.getNestedConversations().get(i);
            ret = this.messageSent(context, protocol, nested, mesg);
            if (!ret.isValid()) continue;
            if (nested.getMainConversation() != null) {
                Session main = nested.getMainConversation();
                if (session.getNestedConversations().remove(main)) {
                    for (Session cc : main.getInterruptConversations()) {
                        if (cc == nested) continue;
                        session.getNestedConversations().remove(cc);
                    }
                }
            }
            if (!nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, session, nested);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("messageSent end: session=" + session + " mesg=" + mesg + " ret=" + ret);
        }
        return ret;
    }

    @Override
    public Result messageReceived(MonitorContext context, Description protocol, Session session, Message mesg) {
        int i;
        Result ret = Result.NOT_HANDLED;
        if (session == null) {
            return new Result(false, "Cannot monitor message due to no session instance");
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < session.getNumberOfNodeIndexes(); ++i) {
            ret = this.checkForMessage(context, protocol, i, session.getNodeIndexAt(i), session, mesg, false);
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < session.getNestedConversations().size(); ++i) {
            Session nested = session.getNestedConversations().get(i);
            ret = this.messageReceived(context, protocol, nested, mesg);
            if (!ret.isValid()) continue;
            if (nested.getMainConversation() != null) {
                Session main = nested.getMainConversation();
                if (session.getNestedConversations().remove(main)) {
                    for (Session cc : main.getInterruptConversations()) {
                        if (cc == nested) continue;
                        session.getNestedConversations().remove(cc);
                    }
                }
            }
            if (!nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, session, nested);
        }
        return ret;
    }

    protected Result checkForMessage(MonitorContext context, Description protocol, int pos, int nodeIndex, Session conv, Message mesg, boolean send) {
        Join join;
        Boolean result;
        Result ret = Result.NOT_HANDLED;
        Node node = protocol.getNode().get(nodeIndex);
        if (send && node instanceof SendMessage || !send && node instanceof ReceiveMessage) {
            ret = this.validateMessage(context, conv, (MessageNode)node, mesg);
            if (ret.isValid()) {
                conv.removeNodeIndexAt(pos);
                if (node.getNextIndex() != -1) {
                    this.addNodeToConversation(context, protocol, conv, node.getNextIndex());
                }
            }
        } else if (node instanceof Choice) {
            for (int j = 0; ret == Result.NOT_HANDLED && j < ((Choice)node).getPath().size(); ++j) {
                Path cn = ((Choice)node).getPath().get(j);
                if (cn.getNextIndex() == -1) continue;
                ret = this.checkForMessage(context, protocol, pos, cn.getNextIndex(), conv, mesg, send);
            }
        } else if (node instanceof Decision) {
            if (((Decision)node).getInnerIndex() != -1) {
                ret = this.checkForMessage(context, protocol, pos, ((Decision)node).getInnerIndex(), conv, mesg, send);
            }
            if (ret == Result.NOT_HANDLED && node.getNextIndex() != -1) {
                ret = this.checkForMessage(context, protocol, pos, node.getNextIndex(), conv, mesg, send);
            }
        } else if (node instanceof Join && (result = context.evaluate(conv, (join = (Join)node).getExpression())) != null && result.booleanValue()) {
            if (node.getNextIndex() != -1) {
                ret = this.checkForMessage(context, protocol, pos, node.getNextIndex(), conv, mesg, send);
                if (!ret.isValid()) {
                    conv.removeNodeIndexAt(pos);
                    this.addNodeToConversation(context, protocol, conv, node.getNextIndex());
                }
            } else {
                conv.removeNodeIndexAt(pos);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("checkForMessage: pos=" + pos + " nodeIndex=" + nodeIndex + " node=" + node + " conv=" + conv + " mesg=" + mesg + " send=" + send + " ret=" + ret);
        }
        return ret;
    }

    protected Result validateMessage(MonitorContext context, Session conv, MessageNode node, Message sig) {
        return context.validate(conv, node, sig);
    }

    protected void addNodeToConversation(MonitorContext context, Description protocol, Session session, int nodeIndex) {
        Node node = protocol.getNode().get(nodeIndex);
        if (node.getClass() == Scope.class) {
            this.initScope(context, protocol, session, (Scope)node);
        } else if (node.getClass() == Do.class) {
            Session nested = this.initScope(context, protocol, session, (Do)node);
            for (Path path : ((Do)node).getPath()) {
                Session interruptScope = session.createInterruptConversation(nested, node.getNextIndex());
                interruptScope.addNodeIndex(path.getNextIndex());
            }
        } else if (node.getClass() == Call.class) {
            if (((Call)node).getCallIndex() != -1) {
                this.addNodeToConversation(context, protocol, session, ((Call)node).getCallIndex());
            }
            if (node.getNextIndex() != -1) {
                this.addNodeToConversation(context, protocol, session, node.getNextIndex());
            }
        } else if (node.getClass() == Parallel.class) {
            if (node.getNextIndex() != -1) {
                Session nestedContext = session.createNestedConversation(node.getNextIndex());
                Parallel pnode = (Parallel)node;
                for (Path path : pnode.getPath()) {
                    if (path.getNextIndex() == -1) continue;
                    this.addNodeToConversation(context, protocol, nestedContext, path.getNextIndex());
                }
            }
        } else if (node.getClass() == LinkDeclaration.class) {
            LinkDeclaration linkDecl = (LinkDeclaration)node;
            session.declareLink(linkDecl.getName());
            if (node.getNextIndex() != -1) {
                this.addNodeToConversation(context, protocol, session, node.getNextIndex());
            }
        } else if (node.getClass() == Fork.class) {
            Fork fork = (Fork)node;
            if (context.fork(session, fork.getLinkName(), fork.getCondition())) {
                if (node.getNextIndex() != -1) {
                    this.addNodeToConversation(context, protocol, session, node.getNextIndex());
                }
            } else {
                session.addNodeIndex(nodeIndex);
            }
        } else if (node.getClass() == Join.class) {
            Join join = (Join)node;
            Boolean result = context.evaluate(session, join.getExpression());
            if (result == null) {
                session.addNodeIndex(nodeIndex);
            } else if (result.booleanValue() && node.getNextIndex() != -1) {
                this.addNodeToConversation(context, protocol, session, node.getNextIndex());
            }
        } else {
            session.addNodeIndex(nodeIndex);
        }
    }

    protected Session initScope(MonitorContext context, Description protocol, Session conv, Scope scope) {
        Session nestedContext = null;
        if (scope.getInnerIndex() != -1) {
            nestedContext = conv.createNestedConversation(scope.getNextIndex());
            this.addNodeToConversation(context, protocol, nestedContext, scope.getInnerIndex());
        } else {
            System.err.println("EXTERNAL PROTOCOL MONITORING NOT CURRENTLY SUPPORTED");
        }
        return nestedContext;
    }

    protected void nestedConversationFinished(MonitorContext context, Description protocol, Session conv, Session nested) {
        if (nested.getReturnIndex() != -1) {
            this.addNodeToConversation(context, protocol, conv, nested.getReturnIndex());
        }
        conv.removeNestedConversation(nested);
        for (Session cc : nested.getInterruptConversations()) {
            conv.removeNestedConversation(cc);
        }
    }
}

