/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.monitor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.protocol.monitor.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSession
implements Session,
Externalizable {
    private static final int VERSION = 2;
    private List<Integer> _nodeIndexes = new Vector<Integer>();
    private int _returnIndex = -1;
    private Session _parentConversation = null;
    private Session _mainConversation = null;
    private List<Session> _nestedConversations = new Vector<Session>();
    private List<Session> _interruptConversations = new Vector<Session>();
    private Map<String, Object> _state = new HashMap<String, Object>();

    public DefaultSession() {
    }

    protected DefaultSession(int returnIndex) {
        this._returnIndex = returnIndex;
    }

    protected DefaultSession(Session main, int returnIndex) {
        this._mainConversation = main;
        this._returnIndex = returnIndex;
    }

    @Override
    public void addNodeIndex(int index) {
        this._nodeIndexes.add(index);
    }

    @Override
    public void removeNodeIndexAt(int pos) {
        this._nodeIndexes.remove(pos);
    }

    @Override
    public int getNumberOfNodeIndexes() {
        return this._nodeIndexes.size();
    }

    @Override
    public int getNodeIndexAt(int pos) {
        return this._nodeIndexes.get(pos);
    }

    @Override
    public boolean isFinished() {
        return this._nodeIndexes.size() == 0 && this._nestedConversations.size() == 0;
    }

    @Override
    public Session createNestedConversation(int returnIndex) {
        DefaultSession ret = new DefaultSession(returnIndex);
        this._nestedConversations.add(ret);
        ret._parentConversation = this;
        return ret;
    }

    @Override
    public Session createInterruptConversation(Session main, int returnIndex) {
        DefaultSession ret = new DefaultSession(main, returnIndex);
        this._nestedConversations.add(ret);
        main.getInterruptConversations().add(ret);
        ret._parentConversation = this;
        return ret;
    }

    @Override
    public int getReturnIndex() {
        return this._returnIndex;
    }

    public void setReturnIndex(int returnIndex) {
        this._returnIndex = returnIndex;
    }

    @Override
    public List<Session> getNestedConversations() {
        return this._nestedConversations;
    }

    @Override
    public void removeNestedConversation(Session session) {
        this._nestedConversations.remove(session);
    }

    public Session getParentConversation() {
        return this._parentConversation;
    }

    @Override
    public Session getMainConversation() {
        return this._mainConversation;
    }

    @Override
    public List<Session> getInterruptConversations() {
        return this._interruptConversations;
    }

    @Override
    public void declareLink(String linkName) {
        this.setStateValue(linkName, null);
    }

    protected DefaultSession getDeclaredSession(String name) {
        if (this._state.containsKey(name)) {
            return this;
        }
        if (this.getParentConversation() instanceof DefaultSession) {
            return ((DefaultSession)this.getParentConversation()).getDeclaredSession(name);
        }
        return null;
    }

    @Override
    public Object getState(String name) {
        DefaultSession sess = this.getDeclaredSession(name);
        if (sess != null) {
            return sess.getStateValue(name);
        }
        return null;
    }

    protected Object getStateValue(String name) {
        return this._state.get(name);
    }

    protected void setStateValue(String name, Object value) {
        this._state.put(name, (Serializable)value);
    }

    @Override
    public void setState(String name, Object value) {
        DefaultSession sess = this.getDeclaredSession(name);
        if (sess == null) {
            sess = this;
        }
        sess.setStateValue(name, value);
    }

    public Map<String, Object> getState() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        this.applyState(ret);
        return ret;
    }

    protected void applyState(Map<String, Object> state) {
        if (this._parentConversation instanceof DefaultSession) {
            ((DefaultSession)this._parentConversation).applyState(state);
        }
        state.putAll(this._state);
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        int version = ois.readInt();
        int nodeIndexes = ois.readInt();
        for (int i = 0; i < nodeIndexes; ++i) {
            this._nodeIndexes.add(ois.readInt());
        }
        this._returnIndex = ois.readInt();
        this._mainConversation = (Session)ois.readObject();
        int nestedSize = ois.readInt();
        for (int i = 0; i < nestedSize; ++i) {
            this._nestedConversations.add((Session)ois.readObject());
        }
        int interruptSize = ois.readInt();
        for (int i = 0; i < interruptSize; ++i) {
            this._interruptConversations.add((Session)ois.readObject());
        }
        if (version > 1) {
            this._parentConversation = (Session)ois.readObject();
            int stateSize = ois.readInt();
            for (int i = 0; i < stateSize; ++i) {
                String key = ois.readUTF();
                this._state.put(key, ois.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeInt(2);
        oos.writeInt(this._nodeIndexes.size());
        Iterator<Object> i$ = this._nodeIndexes.iterator();
        while (i$.hasNext()) {
            int index = i$.next();
            oos.writeInt(index);
        }
        oos.writeInt(this._returnIndex);
        oos.writeObject(this._mainConversation);
        oos.writeInt(this._nestedConversations.size());
        for (Session session : this._nestedConversations) {
            oos.writeObject(session);
        }
        oos.writeInt(this._interruptConversations.size());
        for (Session session : this._interruptConversations) {
            oos.writeObject(session);
        }
        oos.writeObject(this._parentConversation);
        oos.writeInt(this._state.size());
        for (String key : this._state.keySet()) {
            oos.writeUTF(key);
            oos.writeObject(this._state.get(key));
        }
    }
}

