/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;

public class InteractionProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Interaction.class;
    }

    protected Interaction createInteraction() {
        return new Interaction();
    }

    public Object project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        Interaction ret = this.createInteraction();
        Interaction source = (Interaction)model;
        boolean roleFound = false;
        ret.derivedFrom((ModelObject)source);
        if (source.getFromRole() != null) {
            if (source.getFromRole().equals((Object)role)) {
                roleFound = true;
            } else {
                Object state = context.getState(source.getFromRole().getName());
                if (state instanceof Role) {
                    Role r = new Role();
                    r.setName(source.getFromRole().getName());
                    r.derivedFrom((ModelObject)source.getFromRole());
                    ret.setFromRole(r);
                }
            }
        }
        if (source.getToRoles().size() > 0) {
            if (source.getToRoles().contains(role)) {
                roleFound = true;
            } else {
                for (Role sr : source.getToRoles()) {
                    Object state = context.getState(sr.getName());
                    if (!(state instanceof Role)) continue;
                    Role r = new Role();
                    r.setName(sr.getName());
                    r.derivedFrom((ModelObject)sr);
                    ret.getToRoles().add(r);
                }
            }
        }
        if (roleFound) {
            ret.setMessageSignature((MessageSignature)context.project((ModelObject)source.getMessageSignature(), role, l));
        } else {
            ret = null;
        }
        return ret;
    }
}

