/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Inline;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;

public class ProtocolProjectorRule
implements ProjectorRule {
    private static final Logger LOG = Logger.getLogger(ProtocolProjectorRule.class.getName());

    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Protocol.class;
    }

    public Object project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        Object ret = null;
        Protocol source = (Protocol)model;
        List<Role> roles = context.getRolesOfInterestForDefinition(source);
        if (context.isOuterScope() || roles != null) {
            if (roles == null) {
                roles = new Vector<Role>();
                roles.add(role);
            }
            for (int j = 0; j < roles.size(); ++j) {
                role = roles.get(j);
                Protocol prot = ProtocolProjectorRule.startProtocolProjection(context, source, role, l);
                prot.setBlock((Block)context.project((ModelObject)source.getBlock(), role, l));
                prot.getBlock().setParent((ModelObject)prot);
                ProtocolProjectorRule.endProtocolProjection(context, source, prot, role, l);
                this.cleanUpRoles(prot);
                if (ret == null) {
                    ret = prot;
                    continue;
                }
                if (ret instanceof List) {
                    ((List)ret).add(prot);
                    continue;
                }
                Vector<Object> b = new Vector<Object>();
                b.add((ModelObject)ret);
                b.add(prot);
                ret = b;
            }
        }
        return ret;
    }

    public static Protocol startProtocolProjection(ProtocolProjectorContext context, Protocol source, Role role, Journal l) {
        Protocol prot = new Protocol();
        prot.derivedFrom((ModelObject)source);
        prot.setName(source.getName());
        Role located = (Role)context.project((ModelObject)role, role, l);
        prot.setLocatedRole(located);
        context.pushScope();
        for (ParameterDefinition p : source.getParameterDefinitions()) {
            ParameterDefinition projp = (ParameterDefinition)context.project((ModelObject)p, role, l);
            if (projp == null) continue;
            prot.getParameterDefinitions().add(projp);
        }
        return prot;
    }

    public static void endProtocolProjection(ProtocolProjectorContext context, Protocol source, Protocol projected, Role role, Journal l) {
        for (Protocol nested : source.getNestedProtocols()) {
            Object pp = context.project((ModelObject)nested, role, l);
            if (pp instanceof Protocol) {
                projected.getNestedProtocols().add((Protocol)pp);
                continue;
            }
            if (!(pp instanceof List)) continue;
            for (Object obj : (List)pp) {
                if (obj instanceof Protocol) {
                    projected.getNestedProtocols().add((Protocol)obj);
                    continue;
                }
                LOG.severe("Projection of nested protocol returned unexpected component: " + obj);
            }
        }
        context.popScope();
    }

    protected void cleanUpRoles(Protocol protocol) {
        protocol.visit((Visitor)new DefaultVisitor(){

            public void accept(Introduces list) {
                Block parent = (Block)list.getParent();
                for (int i = list.getIntroducedRoles().size() - 1; i >= 0; --i) {
                    final Role role = (Role)list.getIntroducedRoles().get(i);
                    final Vector acts = new Vector();
                    parent.visit((Visitor)new DefaultVisitor(){

                        public void accept(Interaction interaction) {
                            if (role.equals((Object)interaction.getFromRole()) || interaction.getToRoles().contains(role)) {
                                acts.add(interaction);
                            }
                        }

                        public boolean start(Choice choice) {
                            if (role.equals((Object)choice.getRole())) {
                                acts.add(choice);
                            }
                            return true;
                        }

                        public void accept(Run run) {
                            if (run.getParameter(role.getName()) != null) {
                                acts.add(run);
                            }
                        }

                        public void accept(Inline elem) {
                            if (elem.getParameter(role.getName()) != null) {
                                acts.add(elem);
                            }
                        }
                    });
                    if (acts.size() != 0) continue;
                    list.getIntroducedRoles().remove(role);
                    if (list.getIntroducedRoles().size() != 0) continue;
                    parent.remove((Activity)list);
                }
            }
        });
    }
}

