/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.Collection;
import java.util.List;
import org.scribble.protocol.model.Behaviour;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interaction
extends Behaviour {
    private static final long serialVersionUID = -3628413228540452576L;
    private MessageSignature m_messageSignature = null;
    private Role m_fromRole = null;
    private List<Role> m_toRoles = new ContainmentList<Role>(this, Role.class);

    public Interaction() {
    }

    public Interaction(Role fromRole, MessageSignature sig) {
        this.m_fromRole = fromRole;
        this.m_messageSignature = sig;
    }

    public Interaction(Role fromRole, Role toRole, MessageSignature sig) {
        this(fromRole, sig);
        if (toRole != null) {
            this.m_toRoles.add(toRole);
        }
    }

    public Interaction(Role fromRole, Collection<Role> toRoles, MessageSignature sig) {
        this(fromRole, sig);
        this.m_toRoles.addAll(toRoles);
    }

    public MessageSignature getMessageSignature() {
        return this.m_messageSignature;
    }

    public void setMessageSignature(MessageSignature signature) {
        if (this.m_messageSignature != null) {
            this.m_messageSignature.setParent(null);
        }
        this.m_messageSignature = signature;
        if (this.m_messageSignature != null) {
            this.m_messageSignature.setParent(this);
        }
    }

    public Role getFromRole() {
        return this.m_fromRole;
    }

    public void setFromRole(Role part) {
        this.m_fromRole = part;
    }

    public List<Role> getToRoles() {
        return this.m_toRoles;
    }

    @Override
    public List<Role> initiatorRoles() {
        List<Role> ret = super.initiatorRoles();
        if (this.getFromRole() != null) {
            if (!ret.contains(this.getFromRole())) {
                ret.add(this.getFromRole());
            }
        } else {
            Role located;
            Protocol defn = this.enclosingProtocol();
            if (defn != null && (located = defn.getRole()) != null && this.getToRoles().size() > 0 && !this.getToRoles().contains(located) && !ret.contains(located)) {
                ret.add(located);
            }
        }
        return ret;
    }

    @Override
    public List<Role> finalRoles() {
        List<Role> ret = super.finalRoles();
        if (this.getToRoles().size() > 0) {
            for (Role r : this.getToRoles()) {
                if (ret.contains(r)) continue;
                ret.add(r);
            }
        } else {
            Role located;
            Protocol defn = this.enclosingProtocol();
            if (defn != null && (located = defn.getRole()) != null && this.getFromRole() != null && !this.getFromRole().equals(located) && !ret.contains(located)) {
                ret.add(located);
            }
        }
        return ret;
    }

    @Override
    public List<Role> associatedRoles() {
        Role located;
        List<Role> ret = super.associatedRoles();
        if (this.getToRoles().size() > 0) {
            for (Role r : this.getToRoles()) {
                if (ret.contains(r)) continue;
                ret.add(r);
            }
        }
        if (this.getFromRole() != null && !ret.contains(this.getFromRole())) {
            ret.add(this.getFromRole());
        }
        if (!(this.getToRoles().size() != 0 && this.getFromRole() != null || (located = this.locatedRole()) == null || ret.contains(located))) {
            ret.add(located);
        }
        return ret;
    }

    @Override
    public boolean isWaitState() {
        boolean ret = false;
        Role role = this.locatedRole();
        if (role != null && (this.getToRoles().size() > 0 && this.getToRoles().contains(role) || this.getFromRole() != null && !role.equals(this.getFromRole()))) {
            ret = true;
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.getMessageSignature() != null) {
            ret.append(this.getMessageSignature());
            ret.append(" ");
        }
        if (this.getFromRole() != null) {
            ret.append(this.getFromRole());
            ret.append("->");
            for (int i = 0; i < this.getToRoles().size(); ++i) {
                if (i > 0) {
                    ret.append(",");
                }
                ret.append(this.getToRoles().get(i));
            }
        } else {
            ret.append("->");
            for (int i = 0; i < this.getToRoles().size(); ++i) {
                if (i > 0) {
                    ret.append(",");
                }
                ret.append(this.getToRoles().get(i));
            }
        }
        return ret.toString();
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.accept(this);
        if (this.getMessageSignature() != null) {
            this.getMessageSignature().visit(visitor);
        }
        if (this.getFromRole() != null) {
            this.getFromRole().visit(visitor);
        }
        for (Role r : this.getToRoles()) {
            r.visit(visitor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interaction that = (Interaction)o;
        return !(this.m_fromRole == null ? that.m_fromRole != null : !this.m_fromRole.equals(that.m_fromRole)) && !(this.m_messageSignature == null ? that.m_messageSignature != null : !this.m_messageSignature.equals(that.m_messageSignature)) && ((Object)this.m_toRoles).equals(that.m_toRoles);
    }

    public int hashCode() {
        int result = this.m_messageSignature != null ? this.m_messageSignature.hashCode() : 0;
        result = 31 * result + (this.m_fromRole != null ? this.m_fromRole.hashCode() : 0);
        result = 31 * result + (this.m_toRoles != null ? ((Object)this.m_toRoles).hashCode() : 0);
        return result;
    }
}

