/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protocol
extends ModelObject {
    private String _name = null;
    private Role _locatedRole = null;
    private Block _block = null;
    private List<Protocol> _nestedProtocols = new ContainmentList<Protocol>(this, Protocol.class);
    private List<ParameterDefinition> _parameterDefs = new ContainmentList<ParameterDefinition>(this, ParameterDefinition.class);

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Role getLocatedRole() {
        return this._locatedRole;
    }

    public void setLocatedRole(Role role) {
        if (this._locatedRole != null) {
            this._locatedRole.setParent(null);
        }
        this._locatedRole = role;
        if (this._locatedRole != null) {
            this._locatedRole.setParent(this);
        }
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this._parameterDefs;
    }

    public ParameterDefinition getParameterDefinition(String name) {
        ParameterDefinition ret = null;
        for (ParameterDefinition pd : this.getParameterDefinitions()) {
            if (!pd.getName().equals(name)) continue;
            ret = pd;
            break;
        }
        return ret;
    }

    public Block getBlock() {
        if (this._block == null) {
            this._block = new Block();
            this._block.setParent(this);
        }
        return this._block;
    }

    public void setBlock(Block block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public List<Protocol> getNestedProtocols() {
        return this._nestedProtocols;
    }

    @Override
    public ProtocolModel getModel() {
        ProtocolModel ret = null;
        ModelObject cur = this;
        while (ret == null && cur != null) {
            if (cur instanceof ProtocolModel) {
                ret = (ProtocolModel)cur;
                continue;
            }
            cur = cur.getParent();
        }
        return ret;
    }

    public Protocol getEnclosingProtocol() {
        return this;
    }

    public Protocol getTopLevelProtocol() {
        Protocol ret = this;
        if (this.getParent() instanceof Protocol) {
            ret = ((Protocol)this.getParent()).getTopLevelProtocol();
        }
        return ret;
    }

    public Protocol getNestedProtocol(String name) {
        for (Protocol protocol : this._nestedProtocols) {
            if (!protocol.getName().equals(name)) continue;
            return protocol;
        }
        return null;
    }

    public List<Role> getRoles() {
        final Vector<Role> ret = new Vector<Role>();
        for (ParameterDefinition p : this.getParameterDefinitions()) {
            if (!p.isRole()) continue;
            ret.add(p.getRole());
        }
        this.visit(new DefaultVisitor(){

            public boolean start(Protocol elem) {
                return Protocol.this == elem;
            }

            public void accept(Introduces elem) {
                ret.addAll(elem.getIntroducedRoles());
            }
        });
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
        if (visitor.start(this)) {
            if (this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
            for (Protocol p : this.getNestedProtocols()) {
                p.visit(visitor);
            }
        }
        visitor.end(this);
    }
}

