/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.util.RunUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InteractionUtil {
    private InteractionUtil() {
    }

    public static Role getFromRole(ModelObject act) {
        Role ret = null;
        if (act instanceof Interaction) {
            ret = ((Interaction)act).getFromRole();
        }
        return ret;
    }

    public static Role getToRole(ModelObject act) {
        Role ret = null;
        if (act instanceof Interaction && ((Interaction)act).getToRoles().size() > 0) {
            ret = ((Interaction)act).getToRoles().get(0);
        }
        return ret;
    }

    public static MessageSignature getMessageSignature(ModelObject act) {
        MessageSignature ret = null;
        if (act instanceof Interaction) {
            ret = ((Interaction)act).getMessageSignature();
        }
        return ret;
    }

    public static List<ModelObject> getInitialInteractions(ModelObject scope) {
        Vector<ModelObject> ret = new Vector<ModelObject>();
        scope.visit(new InitialInteractionVisitor(ret));
        return ret;
    }

    public static boolean isInitialInteraction(ModelObject scope, ModelObject interaction) {
        boolean ret = false;
        List<ModelObject> initial = InteractionUtil.getInitialInteractions(scope);
        for (int i = 0; !ret && i < initial.size(); ++i) {
            ret = initial.get(i) == interaction;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitialInteractionVisitor
    extends DefaultVisitor {
        private List<ModelObject> _interactions = null;
        private boolean _record = true;
        private Map<ModelObject, Boolean> _savedState = new HashMap<ModelObject, Boolean>();

        public InitialInteractionVisitor(List<ModelObject> list) {
            this._interactions = list;
        }

        @Override
        public boolean start(Protocol elem) {
            return !(elem.getParent() instanceof Protocol);
        }

        @Override
        public boolean start(Choice elem) {
            return this._record;
        }

        @Override
        public void end(Choice elem) {
            this._record = false;
        }

        @Override
        public boolean start(Block elem) {
            if (elem.getParent() instanceof Choice) {
                this._savedState.put(elem, this._record);
            }
            return true;
        }

        @Override
        public void end(Block elem) {
            if (elem.getParent() instanceof Choice) {
                this._record = this._savedState.get(elem);
            }
        }

        @Override
        public void accept(Interaction elem) {
            if (this._record) {
                this._interactions.add(elem);
                this._record = false;
            }
        }

        @Override
        public void accept(Run elem) {
            Protocol protocol = RunUtil.getInnerProtocol(elem.getEnclosingProtocol(), elem.getProtocolReference());
            if (protocol != null) {
                protocol.getBlock().visit(this);
            }
        }
    }
}

