/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidatorContext;

public class RecursionValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Recursion.class;
    }

    public void validate(ProtocolValidatorContext pvc, ModelObject obj, Journal logger) {
        Recursion elem = (Recursion)obj;
        if (elem.getLabel() != null) {
            boolean found = false;
            for (ModelObject act = elem.getParent(); !found && act != null && !(act instanceof Protocol); act = act.getParent()) {
                if (!(act instanceof RecBlock) || ((RecBlock)act).getLabel() == null || !((RecBlock)act).getLabel().equals(elem.getLabel())) continue;
                found = true;
            }
            if (!found) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_NO_ENCLOSING_RECUR"), elem.getLabel()), obj.getProperties());
            }
        }
    }
}

