/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.w3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.htmlunit.HtmlUnitInputProcessor;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.w3.Action;
import org.openqa.selenium.interactions.Sequence;

public final class Algorithms {
    private Algorithms() {
    }

    public static List<List<Action>> extractActionSequence(Collection<Sequence> sequences) {
        ArrayList<List<Action>> actionsByTick = new ArrayList<List<Action>>();
        for (Sequence sequence : sequences) {
            Map actionSequence = sequence.encode();
            ArrayList<Action> sourceActions = Algorithms.processInputSourceActionSequence(actionSequence);
            int i = 0;
            while (i < sourceActions.size()) {
                Action action = sourceActions.get(i);
                if (actionsByTick.size() < i + 1) {
                    actionsByTick.add(new ArrayList());
                }
                ((List)actionsByTick.get(i)).add(action);
                ++i;
            }
        }
        return actionsByTick;
    }

    private static ArrayList<Action> processInputSourceActionSequence(Map<String, Object> actionSequence) {
        String type = actionSequence.get("type").toString();
        Object id = actionSequence.get("id");
        Map<String, Object> parameters = null;
        if ("pointer".equals(type)) {
            Map parametersData = (Map)actionSequence.get("parameters");
            parameters = Algorithms.processPointerParameters(parametersData);
        }
        List actionItems = (List)actionSequence.get("actions");
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Map actionItem : actionItems) {
            Action action = null;
            if ("none".equals(type)) {
                action = Algorithms.processNullAction(id.toString(), actionItem);
            } else if ("key".equals(type)) {
                action = Algorithms.processKeyAction(id.toString(), actionItem);
            } else if ("pointer".equals(type)) {
                action = Algorithms.processPointerAction(id.toString(), parameters, actionItem);
            } else if ("wheel".equals(type)) {
                action = Algorithms.processWheelAction(id.toString(), actionItem);
            }
            actions.add(action);
        }
        return actions;
    }

    private static Map<String, Object> processPointerParameters(Map<String, Object> parametersData) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pointerType", "mouse");
        if (parametersData == null) {
            return parameters;
        }
        Object pointerType = parametersData.get("pointerType");
        if (pointerType != null) {
            parameters.put("pointerType", pointerType);
        }
        return parameters;
    }

    private static Action processNullAction(String id, Map<String, Object> actionItem) {
        String subtype = actionItem.get("type").toString();
        Action action = new Action(id, "none", subtype);
        Action result = Algorithms.processPauseAction(actionItem, action);
        return result;
    }

    private static Action processKeyAction(String id, Map<String, Object> actionItem) {
        String subtype = actionItem.get("type").toString();
        Action action = new Action(id, "key", subtype);
        if ("pause".equals(subtype)) {
            Action result = Algorithms.processPauseAction(actionItem, action);
            return result;
        }
        Object key = actionItem.get("value");
        action.setValue(key.toString());
        return action;
    }

    private static Action processPointerAction(String id, Map<String, Object> parameters, Map<String, Object> actionItem) {
        String subtype = actionItem.get("type").toString();
        Action action = new Action(id, "pointer", subtype);
        if ("pause".equals(subtype)) {
            Action result = Algorithms.processPauseAction(actionItem, action);
            return result;
        }
        Object origin = actionItem.get("origin");
        if (origin instanceof HtmlUnitWebElement) {
            HtmlUnitWebElement webElement = (HtmlUnitWebElement)origin;
            action.setDomElement(webElement.getElement());
        }
        action.setPointerType(parameters.get("pointerType").toString());
        if ("pointerUp".equals(subtype) || "pointerDown".equals(subtype)) {
            Algorithms.processPointerUpOrPointerDownAction(actionItem, action);
        }
        if ("pointerMove".equals(subtype)) {
            Algorithms.processPointerMoveAction(actionItem, action);
        }
        if ("pointerCancel".equals(subtype)) {
            Algorithms.processPointerCancelAction(actionItem);
        }
        return action;
    }

    private static Action processWheelAction(String id, Map<String, Object> actionItem) {
        return null;
    }

    private static void processPointerUpOrPointerDownAction(Map<String, Object> actionItem, Action action) {
        Object button = actionItem.get("button");
        try {
            int butt = Integer.parseInt(button.toString());
            action.setButton(butt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void processPointerMoveAction(Map<String, Object> actionItem, Action action) {
    }

    private static void processPointerCancelAction(Map<String, Object> actionItem) {
    }

    private static Action processPauseAction(Map<String, Object> actionItem, Action action) {
        Object duration = actionItem.get("duration");
        try {
            int dur = Integer.parseInt(duration.toString());
            action.setDuration(dur);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return action;
    }

    public static void dispatchActions(List<List<Action>> actionsByTick, HtmlUnitInputProcessor inputProcessor) {
        for (List<Action> actions : actionsByTick) {
            for (Action action : actions) {
                inputProcessor.enqueuAction(action);
            }
        }
        inputProcessor.performActions();
    }
}

