/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.options;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ProxyConfig;
import org.htmlunit.WebClientOptions;
import org.htmlunit.util.UrlUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.htmlunit.BrowserVersionDeterminer;
import org.openqa.selenium.htmlunit.options.BrowserVersionTrait;
import org.openqa.selenium.htmlunit.options.HtmlUnitOption;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.Browser;

public class HtmlUnitDriverOptions
extends AbstractDriverOptions<HtmlUnitDriverOptions> {
    public static final String HTMLUNIT_OPTIONS = "garg:htmlunitOptions";
    private WebClientOptions webClientOptions_ = new WebClientOptions();
    private BrowserVersion webClientVersion_ = BrowserVersion.BEST_SUPPORTED;

    public HtmlUnitDriverOptions() {
        this.setCapability("browserName", Browser.HTMLUNIT.browserName());
        this.webClientOptions_.setHomePage(UrlUtils.URL_ABOUT_BLANK.toString());
        this.webClientOptions_.setThrowExceptionOnFailingStatusCode(false);
        this.webClientOptions_.setPrintContentOnFailingStatusCode(false);
        this.webClientOptions_.setUseInsecureSSL(true);
    }

    public HtmlUnitDriverOptions(BrowserVersion version) {
        this();
        this.setWebClientVersion(version);
    }

    public HtmlUnitDriverOptions(BrowserVersion version, boolean enableJavascript) {
        this();
        this.setWebClientVersion(version);
        this.setJavaScriptEnabled(enableJavascript);
    }

    public HtmlUnitDriverOptions(Capabilities source) {
        this();
        if (source != null) {
            source.asMap().forEach(this::setCapability);
            this.setCapability("browserName", Browser.HTMLUNIT.browserName());
            if (source instanceof HtmlUnitDriverOptions) {
                HtmlUnitDriverOptions.transfer(((HtmlUnitDriverOptions)source).webClientOptions_, this.webClientOptions_);
                this.webClientVersion_ = ((HtmlUnitDriverOptions)source).webClientVersion_;
            } else {
                Object htmlunitOptions = source.getCapability(HTMLUNIT_OPTIONS);
                if (htmlunitOptions != null) {
                    this.importOptions(htmlunitOptions);
                    this.setCapability(HTMLUNIT_OPTIONS, null);
                } else {
                    this.webClientVersion_ = BrowserVersionDeterminer.determine(source);
                }
            }
            if (this.isJavaScriptEnabled() && Boolean.FALSE == source.getCapability("javascriptEnabled")) {
                this.setJavaScriptEnabled(false);
            }
            if (!this.isDownloadImages() && source.is("downloadImages")) {
                this.setDownloadImages(true);
            }
            super.setCapability("javascriptEnabled", null);
            super.setCapability("downloadImages", null);
        }
    }

    public HtmlUnitDriverOptions(Map<String, Object> optionsMap) {
        this((Capabilities)new MutableCapabilities((Map)Require.nonNull((String)"Source options map", optionsMap)));
    }

    public Object getCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (HTMLUNIT_OPTIONS.equals(capabilityName)) {
            return this.exportOptions();
        }
        HtmlUnitOption option = HtmlUnitOption.fromCapabilityKey(capabilityName);
        if (option != null) {
            switch (option) {
                case SSL_CLIENT_CERTIFICATE_PASSWORD: 
                case SSL_TRUST_STORE_PASSWORD: {
                    return null;
                }
                case WEB_CLIENT_VERSION: {
                    return this.webClientVersion_;
                }
            }
            return option.obtain(this.webClientOptions_);
        }
        BrowserVersionTrait trait = BrowserVersionTrait.fromCapabilityKey(capabilityName);
        if (trait != null) {
            return trait.obtain(this.webClientVersion_);
        }
        return super.getCapability(capabilityName);
    }

    public void setCapability(String capabilityName, Object value) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (HTMLUNIT_OPTIONS.equals(capabilityName)) {
            this.importOptions(value);
            return;
        }
        HtmlUnitOption option = HtmlUnitOption.fromCapabilityKey(capabilityName);
        if (option != null) {
            switch (option) {
                case WEB_CLIENT_VERSION: {
                    this.webClientVersion_ = (BrowserVersion)option.decode(value);
                    return;
                }
            }
            option.insert(this.webClientOptions_, value);
            return;
        }
        if (BrowserVersionTrait.fromCapabilityKey(capabilityName) != null) {
            throw new UnsupportedOperationException("Individual browser version traits are immutable; '" + capabilityName + "' cannot be set");
        }
        super.setCapability(capabilityName, value);
    }

    protected Set<String> getExtraCapabilityNames() {
        return Collections.singleton(HTMLUNIT_OPTIONS);
    }

    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        if (HTMLUNIT_OPTIONS.equals(capabilityName)) {
            return this.exportOptions();
        }
        return null;
    }

    public HtmlUnitDriverOptions importOptions(WebClientOptions source) {
        HtmlUnitDriverOptions.transfer(source, this.webClientOptions_);
        return this;
    }

    public void applyOptions(WebClientOptions target) {
        HtmlUnitDriverOptions.transfer(this.webClientOptions_, target);
    }

    public boolean isJavaScriptEnabled() {
        return this.webClientOptions_.isJavaScriptEnabled();
    }

    public HtmlUnitDriverOptions setJavaScriptEnabled(boolean enableJavascript) {
        this.webClientOptions_.setJavaScriptEnabled(enableJavascript);
        return this;
    }

    public boolean isDownloadImages() {
        return this.webClientOptions_.isDownloadImages();
    }

    public HtmlUnitDriverOptions setDownloadImages(boolean downloadImages) {
        this.webClientOptions_.setDownloadImages(downloadImages);
        return this;
    }

    public BrowserVersion getWebClientVersion() {
        return this.webClientVersion_;
    }

    public HtmlUnitDriverOptions setWebClientVersion(BrowserVersion webClientVersion) {
        Require.nonNull((String)"Web client version", (Object)webClientVersion);
        this.webClientVersion_ = webClientVersion;
        return this;
    }

    public HtmlUnitDriverOptions setSSLClientCertificateKeyStore(KeyStore keyStore, char[] keyStorePassword) {
        this.webClientOptions_.setSSLClientCertificateKeyStore(keyStore, keyStorePassword);
        return this;
    }

    public HtmlUnitDriverOptions setSSLClientCertificateKeyStore(URL keyStoreUrl, String keyStorePassword, String keyStoreType) {
        Require.nonNull((String)"Key store URL", (Object)keyStoreUrl);
        this.webClientOptions_.setSSLClientCertificateKeyStore(keyStoreUrl, keyStorePassword, keyStoreType);
        return this;
    }

    public HtmlUnitDriverOptions setSSLClientCertificateKeyStore(InputStream keyStoreInputStream, String keyStorePassword, String keyStoreType) {
        this.webClientOptions_.setSSLClientCertificateKeyStore(keyStoreInputStream, keyStorePassword, keyStoreType);
        return this;
    }

    public HtmlUnitDriverOptions setSSLTrustStore(URL sslTrustStoreUrl, String sslTrustStorePassword, String sslTrustStoreType) {
        Require.nonNull((String)"Trust store URL", (Object)sslTrustStoreUrl);
        this.webClientOptions_.setSSLTrustStore(sslTrustStoreUrl, sslTrustStorePassword, sslTrustStoreType);
        return this;
    }

    private void importOptions(Object rawOptions) {
        HashMap<String, Object> optionsMap = new HashMap();
        if (rawOptions != null) {
            Require.stateCondition((boolean)(rawOptions instanceof Map), (String)"Specified value must be 'Map'; was %s", (Object[])new Object[]{rawOptions.getClass().getName()});
            optionsMap = (Map)rawOptions;
        }
        for (HtmlUnitOption option : HtmlUnitOption.values()) {
            option.applyPropertyTo(optionsMap);
        }
        if (!optionsMap.isEmpty()) {
            block5: for (HtmlUnitOption option : HtmlUnitOption.values()) {
                if (!optionsMap.containsKey(option.getCapabilityKey())) continue;
                switch (option) {
                    case SSL_CLIENT_CERTIFICATE_PASSWORD: 
                    case SSL_TRUST_STORE_PASSWORD: {
                        continue block5;
                    }
                    case WEB_CLIENT_VERSION: {
                        this.webClientVersion_ = (BrowserVersion)option.decode(optionsMap.get(option.getCapabilityKey()));
                        continue block5;
                    }
                    default: {
                        option.insert(this.webClientOptions_, optionsMap.get(option.getCapabilityKey()));
                    }
                }
            }
        }
    }

    private Map<String, Object> exportOptions() {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>();
        block4: for (HtmlUnitOption option : HtmlUnitOption.values()) {
            switch (option) {
                case SSL_CLIENT_CERTIFICATE_PASSWORD: 
                case SSL_TRUST_STORE_PASSWORD: {
                    continue block4;
                }
                case WEB_CLIENT_VERSION: {
                    if (this.webClientVersion_ == null) continue block4;
                    optionsMap.put(option.getCapabilityKey(), option.encode(this.webClientVersion_));
                    continue block4;
                }
                default: {
                    Object value = option.obtain(this.webClientOptions_);
                    if (option.isDefaultValue(value)) continue block4;
                    optionsMap.put(option.getCapabilityKey(), option.encode(value));
                }
            }
        }
        return optionsMap;
    }

    private static void transfer(WebClientOptions source, WebClientOptions target) {
        Require.nonNull((String)"Source capabilities", (Object)source);
        Require.nonNull((String)"Target capabilities", (Object)target);
        target.setJavaScriptEnabled(source.isJavaScriptEnabled());
        target.setCssEnabled(source.isCssEnabled());
        target.setPrintContentOnFailingStatusCode(source.isPrintContentOnFailingStatusCode());
        target.setThrowExceptionOnFailingStatusCode(source.isThrowExceptionOnFailingStatusCode());
        target.setThrowExceptionOnScriptError(source.isThrowExceptionOnScriptError());
        target.setPopupBlockerEnabled(source.isPopupBlockerEnabled());
        target.setRedirectEnabled(source.isRedirectEnabled());
        try {
            target.setTempFileDirectory(source.getTempFileDirectory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        target.setSSLClientProtocols(source.getSSLClientProtocols());
        target.setSSLClientCipherSuites(source.getSSLClientCipherSuites());
        target.setGeolocationEnabled(source.isGeolocationEnabled());
        target.setDoNotTrackEnabled(source.isDoNotTrackEnabled());
        target.setHomePage(source.getHomePage());
        ProxyConfig proxyConfig = source.getProxyConfig();
        if (proxyConfig != null) {
            target.setProxyConfig(proxyConfig);
        }
        target.setTimeout(source.getTimeout());
        target.setConnectionTimeToLive(source.getConnectionTimeToLive());
        target.setUseInsecureSSL(source.isUseInsecureSSL());
        target.setSSLInsecureProtocol(source.getSSLInsecureProtocol());
        target.setMaxInMemory(source.getMaxInMemory());
        target.setHistorySizeLimit(source.getHistorySizeLimit());
        target.setHistoryPageCacheLimit(source.getHistoryPageCacheLimit());
        target.setLocalAddress(source.getLocalAddress());
        target.setDownloadImages(source.isDownloadImages());
        target.setScreenWidth(source.getScreenWidth());
        target.setScreenHeight(source.getScreenHeight());
        target.setWebSocketEnabled(source.isWebSocketEnabled());
        target.setWebSocketMaxTextMessageSize(source.getWebSocketMaxTextMessageSize());
        target.setWebSocketMaxTextMessageBufferSize(source.getWebSocketMaxTextMessageBufferSize());
        target.setWebSocketMaxBinaryMessageSize(source.getWebSocketMaxBinaryMessageSize());
        target.setWebSocketMaxBinaryMessageBufferSize(source.getWebSocketMaxBinaryMessageBufferSize());
        target.setFetchPolyfillEnabled(source.isFetchPolyfillEnabled());
    }
}

