/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.auto.service.AutoService;
import java.time.Duration;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumNetworkConditions;
import org.openqa.selenium.chromium.HasNetworkConditions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasNetworkConditions
implements AugmenterProvider<HasNetworkConditions>,
AdditionalHttpCommands {
    public static final String GET_NETWORK_CONDITIONS = "getNetworkConditions";
    public static final String SET_NETWORK_CONDITIONS = "setNetworkConditions";
    public static final String DELETE_NETWORK_CONDITIONS = "deleteNetworkConditions";
    private static final Map<String, CommandInfo> COMMANDS = Map.of("getNetworkConditions", new CommandInfo("/session/:sessionId/chromium/network_conditions", HttpMethod.GET), "setNetworkConditions", new CommandInfo("/session/:sessionId/chromium/network_conditions", HttpMethod.POST), "deleteNetworkConditions", new CommandInfo("/session/:sessionId/chromium/network_conditions", HttpMethod.DELETE));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return caps -> ChromiumDriver.IS_CHROMIUM_BROWSER.test(caps.getBrowserName());
    }

    public Class<HasNetworkConditions> getDescribedInterface() {
        return HasNetworkConditions.class;
    }

    public HasNetworkConditions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasNetworkConditions(){

            @Override
            public ChromiumNetworkConditions getNetworkConditions() {
                Map result = (Map)executeMethod.execute(AddHasNetworkConditions.GET_NETWORK_CONDITIONS, null);
                ChromiumNetworkConditions networkConditions = new ChromiumNetworkConditions();
                networkConditions.setOffline(result.getOrDefault("offline", false));
                networkConditions.setLatency(Duration.ofMillis((Long)((Object)result.getOrDefault("latency", 0))));
                networkConditions.setDownloadThroughput(((Number)result.getOrDefault("download_throughput", -1)).intValue());
                networkConditions.setUploadThroughput(((Number)result.getOrDefault("upload_throughput", -1)).intValue());
                return networkConditions;
            }

            @Override
            public void setNetworkConditions(ChromiumNetworkConditions networkConditions) {
                Require.nonNull((String)"Network Conditions", (Object)networkConditions);
                Map<String, Integer> conditions = Map.of("offline", networkConditions.getOffline(), "latency", networkConditions.getLatency().toMillis(), "download_throughput", networkConditions.getDownloadThroughput(), "upload_throughput", networkConditions.getUploadThroughput());
                executeMethod.execute(AddHasNetworkConditions.SET_NETWORK_CONDITIONS, Map.of("network_conditions", conditions));
            }

            @Override
            public void deleteNetworkConditions() {
                executeMethod.execute(AddHasNetworkConditions.DELETE_NETWORK_CONDITIONS, null);
            }
        };
    }
}

