/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.domsnapshot.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v113.domsnapshot.model.ArrayOfStrings;
import org.openqa.selenium.devtools.v113.domsnapshot.model.RareBooleanData;
import org.openqa.selenium.devtools.v113.domsnapshot.model.Rectangle;
import org.openqa.selenium.devtools.v113.domsnapshot.model.StringIndex;
import org.openqa.selenium.json.JsonInput;

public class LayoutTreeSnapshot {
    private final List<Integer> nodeIndex;
    private final List<ArrayOfStrings> styles;
    private final List<Rectangle> bounds;
    private final List<StringIndex> text;
    private final RareBooleanData stackingContexts;
    private final Optional<List<Integer>> paintOrders;
    private final Optional<List<Rectangle>> offsetRects;
    private final Optional<List<Rectangle>> scrollRects;
    private final Optional<List<Rectangle>> clientRects;
    private final Optional<List<StringIndex>> blendedBackgroundColors;
    private final Optional<List<Number>> textColorOpacities;

    public LayoutTreeSnapshot(List<Integer> nodeIndex, List<ArrayOfStrings> styles, List<Rectangle> bounds, List<StringIndex> text, RareBooleanData stackingContexts, Optional<List<Integer>> paintOrders, Optional<List<Rectangle>> offsetRects, Optional<List<Rectangle>> scrollRects, Optional<List<Rectangle>> clientRects, Optional<List<StringIndex>> blendedBackgroundColors, Optional<List<Number>> textColorOpacities) {
        this.nodeIndex = Objects.requireNonNull(nodeIndex, "nodeIndex is required");
        this.styles = Objects.requireNonNull(styles, "styles is required");
        this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.stackingContexts = Objects.requireNonNull(stackingContexts, "stackingContexts is required");
        this.paintOrders = paintOrders;
        this.offsetRects = offsetRects;
        this.scrollRects = scrollRects;
        this.clientRects = clientRects;
        this.blendedBackgroundColors = blendedBackgroundColors;
        this.textColorOpacities = textColorOpacities;
    }

    public List<Integer> getNodeIndex() {
        return this.nodeIndex;
    }

    public List<ArrayOfStrings> getStyles() {
        return this.styles;
    }

    public List<Rectangle> getBounds() {
        return this.bounds;
    }

    public List<StringIndex> getText() {
        return this.text;
    }

    public RareBooleanData getStackingContexts() {
        return this.stackingContexts;
    }

    public Optional<List<Integer>> getPaintOrders() {
        return this.paintOrders;
    }

    public Optional<List<Rectangle>> getOffsetRects() {
        return this.offsetRects;
    }

    public Optional<List<Rectangle>> getScrollRects() {
        return this.scrollRects;
    }

    public Optional<List<Rectangle>> getClientRects() {
        return this.clientRects;
    }

    @Beta
    public Optional<List<StringIndex>> getBlendedBackgroundColors() {
        return this.blendedBackgroundColors;
    }

    @Beta
    public Optional<List<Number>> getTextColorOpacities() {
        return this.textColorOpacities;
    }

    private static LayoutTreeSnapshot fromJson(JsonInput input) {
        List nodeIndex = null;
        List styles = null;
        List bounds = null;
        List text = null;
        RareBooleanData stackingContexts = null;
        Optional<List<Integer>> paintOrders = Optional.empty();
        Optional<List<Rectangle>> offsetRects = Optional.empty();
        Optional<List<Rectangle>> scrollRects = Optional.empty();
        Optional<List<Rectangle>> clientRects = Optional.empty();
        Optional<List<StringIndex>> blendedBackgroundColors = Optional.empty();
        Optional<List<Number>> textColorOpacities = Optional.empty();
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeIndex": {
                    nodeIndex = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block26;
                }
                case "styles": {
                    styles = (List)input.read(new TypeToken<List<ArrayOfStrings>>(){}.getType());
                    continue block26;
                }
                case "bounds": {
                    bounds = (List)input.read(new TypeToken<List<Rectangle>>(){}.getType());
                    continue block26;
                }
                case "text": {
                    text = (List)input.read(new TypeToken<List<StringIndex>>(){}.getType());
                    continue block26;
                }
                case "stackingContexts": {
                    stackingContexts = (RareBooleanData)input.read(RareBooleanData.class);
                    continue block26;
                }
                case "paintOrders": {
                    paintOrders = Optional.ofNullable((List)input.read(new TypeToken<List<Integer>>(){}.getType()));
                    continue block26;
                }
                case "offsetRects": {
                    offsetRects = Optional.ofNullable((List)input.read(new TypeToken<List<Rectangle>>(){}.getType()));
                    continue block26;
                }
                case "scrollRects": {
                    scrollRects = Optional.ofNullable((List)input.read(new TypeToken<List<Rectangle>>(){}.getType()));
                    continue block26;
                }
                case "clientRects": {
                    clientRects = Optional.ofNullable((List)input.read(new TypeToken<List<Rectangle>>(){}.getType()));
                    continue block26;
                }
                case "blendedBackgroundColors": {
                    blendedBackgroundColors = Optional.ofNullable((List)input.read(new TypeToken<List<StringIndex>>(){}.getType()));
                    continue block26;
                }
                case "textColorOpacities": {
                    textColorOpacities = Optional.ofNullable((List)input.read(new TypeToken<List<Number>>(){}.getType()));
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutTreeSnapshot(nodeIndex, styles, bounds, text, stackingContexts, paintOrders, offsetRects, scrollRects, clientRects, blendedBackgroundColors, textColorOpacities);
    }
}

