/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.preload.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v113.page.model.FrameId;
import org.openqa.selenium.devtools.v113.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v113.preload.model.PrerenderFinalStatus;
import org.openqa.selenium.json.JsonInput;

public class PrerenderAttemptCompleted {
    private final PreloadingAttemptKey key;
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PrerenderFinalStatus finalStatus;
    private final Optional<String> disallowedApiMethod;

    public PrerenderAttemptCompleted(PreloadingAttemptKey key, FrameId initiatingFrameId, String prerenderingUrl, PrerenderFinalStatus finalStatus, Optional<String> disallowedApiMethod) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = Objects.requireNonNull(finalStatus, "finalStatus is required");
        this.disallowedApiMethod = disallowedApiMethod;
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PrerenderFinalStatus getFinalStatus() {
        return this.finalStatus;
    }

    public Optional<String> getDisallowedApiMethod() {
        return this.disallowedApiMethod;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PrerenderFinalStatus finalStatus = null;
        Optional<String> disallowedApiMethod = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read(PreloadingAttemptKey.class);
                    continue block14;
                }
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block14;
                }
                case "finalStatus": {
                    finalStatus = (PrerenderFinalStatus)((Object)input.read(PrerenderFinalStatus.class));
                    continue block14;
                }
                case "disallowedApiMethod": {
                    disallowedApiMethod = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderAttemptCompleted(key, initiatingFrameId, prerenderingUrl, finalStatus, disallowedApiMethod);
    }
}

