package org.openqa.selenium.devtools.v121.autofill.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines how an address can be displayed like in chrome://settings/addresses.
 * Address UI is a two dimensional array, each inner array is an "address information line", and when rendered in a UI surface should be displayed as such.
 * The following address UI for instance:
 * [[{name: "GIVE_NAME", value: "Jon"}, {name: "FAMILY_NAME", value: "Doe"}], [{name: "CITY", value: "Munich"}, {name: "ZIP", value: "81456"}]]
 * should allow the receiver to render:
 * Jon Doe
 * Munich 81456
 */
public class AddressUI {

    private final java.util.List<org.openqa.selenium.devtools.v121.autofill.model.AddressFields> addressFields;

    public AddressUI(java.util.List<org.openqa.selenium.devtools.v121.autofill.model.AddressFields> addressFields) {
        this.addressFields = java.util.Objects.requireNonNull(addressFields, "addressFields is required");
    }

    /**
     * A two dimension array containing the repesentation of values from an address profile.
     */
    public java.util.List<org.openqa.selenium.devtools.v121.autofill.model.AddressFields> getAddressFields() {
        return addressFields;
    }

    private static AddressUI fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v121.autofill.model.AddressFields> addressFields = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "addressFields":
                    addressFields = input.readArray(org.openqa.selenium.devtools.v121.autofill.model.AddressFields.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AddressUI(addressFields);
    }
}
