package org.openqa.selenium.devtools.v121.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An object providing the result of a network resource load.
 */
@org.openqa.selenium.Beta()
public class LoadNetworkResourcePageResult {

    private final java.lang.Boolean success;

    private final java.util.Optional<java.lang.Number> netError;

    private final java.util.Optional<java.lang.String> netErrorName;

    private final java.util.Optional<java.lang.Number> httpStatusCode;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.io.model.StreamHandle> stream;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.network.model.Headers> headers;

    public LoadNetworkResourcePageResult(java.lang.Boolean success, java.util.Optional<java.lang.Number> netError, java.util.Optional<java.lang.String> netErrorName, java.util.Optional<java.lang.Number> httpStatusCode, java.util.Optional<org.openqa.selenium.devtools.v121.io.model.StreamHandle> stream, java.util.Optional<org.openqa.selenium.devtools.v121.network.model.Headers> headers) {
        this.success = java.util.Objects.requireNonNull(success, "success is required");
        this.netError = netError;
        this.netErrorName = netErrorName;
        this.httpStatusCode = httpStatusCode;
        this.stream = stream;
        this.headers = headers;
    }

    public java.lang.Boolean getSuccess() {
        return success;
    }

    /**
     * Optional values used for error reporting.
     */
    public java.util.Optional<java.lang.Number> getNetError() {
        return netError;
    }

    public java.util.Optional<java.lang.String> getNetErrorName() {
        return netErrorName;
    }

    public java.util.Optional<java.lang.Number> getHttpStatusCode() {
        return httpStatusCode;
    }

    /**
     * If successful, one of the following two fields holds the result.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.io.model.StreamHandle> getStream() {
        return stream;
    }

    /**
     * Response headers.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.network.model.Headers> getHeaders() {
        return headers;
    }

    private static LoadNetworkResourcePageResult fromJson(JsonInput input) {
        java.lang.Boolean success = false;
        java.util.Optional<java.lang.Number> netError = java.util.Optional.empty();
        java.util.Optional<java.lang.String> netErrorName = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> httpStatusCode = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.io.model.StreamHandle> stream = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.network.model.Headers> headers = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "success":
                    success = input.nextBoolean();
                    break;
                case "netError":
                    netError = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "netErrorName":
                    netErrorName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "httpStatusCode":
                    httpStatusCode = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "stream":
                    stream = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.io.model.StreamHandle.class));
                    break;
                case "headers":
                    headers = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.network.model.Headers.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LoadNetworkResourcePageResult(success, netError, netErrorName, httpStatusCode, stream, headers);
    }
}
