package org.openqa.selenium.devtools.v121.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Object property descriptor.
 */
public class PropertyDescriptor {

    private final java.lang.String name;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> value;

    private final java.util.Optional<java.lang.Boolean> writable;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> get;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> set;

    private final java.lang.Boolean configurable;

    private final java.lang.Boolean enumerable;

    private final java.util.Optional<java.lang.Boolean> wasThrown;

    private final java.util.Optional<java.lang.Boolean> isOwn;

    private final java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> symbol;

    public PropertyDescriptor(java.lang.String name, java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> value, java.util.Optional<java.lang.Boolean> writable, java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> get, java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> set, java.lang.Boolean configurable, java.lang.Boolean enumerable, java.util.Optional<java.lang.Boolean> wasThrown, java.util.Optional<java.lang.Boolean> isOwn, java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> symbol) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = value;
        this.writable = writable;
        this.get = get;
        this.set = set;
        this.configurable = java.util.Objects.requireNonNull(configurable, "configurable is required");
        this.enumerable = java.util.Objects.requireNonNull(enumerable, "enumerable is required");
        this.wasThrown = wasThrown;
        this.isOwn = isOwn;
        this.symbol = symbol;
    }

    /**
     * Property name or symbol description.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * The value associated with the property.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> getValue() {
        return value;
    }

    /**
     * True if the value associated with the property may be changed (data descriptors only).
     */
    public java.util.Optional<java.lang.Boolean> getWritable() {
        return writable;
    }

    /**
     * A function which serves as a getter for the property, or `undefined` if there is no getter
     * (accessor descriptors only).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> getGet() {
        return get;
    }

    /**
     * A function which serves as a setter for the property, or `undefined` if there is no setter
     * (accessor descriptors only).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> getSet() {
        return set;
    }

    /**
     * True if the type of this property descriptor may be changed and if the property may be
     * deleted from the corresponding object.
     */
    public java.lang.Boolean getConfigurable() {
        return configurable;
    }

    /**
     * True if this property shows up during enumeration of the properties on the corresponding
     * object.
     */
    public java.lang.Boolean getEnumerable() {
        return enumerable;
    }

    /**
     * True if the result was thrown during the evaluation.
     */
    public java.util.Optional<java.lang.Boolean> getWasThrown() {
        return wasThrown;
    }

    /**
     * True if the property is owned for the object.
     */
    public java.util.Optional<java.lang.Boolean> getIsOwn() {
        return isOwn;
    }

    /**
     * Property symbol object, if the property is of the `symbol` type.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> getSymbol() {
        return symbol;
    }

    private static PropertyDescriptor fromJson(JsonInput input) {
        java.lang.String name = null;
        java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> value = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> writable = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> get = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> set = java.util.Optional.empty();
        java.lang.Boolean configurable = false;
        java.lang.Boolean enumerable = false;
        java.util.Optional<java.lang.Boolean> wasThrown = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isOwn = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v121.runtime.model.RemoteObject> symbol = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.runtime.model.RemoteObject.class));
                    break;
                case "writable":
                    writable = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "get":
                    get = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.runtime.model.RemoteObject.class));
                    break;
                case "set":
                    set = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.runtime.model.RemoteObject.class));
                    break;
                case "configurable":
                    configurable = input.nextBoolean();
                    break;
                case "enumerable":
                    enumerable = input.nextBoolean();
                    break;
                case "wasThrown":
                    wasThrown = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "isOwn":
                    isOwn = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "symbol":
                    symbol = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v121.runtime.model.RemoteObject.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PropertyDescriptor(name, value, writable, get, set, configurable, enumerable, wasThrown, isOwn, symbol);
    }
}
