package org.openqa.selenium.devtools.v122.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Pseudo element type.
 */
public enum PseudoType {

    FIRST_LINE("first-line"),
    FIRST_LETTER("first-letter"),
    BEFORE("before"),
    AFTER("after"),
    MARKER("marker"),
    BACKDROP("backdrop"),
    SELECTION("selection"),
    TARGET_TEXT("target-text"),
    SPELLING_ERROR("spelling-error"),
    GRAMMAR_ERROR("grammar-error"),
    HIGHLIGHT("highlight"),
    FIRST_LINE_INHERITED("first-line-inherited"),
    SCROLLBAR("scrollbar"),
    SCROLLBAR_THUMB("scrollbar-thumb"),
    SCROLLBAR_BUTTON("scrollbar-button"),
    SCROLLBAR_TRACK("scrollbar-track"),
    SCROLLBAR_TRACK_PIECE("scrollbar-track-piece"),
    SCROLLBAR_CORNER("scrollbar-corner"),
    RESIZER("resizer"),
    INPUT_LIST_BUTTON("input-list-button"),
    VIEW_TRANSITION("view-transition"),
    VIEW_TRANSITION_GROUP("view-transition-group"),
    VIEW_TRANSITION_IMAGE_PAIR("view-transition-image-pair"),
    VIEW_TRANSITION_OLD("view-transition-old"),
    VIEW_TRANSITION_NEW("view-transition-new");

    private String value;

    PseudoType(String value) {
        this.value = value;
    }

    public static PseudoType fromString(String s) {
        return java.util.Arrays.stream(PseudoType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PseudoType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PseudoType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
