package org.openqa.selenium.devtools.v122.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Origin Trial(https://www.chromium.org/blink/origin-trials) support.
 * Status for an Origin Trial token.
 */
@org.openqa.selenium.Beta()
public enum OriginTrialTokenStatus {

    SUCCESS("Success"),
    NOTSUPPORTED("NotSupported"),
    INSECURE("Insecure"),
    EXPIRED("Expired"),
    WRONGORIGIN("WrongOrigin"),
    INVALIDSIGNATURE("InvalidSignature"),
    MALFORMED("Malformed"),
    WRONGVERSION("WrongVersion"),
    FEATUREDISABLED("FeatureDisabled"),
    TOKENDISABLED("TokenDisabled"),
    FEATUREDISABLEDFORUSER("FeatureDisabledForUser"),
    UNKNOWNTRIAL("UnknownTrial");

    private String value;

    OriginTrialTokenStatus(String value) {
        this.value = value;
    }

    public static OriginTrialTokenStatus fromString(String s) {
        return java.util.Arrays.stream(OriginTrialTokenStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within OriginTrialTokenStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static OriginTrialTokenStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
