/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.debugger.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v124.debugger.model.ScriptPosition;
import org.openqa.selenium.devtools.v124.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LocationRange {
    private final ScriptId scriptId;
    private final ScriptPosition start;
    private final ScriptPosition end;

    public LocationRange(ScriptId scriptId, ScriptPosition start, ScriptPosition end) {
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.start = Objects.requireNonNull(start, "start is required");
        this.end = Objects.requireNonNull(end, "end is required");
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public ScriptPosition getStart() {
        return this.start;
    }

    public ScriptPosition getEnd() {
        return this.end;
    }

    private static LocationRange fromJson(JsonInput input) {
        ScriptId scriptId = null;
        ScriptPosition start = null;
        ScriptPosition end = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block10;
                }
                case "start": {
                    start = (ScriptPosition)input.read(ScriptPosition.class);
                    continue block10;
                }
                case "end": {
                    end = (ScriptPosition)input.read(ScriptPosition.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LocationRange(scriptId, start, end);
    }
}

