package org.openqa.selenium.devtools.v126.audits;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Audits domain allows investigation of page violations and possible improvements.
 */
@Beta()
public class Audits {

    public static class GetEncodedResponseResponse {

        private final java.util.Optional<java.lang.String> body;

        private final java.lang.Integer originalSize;

        private final java.lang.Integer encodedSize;

        public GetEncodedResponseResponse(java.util.Optional<java.lang.String> body, java.lang.Integer originalSize, java.lang.Integer encodedSize) {
            this.body = body;
            this.originalSize = java.util.Objects.requireNonNull(originalSize, "originalSize is required");
            this.encodedSize = java.util.Objects.requireNonNull(encodedSize, "encodedSize is required");
        }

        /**
         * The encoded body as a base64 string. Omitted if sizeOnly is true.
         */
        public java.util.Optional<java.lang.String> getBody() {
            return body;
        }

        /**
         * Size before re-encoding.
         */
        public java.lang.Integer getOriginalSize() {
            return originalSize;
        }

        /**
         * Size after re-encoding.
         */
        public java.lang.Integer getEncodedSize() {
            return encodedSize;
        }

        private static GetEncodedResponseResponse fromJson(JsonInput input) {
            java.util.Optional<java.lang.String> body = java.util.Optional.empty();
            java.lang.Integer originalSize = 0;
            java.lang.Integer encodedSize = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "body":
                        body = java.util.Optional.ofNullable(input.nextString());
                        break;
                    case "originalSize":
                        originalSize = input.nextNumber().intValue();
                        break;
                    case "encodedSize":
                        encodedSize = input.nextNumber().intValue();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetEncodedResponseResponse(body, originalSize, encodedSize);
        }
    }

    public enum GetEncodedResponseEncoding {

        WEBP("webp"), JPEG("jpeg"), PNG("png");

        private String value;

        GetEncodedResponseEncoding(String value) {
            this.value = value;
        }

        public static GetEncodedResponseEncoding fromString(String s) {
            return java.util.Arrays.stream(GetEncodedResponseEncoding.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within GetEncodedResponseEncoding "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static GetEncodedResponseEncoding fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    /**
     * Returns the response body and size if it were re-encoded with the specified settings. Only
     * applies to images.
     */
    public static Command<org.openqa.selenium.devtools.v126.audits.Audits.GetEncodedResponseResponse> getEncodedResponse(org.openqa.selenium.devtools.v126.network.model.RequestId requestId, GetEncodedResponseEncoding encoding, java.util.Optional<java.lang.Number> quality, java.util.Optional<java.lang.Boolean> sizeOnly) {
        java.util.Objects.requireNonNull(requestId, "requestId is required");
        java.util.Objects.requireNonNull(encoding, "encoding is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("requestId", requestId);
        params.put("encoding", encoding);
        quality.ifPresent(p -> params.put("quality", p));
        sizeOnly.ifPresent(p -> params.put("sizeOnly", p));
        return new Command<>("Audits.getEncodedResponse", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v126.audits.Audits.GetEncodedResponseResponse.class));
    }

    /**
     * Disables issues domain, prevents further issues from being reported to the client.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Audits.disable", Map.copyOf(params));
    }

    /**
     * Enables issues domain, sends the issues collected so far to the client by means of the
     * `issueAdded` event.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Audits.enable", Map.copyOf(params));
    }

    /**
     * Runs the contrast check for the target page. Found issues are reported
     * using Audits.issueAdded event.
     */
    public static Command<Void> checkContrast(java.util.Optional<java.lang.Boolean> reportAAA) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        reportAAA.ifPresent(p -> params.put("reportAAA", p));
        return new Command<>("Audits.checkContrast", Map.copyOf(params));
    }

    /**
     * Runs the form issues check for the target page. Found issues are reported
     * using Audits.issueAdded event.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v126.audits.model.GenericIssueDetails>> checkFormsIssues() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Audits.checkFormsIssues", Map.copyOf(params), ConverterFunctions.map("formIssues", input -> input.readArray(org.openqa.selenium.devtools.v126.audits.model.GenericIssueDetails.class)));
    }

    public static Event<org.openqa.selenium.devtools.v126.audits.model.InspectorIssue> issueAdded() {
        return new Event<>("Audits.issueAdded", ConverterFunctions.map("issue", org.openqa.selenium.devtools.v126.audits.model.InspectorIssue.class));
    }
}
