/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v126.security.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v126.security.model.MixedContentType;
import org.openqa.selenium.devtools.v126.security.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

public class SecurityStateExplanation {
    private final SecurityState securityState;
    private final String title;
    private final String summary;
    private final String description;
    private final MixedContentType mixedContentType;
    private final List<String> certificate;
    private final Optional<List<String>> recommendations;

    public SecurityStateExplanation(SecurityState securityState, String title, String summary, String description, MixedContentType mixedContentType, List<String> certificate, Optional<List<String>> recommendations) {
        this.securityState = Objects.requireNonNull(securityState, "securityState is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.summary = Objects.requireNonNull(summary, "summary is required");
        this.description = Objects.requireNonNull(description, "description is required");
        this.mixedContentType = Objects.requireNonNull(mixedContentType, "mixedContentType is required");
        this.certificate = Objects.requireNonNull(certificate, "certificate is required");
        this.recommendations = recommendations;
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public MixedContentType getMixedContentType() {
        return this.mixedContentType;
    }

    public List<String> getCertificate() {
        return this.certificate;
    }

    public Optional<List<String>> getRecommendations() {
        return this.recommendations;
    }

    private static SecurityStateExplanation fromJson(JsonInput input) {
        SecurityState securityState = null;
        String title = null;
        String summary = null;
        String description = null;
        MixedContentType mixedContentType = null;
        List certificate = null;
        Optional<List<String>> recommendations = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "securityState": {
                    securityState = (SecurityState)((Object)input.read(SecurityState.class));
                    continue block18;
                }
                case "title": {
                    title = input.nextString();
                    continue block18;
                }
                case "summary": {
                    summary = input.nextString();
                    continue block18;
                }
                case "description": {
                    description = input.nextString();
                    continue block18;
                }
                case "mixedContentType": {
                    mixedContentType = (MixedContentType)((Object)input.read(MixedContentType.class));
                    continue block18;
                }
                case "certificate": {
                    certificate = input.readArray(String.class);
                    continue block18;
                }
                case "recommendations": {
                    recommendations = Optional.ofNullable(input.readArray(String.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SecurityStateExplanation(securityState, title, summary, description, mixedContentType, certificate, recommendations);
    }
}

