package org.openqa.selenium.devtools.v127.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AdFrameExplanation {

    PARENTISAD("ParentIsAd"), CREATEDBYADSCRIPT("CreatedByAdScript"), MATCHEDBLOCKINGRULE("MatchedBlockingRule");

    private String value;

    AdFrameExplanation(String value) {
        this.value = value;
    }

    public static AdFrameExplanation fromString(String s) {
        return java.util.Arrays.stream(AdFrameExplanation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AdFrameExplanation "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AdFrameExplanation fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
