package org.openqa.selenium.devtools.v128.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Number of milliseconds since epoch.
 */
public class Timestamp {

    private final java.lang.Number timestamp;

    public Timestamp(java.lang.Number timestamp) {
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "Missing value for Timestamp");
    }

    private static Timestamp fromJson(JsonInput input) {
        return new Timestamp(input.nextNumber());
    }

    public Number toJson() {
        return timestamp;
    }

    public String toString() {
        return timestamp.toString();
    }
}
