/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.bluetoothemulation.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v129.bluetoothemulation.model.ScanRecord;
import org.openqa.selenium.json.JsonInput;

public class ScanEntry {
    private final String deviceAddress;
    private final Integer rssi;
    private final ScanRecord scanRecord;

    public ScanEntry(String deviceAddress, Integer rssi, ScanRecord scanRecord) {
        this.deviceAddress = Objects.requireNonNull(deviceAddress, "deviceAddress is required");
        this.rssi = Objects.requireNonNull(rssi, "rssi is required");
        this.scanRecord = Objects.requireNonNull(scanRecord, "scanRecord is required");
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public ScanRecord getScanRecord() {
        return this.scanRecord;
    }

    private static ScanEntry fromJson(JsonInput input) {
        String deviceAddress = null;
        Integer rssi = 0;
        ScanRecord scanRecord = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "deviceAddress": {
                    deviceAddress = input.nextString();
                    continue block10;
                }
                case "rssi": {
                    rssi = input.nextNumber().intValue();
                    continue block10;
                }
                case "scanRecord": {
                    scanRecord = (ScanRecord)input.read(ScanRecord.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScanEntry(deviceAddress, rssi, scanRecord);
    }
}

